/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchScrollQueryAndFetchAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final SearchServiceTransportAction searchService;
    private final SearchPhaseController searchPhaseController;

    @Inject
    public TransportSearchScrollQueryAndFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    public void execute(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
        new AsyncAction(request, scrollId, listener).start();
    }

    private class AsyncAction {
        private final SearchScrollRequest request;
        private final ActionListener<SearchResponse> listener;
        private final ParsedScrollId scrollId;
        private final DiscoveryNodes nodes;
        private volatile AtomicArray<ShardSearchFailure> shardFailures;
        private final AtomicArray<QueryFetchSearchResult> queryFetchResults;
        private final AtomicInteger successfulOps;
        private final AtomicInteger counter;
        private final long startTime = System.currentTimeMillis();

        private AsyncAction(SearchScrollRequest request, ParsedScrollId scrollId, ActionListener<SearchResponse> listener) {
            this.request = request;
            this.listener = listener;
            this.scrollId = scrollId;
            this.nodes = TransportSearchScrollQueryAndFetchAction.this.clusterService.state().nodes();
            this.successfulOps = new AtomicInteger(scrollId.getContext().length);
            this.counter = new AtomicInteger(scrollId.getContext().length);
            this.queryFetchResults = new AtomicArray(scrollId.getContext().length);
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            if (this.shardFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            List<AtomicArray.Entry<ShardSearchFailure>> entries = this.shardFailures.asList();
            ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
            for (int i = 0; i < failures.length; ++i) {
                failures[i] = (ShardSearchFailure)entries.get((int)i).value;
            }
            return failures;
        }

        protected final void addShardFailure(int shardIndex, ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = new AtomicArray(this.scrollId.getContext().length);
            }
            this.shardFailures.set(shardIndex, failure);
        }

        public void start() {
            if (this.scrollId.getContext().length == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", null));
                return;
            }
            int localOperations = 0;
            Tuple<String, Long>[] context = this.scrollId.getContext();
            for (int i = 0; i < context.length; ++i) {
                Tuple<String, Long> target = context[i];
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) {
                    if (this.nodes.localNodeId().equals(node.id())) {
                        ++localOperations;
                        continue;
                    }
                    this.executePhase(i, node, target.v2());
                    continue;
                }
                if (TransportSearchScrollQueryAndFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollQueryAndFetchAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchScrollQueryAndFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            Tuple<String, Long>[] context1 = AsyncAction.this.scrollId.getContext();
                            for (int i = 0; i < context1.length; ++i) {
                                Tuple<String, Long> target = context1[i];
                                DiscoveryNode node = AsyncAction.this.nodes.get(target.v1());
                                if (node == null || !AsyncAction.this.nodes.localNodeId().equals(node.id())) continue;
                                AsyncAction.this.executePhase(i, node, target.v2());
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    Tuple<String, Long>[] context1 = this.scrollId.getContext();
                    for (int i = 0; i < context1.length; ++i) {
                        final Tuple<String, Long> target = context1[i];
                        final int shardIndex = i;
                        final DiscoveryNode node = this.nodes.get(target.v1());
                        if (node == null || !this.nodes.localNodeId().equals(node.id())) continue;
                        try {
                            if (localAsync) {
                                TransportSearchScrollQueryAndFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncAction.this.executePhase(shardIndex, node, (Long)target.v2());
                                    }
                                });
                                continue;
                            }
                            this.executePhase(shardIndex, node, target.v2());
                            continue;
                        }
                        catch (Throwable t) {
                            this.onPhaseFailure(t, target.v2(), shardIndex);
                        }
                    }
                }
            }
            for (final Tuple<String, Long> target : this.scrollId.getContext()) {
                DiscoveryNode node = this.nodes.get(target.v1());
                if (node != null) continue;
                if (TransportSearchScrollQueryAndFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchScrollQueryAndFetchAction.this.logger.debug("Node [" + target.v1() + "] not available for scroll request [" + this.scrollId.getSource() + "]", new Object[0]);
                }
                this.successfulOps.decrementAndGet();
                if (this.counter.decrementAndGet() != 0) continue;
                this.finishHim();
            }
        }

        void executePhase(final int shardIndex, DiscoveryNode node, final long searchId) {
            TransportSearchScrollQueryAndFetchAction.this.searchService.sendExecuteFetch(node, TransportSearchHelper.internalScrollSearchRequest(searchId, this.request), new SearchServiceListener<QueryFetchSearchResult>(){

                @Override
                public void onResult(QueryFetchSearchResult result) {
                    AsyncAction.this.queryFetchResults.set(shardIndex, result);
                    if (AsyncAction.this.counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onPhaseFailure(t, searchId, shardIndex);
                }
            });
        }

        private void onPhaseFailure(Throwable t, long searchId, int shardIndex) {
            if (TransportSearchScrollQueryAndFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchScrollQueryAndFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, searchId);
            }
            this.addShardFailure(shardIndex, new ShardSearchFailure(t));
            this.successfulOps.decrementAndGet();
            if (this.counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        private void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                this.listener.onFailure(new ReduceSearchPhaseException("fetch", "", e, this.buildShardFailures()));
            }
        }

        private void innerFinishHim() {
            ScoreDoc[] sortedShardList = TransportSearchScrollQueryAndFetchAction.this.searchPhaseController.sortDocs(this.queryFetchResults);
            InternalSearchResponse internalResponse = TransportSearchScrollQueryAndFetchAction.this.searchPhaseController.merge(sortedShardList, this.queryFetchResults, this.queryFetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), System.currentTimeMillis() - this.startTime, this.buildShardFailures()));
        }
    }
}

