/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndexDeleteByQueryResponse
extends ActionResponse {
    private String index;
    private int successfulShards;
    private int failedShards;
    private ShardOperationFailedException[] failures;

    IndexDeleteByQueryResponse(String index, int successfulShards, int failedShards, List<ShardOperationFailedException> failures) {
        this.index = index;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.failures = failures == null || failures.isEmpty() ? new DefaultShardOperationFailedException[0] : failures.toArray(new ShardOperationFailedException[failures.size()]);
    }

    IndexDeleteByQueryResponse() {
    }

    public String getIndex() {
        return this.index;
    }

    public int getTotalShards() {
        return this.failedShards + this.successfulShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public ShardOperationFailedException[] getFailures() {
        return this.failures;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        int size = in.readVInt();
        this.failures = new ShardOperationFailedException[size];
        for (int i = 0; i < size; ++i) {
            this.failures[i] = DefaultShardOperationFailedException.readShardOperationFailed(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.failures.length);
        for (ShardOperationFailedException failure : this.failures) {
            failure.writeTo(out);
        }
    }
}

