/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import org.apache.chemistry.opencmis.client.api.SessionFactory;

public final class SessionFactoryFinder {
    private SessionFactoryFinder() {
    }

    public static SessionFactory find() throws ClassNotFoundException, InstantiationException {
        return SessionFactoryFinder.find("org.apache.chemistry.opencmis.client.SessionFactory", null);
    }

    public static SessionFactory find(String factoryId) throws ClassNotFoundException, InstantiationException {
        return SessionFactoryFinder.find(factoryId, null);
    }

    public static SessionFactory find(String factoryId, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException {
        return SessionFactoryFinder.find(factoryId, classLoader, "org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl");
    }

    private static SessionFactory find(String factoryId, ClassLoader classLoader, String fallbackClassName) throws ClassNotFoundException, InstantiationException {
        String serviceId;
        InputStream stream;
        ClassLoader cl = classLoader;
        if (cl == null && (cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = SessionFactoryFinder.class.getClassLoader();
        }
        String factoryClassName = null;
        if (factoryId != null && (factoryClassName = System.getProperty(factoryId)) == null && (stream = cl.getResourceAsStream(serviceId = "META-INF/services/" + factoryId)) != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                factoryClassName = reader.readLine();
                reader.close();
            }
            catch (IOException e) {
                factoryClassName = null;
            }
        }
        if (factoryClassName == null) {
            factoryClassName = fallbackClassName;
        }
        Class<?> clazz = cl.loadClass(factoryClassName);
        SessionFactory result = null;
        try {
            Method newInstanceMethod = clazz.getMethod("newInstance", new Class[0]);
            if (!SessionFactory.class.isAssignableFrom(newInstanceMethod.getReturnType())) {
                throw new ClassNotFoundException("newInstance() method does not return a SessionFactory object!");
            }
            try {
                result = (SessionFactory)newInstanceMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new InstantiationException("Could not create SessionFactory object!");
            }
        }
        catch (NoSuchMethodException nsme) {
            if (!SessionFactory.class.isAssignableFrom(clazz)) {
                throw new ClassNotFoundException("The class does not implemnt the SessionFactory interface!", nsme);
            }
            try {
                result = (SessionFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new InstantiationException("Could not create SessionFactory object!");
            }
        }
        return result;
    }
}

