/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Aliases {
    private Map<String, Map<String, String>> aliasMap;

    public Aliases(Map<String, Map<String, String>> aliasMap) {
        this.aliasMap = aliasMap;
    }

    public Aliases() {
        this.aliasMap = new HashMap<String, Map<String, String>>();
    }

    public Map<String, String> getCollectionAliasMap() {
        Map<String, String> cam = this.aliasMap.get("collection");
        if (cam == null) {
            return null;
        }
        return Collections.unmodifiableMap(cam);
    }

    public Map<String, Map<String, String>> getAliasMap() {
        return Collections.unmodifiableMap(this.aliasMap);
    }

    public int collectionAliasSize() {
        Map<String, String> cam = this.aliasMap.get("collection");
        if (cam == null) {
            return 0;
        }
        return cam.size();
    }

    public String toString() {
        return "Aliases [aliasMap=" + this.aliasMap + "]";
    }

    public String getCollectionAlias(String collectionName) {
        Map<String, String> cam = this.aliasMap.get("collection");
        if (cam == null) {
            return null;
        }
        return cam.get(collectionName);
    }
}

