/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.cache.impl;

import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.cache.CacheLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapCacheLevel
implements CacheLevel {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> fMap;
    private boolean fFallbackEnabled = false;
    private String fFallbackKey;
    private boolean fSingleValueEnabled = false;

    @Override
    public abstract void initialize(Map<String, String> var1);

    @Override
    public Object get(String key) {
        Object value = this.fMap.get(key);
        if (value == null && this.fFallbackEnabled) {
            value = this.fMap.get(this.fFallbackKey);
        }
        if (value == null && this.fSingleValueEnabled && this.fMap.size() == 1) {
            value = this.fMap.values().iterator().next();
        }
        return value;
    }

    @Override
    public void put(Object value, String key) {
        this.fMap.put(key, value);
    }

    @Override
    public void remove(String key) {
        this.fMap.remove(key);
    }

    protected Map<String, Object> getMap() {
        return this.fMap;
    }

    protected void setMap(Map<String, Object> map) {
        this.fMap = map;
    }

    protected void enableKeyFallback(String key) {
        this.fFallbackKey = key;
        this.fFallbackEnabled = true;
    }

    protected void disableKeyFallback() {
        this.fFallbackEnabled = false;
    }

    protected void enableSingeValueFallback() {
        this.fSingleValueEnabled = true;
    }

    protected void disableSingeValueFallback() {
        this.fSingleValueEnabled = false;
    }

    protected int getIntParameter(Map<String, String> parameters, String name, int defValue) {
        if (parameters == null) {
            return defValue;
        }
        String value = parameters.get(name);
        if (value == null || value.trim().length() == 0) {
            return defValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    protected float getFloatParameter(Map<String, String> parameters, String name, float defValue) {
        if (parameters == null) {
            return defValue;
        }
        String value = parameters.get(name);
        if (value == null || value.trim().length() == 0) {
            return defValue;
        }
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    protected boolean getBooleanParameter(Map<String, String> parameters, String name, boolean defValue) {
        if (parameters == null) {
            return defValue;
        }
        String value = parameters.get(name);
        if (value == null || value.trim().length() == 0) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }

    public String toString() {
        return this.fMap == null ? "[no map]" : this.fMap.toString();
    }
}

