/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.jndi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.eclipse.jetty.jndi.NamingUtil;
import org.eclipse.jetty.plus.jndi.NamingEntry;
import org.eclipse.jetty.util.log.Logger;

public class NamingEntryUtil {
    private static Logger __log = NamingUtil.__log;

    public static boolean bindToENC(Object scope, String asName, String mappedName) throws NamingException {
        NamingEntry entry;
        if (asName == null || asName.trim().equals("")) {
            throw new NamingException("No name for NamingEntry");
        }
        if (mappedName == null || "".equals(mappedName)) {
            mappedName = asName;
        }
        if ((entry = NamingEntryUtil.lookupNamingEntry(scope, mappedName)) == null) {
            return false;
        }
        entry.bindToENC(asName);
        return true;
    }

    public static NamingEntry lookupNamingEntry(Object scope, String jndiName) throws NamingException {
        NamingEntry entry = null;
        try {
            Name scopeName = NamingEntryUtil.getNameForScope(scope);
            InitialContext ic = new InitialContext();
            NameParser parser = ic.getNameParser("");
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(parser, jndiName);
            scopeName.addAll(namingEntryName);
            entry = (NamingEntry)ic.lookup(scopeName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return entry;
    }

    public static Object lookup(Object scope, String jndiName) throws NamingException {
        Name scopeName = NamingEntryUtil.getNameForScope(scope);
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        scopeName.addAll(parser.parse(jndiName));
        return ic.lookup(scopeName);
    }

    public static List<Object> lookupNamingEntries(Object scope, Class<?> clazz) throws NamingException {
        try {
            Context scopeContext = NamingEntryUtil.getContextForScope(scope);
            Context namingEntriesContext = (Context)scopeContext.lookup("__");
            ArrayList<Object> list = new ArrayList<Object>();
            NamingEntryUtil.lookupNamingEntries(list, namingEntriesContext, clazz);
            return list;
        }
        catch (NameNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public static Name makeNamingEntryName(NameParser parser, NamingEntry namingEntry) throws NamingException {
        return NamingEntryUtil.makeNamingEntryName(parser, namingEntry == null ? null : namingEntry.getJndiName());
    }

    public static Name makeNamingEntryName(NameParser parser, String jndiName) throws NamingException {
        if (jndiName == null) {
            return null;
        }
        if (parser == null) {
            InitialContext ic = new InitialContext();
            parser = ic.getNameParser("");
        }
        Name name = parser.parse("");
        name.add("__");
        name.addAll(parser.parse(jndiName));
        return name;
    }

    public static Name getNameForScope(Object scope) {
        try {
            InitialContext ic = new InitialContext();
            NameParser parser = ic.getNameParser("");
            Name name = parser.parse("");
            if (scope != null) {
                name.add(NamingEntryUtil.canonicalizeScope(scope));
            }
            return name;
        }
        catch (NamingException e) {
            __log.warn((Throwable)e);
            return null;
        }
    }

    public static Context getContextForScope(Object scope) throws NamingException {
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        Name name = parser.parse("");
        if (scope != null) {
            name.add(NamingEntryUtil.canonicalizeScope(scope));
        }
        return (Context)ic.lookup(name);
    }

    public static Context getContextForNamingEntries(Object scope) throws NamingException {
        Context scopeContext = NamingEntryUtil.getContextForScope(scope);
        return (Context)scopeContext.lookup("__");
    }

    private static List<Object> lookupNamingEntries(List<Object> list, Context context, Class<?> clazz) throws NamingException {
        try {
            NamingEnumeration<Binding> nenum = context.listBindings("");
            while (nenum.hasMoreElements()) {
                Binding binding = nenum.next();
                if (binding.getObject() instanceof Context) {
                    NamingEntryUtil.lookupNamingEntries(list, (Context)binding.getObject(), clazz);
                    continue;
                }
                if (!clazz.isInstance(binding.getObject())) continue;
                list.add(binding.getObject());
            }
        }
        catch (NameNotFoundException e) {
            __log.debug("No entries of type " + clazz.getName() + " in context=" + context, new Object[0]);
        }
        return list;
    }

    private static String canonicalizeScope(Object scope) {
        if (scope == null) {
            return "";
        }
        String str = scope.getClass().getName() + "@" + Long.toHexString(scope.hashCode());
        str = str.replace('/', '_').replace(' ', '_');
        return str;
    }
}

