/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.net.URLConnection;
import org.apache.logging.log4j.core.impl.CoreProperties;
import org.apache.logging.log4j.core.util.BasicAuthorizationProvider;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;

@FunctionalInterface
public interface AuthorizationProvider {
    public void addAuthorization(URLConnection var1);

    public static AuthorizationProvider getAuthorizationProvider(CoreProperties.AuthenticationProperties props) {
        if (props.provider() != null) {
            try {
                return (AuthorizationProvider)LoaderUtil.newInstanceOf(props.provider());
            }
            catch (LinkageError | ReflectiveOperationException e) {
                StatusLogger.getLogger().warn("Unable to create {}, using default", (Object)props.provider().getName(), (Object)e);
            }
        }
        return new BasicAuthorizationProvider(props.basic());
    }
}

