/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.List;
import java.util.Map;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.client.DropBoxClient;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.FoursquareClient;
import org.pac4j.oauth.client.GenericOAuth20Client;
import org.pac4j.oauth.client.GitHubClient;
import org.pac4j.oauth.client.Google2Client;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oauth.client.WindowsLiveClient;
import org.pac4j.oauth.client.YahooClient;

public class OAuthBuilder
extends AbstractBuilder {
    public OAuthBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreateLinkedInClient(List<Client> clients) {
        String id = this.getProperty("linkedin.id");
        String secret = this.getProperty("linkedin.secret");
        String scope = this.getProperty("linkedin.scope");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            LinkedIn2Client linkedInClient = new LinkedIn2Client(id, secret);
            if (CommonHelper.isNotBlank((String)scope)) {
                linkedInClient.setScope(scope);
            }
            clients.add((Client)linkedInClient);
        }
    }

    public void tryCreateFacebookClient(List<Client> clients) {
        String id = this.getProperty("facebook.id");
        String secret = this.getProperty("facebook.secret");
        String scope = this.getProperty("facebook.scope");
        String fields = this.getProperty("facebook.fields");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            FacebookClient facebookClient = new FacebookClient(id, secret);
            if (CommonHelper.isNotBlank((String)scope)) {
                facebookClient.setScope(scope);
            }
            if (CommonHelper.isNotBlank((String)fields)) {
                facebookClient.setFields(fields);
            }
            clients.add((Client)facebookClient);
        }
    }

    public void tryCreateWindowsLiveClient(List<Client> clients) {
        String id = this.getProperty("windowslive.id");
        String secret = this.getProperty("windowslive.secret");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            WindowsLiveClient client = new WindowsLiveClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateFoursquareClient(List<Client> clients) {
        String id = this.getProperty("foursquare.id");
        String secret = this.getProperty("foursquare.secret");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            FoursquareClient client = new FoursquareClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateGoogleClient(List<Client> clients) {
        String id = this.getProperty("google.id");
        String secret = this.getProperty("google.secret");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            Google2Client client = new Google2Client(id, secret);
            String scope = this.getProperty("google.scope");
            if (CommonHelper.isNotBlank((String)scope)) {
                client.setScope(Google2Client.Google2Scope.valueOf((String)scope.toUpperCase()));
            }
            clients.add((Client)client);
        }
    }

    public void tryCreateYahooClient(List<Client> clients) {
        String id = this.getProperty("yahoo.id");
        String secret = this.getProperty("yahoo.secret");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            YahooClient client = new YahooClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateDropboxClient(List<Client> clients) {
        String id = this.getProperty("dropbox.id");
        String secret = this.getProperty("dropbox.secret");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            DropBoxClient client = new DropBoxClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateGithubClient(List<Client> clients) {
        String id = this.getProperty("github.id");
        String secret = this.getProperty("github.secret");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            GitHubClient client = new GitHubClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateTwitterClient(List<Client> clients) {
        String id = this.getProperty("twitter.id");
        String secret = this.getProperty("twitter.secret");
        if (CommonHelper.isNotBlank((String)id) && CommonHelper.isNotBlank((String)secret)) {
            TwitterClient twitterClient = new TwitterClient(id, secret);
            clients.add((Client)twitterClient);
        }
    }

    public void tryCreateGenericOAuth2Clients(List<Client> clients) {
        for (int i = 0; i <= 10; ++i) {
            String id = this.getProperty("oauth2.id", i);
            String secret = this.getProperty("oauth2.secret", i);
            if (!CommonHelper.isNotBlank((String)id) || !CommonHelper.isNotBlank((String)secret)) continue;
            GenericOAuth20Client client = new GenericOAuth20Client();
            client.setName(this.concat(client.getName(), i));
            client.setKey(id);
            client.setSecret(secret);
            client.setAuthUrl(this.getProperty("oauth2.authUrl", i));
            client.setTokenUrl(this.getProperty("oauth2.tokenUrl", i));
            client.setProfileUrl(this.getProperty("oauth2.profileUrl", i));
            client.setProfileNodePath(this.getProperty("oauth2.profilePath", i));
            client.setProfileId(this.getProperty("oauth2.profileId", i));
            client.setScope(this.getProperty("oauth2.scope", i));
            if (this.containsProperty("oauth2.withState", i)) {
                client.setWithState(this.getPropertyAsBoolean("oauth2.withState", i));
            }
            if (this.containsProperty("oauth2.clientAuthenticationMethod", i)) {
                client.setClientAuthenticationMethod(this.getProperty("oauth2.clientAuthenticationMethod", i));
            }
            clients.add((Client)client);
        }
    }
}

