/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.token.JWTokenAuthority;
import org.apache.knox.gateway.services.security.token.TokenServiceException;
import org.apache.knox.gateway.services.security.token.TokenStateService;
import org.apache.knox.gateway.services.security.token.TokenUtils;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.util.Tokens;

public class AccessTokenFederationFilter
implements Filter {
    private static JWTMessages log = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    private static final String BEARER = "Bearer ";
    private JWTokenAuthority authority;
    private TokenStateService tokenStateService;

    public void init(FilterConfig filterConfig) throws ServletException {
        GatewayServices services = (GatewayServices)filterConfig.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        this.authority = (JWTokenAuthority)services.getService(ServiceType.TOKEN_SERVICE);
        if (TokenUtils.isServerManagedTokenStateEnabled((FilterConfig)filterConfig)) {
            this.tokenStateService = (TokenStateService)services.getService(ServiceType.TOKEN_STATE_SERVICE);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block13: {
            String header = ((HttpServletRequest)request).getHeader("Authorization");
            if (header != null && header.startsWith(BEARER)) {
                JWTToken token;
                String wireToken = header.substring(BEARER.length());
                try {
                    token = JWTToken.parseToken((String)wireToken);
                }
                catch (ParseException e) {
                    throw new ServletException("ParseException encountered while processing the JWT token: ", (Throwable)e);
                }
                boolean verified = false;
                try {
                    verified = this.authority.verifyToken((JWT)token);
                }
                catch (TokenServiceException e) {
                    log.unableToVerifyToken((Exception)((Object)e));
                }
                String tokenId = TokenUtils.getTokenId((JWT)token);
                String displayableTokenId = Tokens.getTokenIDDisplayText((String)tokenId);
                String displayableToken = Tokens.getTokenDisplayText((String)token.toString());
                if (verified) {
                    try {
                        if (!this.isExpired(token)) {
                            if (((HttpServletRequest)request).getRequestURL().indexOf(token.getAudience().toLowerCase(Locale.ROOT)) != -1) {
                                Subject subject = this.createSubjectFromToken(token);
                                this.continueWithEstablishedSecurityContext(subject, (HttpServletRequest)request, (HttpServletResponse)response, chain);
                            } else {
                                log.failedToValidateAudience(displayableToken, displayableTokenId);
                                this.sendUnauthorized(response);
                            }
                            break block13;
                        }
                        log.tokenHasExpired(displayableToken, displayableTokenId);
                        this.sendUnauthorized(response);
                    }
                    catch (UnknownTokenException e) {
                        log.unableToVerifyExpiration((Exception)((Object)e));
                        this.sendUnauthorized(response);
                    }
                } else {
                    log.failedToVerifyTokenSignature(displayableToken, displayableTokenId);
                    this.sendUnauthorized(response);
                }
            } else {
                log.missingBearerToken();
                this.sendUnauthorized(response);
            }
        }
    }

    private boolean isExpired(JWTToken token) throws UnknownTokenException {
        return this.tokenStateService != null ? this.tokenStateService.isExpired(token) : Long.parseLong(token.getExpires()) <= System.currentTimeMillis();
    }

    private void sendUnauthorized(ServletResponse response) throws IOException {
        ((HttpServletResponse)response).sendError(401);
    }

    private void continueWithEstablishedSecurityContext(Subject subject, final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    private Subject createSubjectFromToken(JWTToken token) {
        String principal = token.getPrincipal();
        Set<PrimaryPrincipal> principals = Collections.singleton(new PrimaryPrincipal(principal));
        return new Subject(true, principals, Collections.emptySet(), Collections.emptySet());
    }
}

