/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Request object containing information needed for querying timeseries data.  Available since API v11.")
public class ApiTimeSeriesRequest {
    @SerializedName(value="query")
    private String query = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="contentType")
    private String contentType = null;
    @SerializedName(value="desiredRollup")
    private String desiredRollup = null;
    @SerializedName(value="mustUseDesiredRollup")
    private Boolean mustUseDesiredRollup = null;

    public ApiTimeSeriesRequest query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(value="tsquery to run against the CM time-series data store. Please see the <a href=\"https://docs.cloudera.com/r/cm_tsquery\"> tsquery language documentation</a>.<p/>")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ApiTimeSeriesRequest from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(value="Start of the period to query in ISO 8601 format (defaults to 5 minutes before the end of the period).")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ApiTimeSeriesRequest to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(value="End of the period to query in ISO 8601 format (defaults to current time).")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public ApiTimeSeriesRequest contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(value="contentType to return the response in. The content types \"application/json\" and \"text/csv\" are supported. This defaults to \"application/json\". If \"text/csv\" is specified then we return one row per time series data point, and we don't return any of the metadata.")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ApiTimeSeriesRequest desiredRollup(String desiredRollup) {
        this.desiredRollup = desiredRollup;
        return this;
    }

    @ApiModelProperty(value="Aggregate rollup level desired for the response data. Valid values are RAW, TEN_MINUTELY, HOURLY, SIX_HOURLY, DAILY, and WEEKLY. Note that if the mustUseDesiredRollup parameter is not set, then the monitoring server can decide to return a different rollup level.")
    public String getDesiredRollup() {
        return this.desiredRollup;
    }

    public void setDesiredRollup(String desiredRollup) {
        this.desiredRollup = desiredRollup;
    }

    public ApiTimeSeriesRequest mustUseDesiredRollup(Boolean mustUseDesiredRollup) {
        this.mustUseDesiredRollup = mustUseDesiredRollup;
        return this;
    }

    @ApiModelProperty(value="If set to true, then the tsquery will return data with the desired aggregate rollup level.")
    public Boolean getMustUseDesiredRollup() {
        return this.mustUseDesiredRollup;
    }

    public void setMustUseDesiredRollup(Boolean mustUseDesiredRollup) {
        this.mustUseDesiredRollup = mustUseDesiredRollup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiTimeSeriesRequest apiTimeSeriesRequest = (ApiTimeSeriesRequest)o;
        return Objects.equals(this.query, apiTimeSeriesRequest.query) && Objects.equals(this.from, apiTimeSeriesRequest.from) && Objects.equals(this.to, apiTimeSeriesRequest.to) && Objects.equals(this.contentType, apiTimeSeriesRequest.contentType) && Objects.equals(this.desiredRollup, apiTimeSeriesRequest.desiredRollup) && Objects.equals(this.mustUseDesiredRollup, apiTimeSeriesRequest.mustUseDesiredRollup);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.from, this.to, this.contentType, this.desiredRollup, this.mustUseDesiredRollup);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiTimeSeriesRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    desiredRollup: ").append(this.toIndentedString(this.desiredRollup)).append("\n");
        sb.append("    mustUseDesiredRollup: ").append(this.toIndentedString(this.mustUseDesiredRollup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

