/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiCommandList;
import com.cloudera.api.swagger.model.ApiHBaseReplicationInfo;
import com.cloudera.api.swagger.model.ApiHdfsReplicationResult;
import com.cloudera.api.swagger.model.ApiHiveOnTezReplicationResult;
import com.cloudera.api.swagger.model.ApiHiveReplicationResult;
import com.cloudera.api.swagger.model.ApiHostRef;
import com.cloudera.api.swagger.model.ApiOzoneReplicationResult;
import com.cloudera.api.swagger.model.ApiRoleRef;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Information about a replication command. <p/> This object holds all the information a regular ApiCommand object provides, and adds specific information about the results of a replication command. <p/> Depending on the type of the service where the replication was run, a different result property will be populated.")
public class ApiReplicationCommand {
    @SerializedName(value="id")
    private BigDecimal id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="success")
    private Boolean success = null;
    @SerializedName(value="resultMessage")
    private String resultMessage = null;
    @SerializedName(value="resultDataUrl")
    private String resultDataUrl = null;
    @SerializedName(value="clusterRef")
    private ApiClusterRef clusterRef = null;
    @SerializedName(value="serviceRef")
    private ApiServiceRef serviceRef = null;
    @SerializedName(value="roleRef")
    private ApiRoleRef roleRef = null;
    @SerializedName(value="hostRef")
    private ApiHostRef hostRef = null;
    @SerializedName(value="parent")
    private ApiCommand parent = null;
    @SerializedName(value="children")
    private ApiCommandList children = null;
    @SerializedName(value="canRetry")
    private Boolean canRetry = null;
    @SerializedName(value="hdfsResult")
    private ApiHdfsReplicationResult hdfsResult = null;
    @SerializedName(value="ozoneResult")
    private ApiOzoneReplicationResult ozoneResult = null;
    @SerializedName(value="hiveResult")
    private ApiHiveReplicationResult hiveResult = null;
    @SerializedName(value="hiveOnTezResult")
    private ApiHiveOnTezReplicationResult hiveOnTezResult = null;
    @SerializedName(value="hbaseInfo")
    private ApiHBaseReplicationInfo hbaseInfo = null;

    public ApiReplicationCommand id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The command ID.")
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public ApiReplicationCommand name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The command name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiReplicationCommand startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start time.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiReplicationCommand endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time, if the command is finished.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiReplicationCommand active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Whether the command is currently active.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ApiReplicationCommand success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="If the command is finished, whether it was successful.")
    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public ApiReplicationCommand resultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
        return this;
    }

    @ApiModelProperty(value="If the command is finished, the result message.")
    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public ApiReplicationCommand resultDataUrl(String resultDataUrl) {
        this.resultDataUrl = resultDataUrl;
        return this;
    }

    @ApiModelProperty(value="URL to the command's downloadable result data, if any exists.")
    public String getResultDataUrl() {
        return this.resultDataUrl;
    }

    public void setResultDataUrl(String resultDataUrl) {
        this.resultDataUrl = resultDataUrl;
    }

    public ApiReplicationCommand clusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the cluster (for cluster commands only).")
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    public ApiReplicationCommand serviceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the service (for service commands only).")
    public ApiServiceRef getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
    }

    public ApiReplicationCommand roleRef(ApiRoleRef roleRef) {
        this.roleRef = roleRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the role (for role commands only).")
    public ApiRoleRef getRoleRef() {
        return this.roleRef;
    }

    public void setRoleRef(ApiRoleRef roleRef) {
        this.roleRef = roleRef;
    }

    public ApiReplicationCommand hostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the host (for host commands only).")
    public ApiHostRef getHostRef() {
        return this.hostRef;
    }

    public void setHostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
    }

    public ApiReplicationCommand parent(ApiCommand parent) {
        this.parent = parent;
        return this;
    }

    @ApiModelProperty(value="Reference to the parent command, if any.")
    public ApiCommand getParent() {
        return this.parent;
    }

    public void setParent(ApiCommand parent) {
        this.parent = parent;
    }

    public ApiReplicationCommand children(ApiCommandList children) {
        this.children = children;
        return this;
    }

    @ApiModelProperty(value="List of child commands. Only available in the full view. <p> The list contains only the summary view of the children.")
    public ApiCommandList getChildren() {
        return this.children;
    }

    public void setChildren(ApiCommandList children) {
        this.children = children;
    }

    public ApiReplicationCommand canRetry(Boolean canRetry) {
        this.canRetry = canRetry;
        return this;
    }

    @ApiModelProperty(value="If the command can be retried. Available since V11")
    public Boolean getCanRetry() {
        return this.canRetry;
    }

    public void setCanRetry(Boolean canRetry) {
        this.canRetry = canRetry;
    }

    public ApiReplicationCommand hdfsResult(ApiHdfsReplicationResult hdfsResult) {
        this.hdfsResult = hdfsResult;
        return this;
    }

    @ApiModelProperty(value="Results for replication commands on HDFS services.")
    public ApiHdfsReplicationResult getHdfsResult() {
        return this.hdfsResult;
    }

    public void setHdfsResult(ApiHdfsReplicationResult hdfsResult) {
        this.hdfsResult = hdfsResult;
    }

    public ApiReplicationCommand ozoneResult(ApiOzoneReplicationResult ozoneResult) {
        this.ozoneResult = ozoneResult;
        return this;
    }

    @ApiModelProperty(value="Results for replication commands on OZONE services.")
    public ApiOzoneReplicationResult getOzoneResult() {
        return this.ozoneResult;
    }

    public void setOzoneResult(ApiOzoneReplicationResult ozoneResult) {
        this.ozoneResult = ozoneResult;
    }

    public ApiReplicationCommand hiveResult(ApiHiveReplicationResult hiveResult) {
        this.hiveResult = hiveResult;
        return this;
    }

    @ApiModelProperty(value="Results for replication commands on Hive services.")
    public ApiHiveReplicationResult getHiveResult() {
        return this.hiveResult;
    }

    public void setHiveResult(ApiHiveReplicationResult hiveResult) {
        this.hiveResult = hiveResult;
    }

    public ApiReplicationCommand hiveOnTezResult(ApiHiveOnTezReplicationResult hiveOnTezResult) {
        this.hiveOnTezResult = hiveOnTezResult;
        return this;
    }

    @ApiModelProperty(value="Results for replication commands on HiveOnTez services.")
    public ApiHiveOnTezReplicationResult getHiveOnTezResult() {
        return this.hiveOnTezResult;
    }

    public void setHiveOnTezResult(ApiHiveOnTezReplicationResult hiveOnTezResult) {
        this.hiveOnTezResult = hiveOnTezResult;
    }

    public ApiReplicationCommand hbaseInfo(ApiHBaseReplicationInfo hbaseInfo) {
        this.hbaseInfo = hbaseInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ApiHBaseReplicationInfo getHbaseInfo() {
        return this.hbaseInfo;
    }

    public void setHbaseInfo(ApiHBaseReplicationInfo hbaseInfo) {
        this.hbaseInfo = hbaseInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiReplicationCommand apiReplicationCommand = (ApiReplicationCommand)o;
        return Objects.equals(this.id, apiReplicationCommand.id) && Objects.equals(this.name, apiReplicationCommand.name) && Objects.equals(this.startTime, apiReplicationCommand.startTime) && Objects.equals(this.endTime, apiReplicationCommand.endTime) && Objects.equals(this.active, apiReplicationCommand.active) && Objects.equals(this.success, apiReplicationCommand.success) && Objects.equals(this.resultMessage, apiReplicationCommand.resultMessage) && Objects.equals(this.resultDataUrl, apiReplicationCommand.resultDataUrl) && Objects.equals(this.clusterRef, apiReplicationCommand.clusterRef) && Objects.equals(this.serviceRef, apiReplicationCommand.serviceRef) && Objects.equals(this.roleRef, apiReplicationCommand.roleRef) && Objects.equals(this.hostRef, apiReplicationCommand.hostRef) && Objects.equals(this.parent, apiReplicationCommand.parent) && Objects.equals(this.children, apiReplicationCommand.children) && Objects.equals(this.canRetry, apiReplicationCommand.canRetry) && Objects.equals(this.hdfsResult, apiReplicationCommand.hdfsResult) && Objects.equals(this.ozoneResult, apiReplicationCommand.ozoneResult) && Objects.equals(this.hiveResult, apiReplicationCommand.hiveResult) && Objects.equals(this.hiveOnTezResult, apiReplicationCommand.hiveOnTezResult) && Objects.equals(this.hbaseInfo, apiReplicationCommand.hbaseInfo);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.startTime, this.endTime, this.active, this.success, this.resultMessage, this.resultDataUrl, this.clusterRef, this.serviceRef, this.roleRef, this.hostRef, this.parent, this.children, this.canRetry, this.hdfsResult, this.ozoneResult, this.hiveResult, this.hiveOnTezResult, this.hbaseInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiReplicationCommand {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    resultMessage: ").append(this.toIndentedString(this.resultMessage)).append("\n");
        sb.append("    resultDataUrl: ").append(this.toIndentedString(this.resultDataUrl)).append("\n");
        sb.append("    clusterRef: ").append(this.toIndentedString(this.clusterRef)).append("\n");
        sb.append("    serviceRef: ").append(this.toIndentedString(this.serviceRef)).append("\n");
        sb.append("    roleRef: ").append(this.toIndentedString(this.roleRef)).append("\n");
        sb.append("    hostRef: ").append(this.toIndentedString(this.hostRef)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    canRetry: ").append(this.toIndentedString(this.canRetry)).append("\n");
        sb.append("    hdfsResult: ").append(this.toIndentedString(this.hdfsResult)).append("\n");
        sb.append("    ozoneResult: ").append(this.toIndentedString(this.ozoneResult)).append("\n");
        sb.append("    hiveResult: ").append(this.toIndentedString(this.hiveResult)).append("\n");
        sb.append("    hiveOnTezResult: ").append(this.toIndentedString(this.hiveOnTezResult)).append("\n");
        sb.append("    hbaseInfo: ").append(this.toIndentedString(this.hbaseInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

