/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.hadoop.xml;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.advanced.AdvancedServiceDiscoveryConfigChangeListener;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceMessages;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceParserResult;
import org.apache.knox.gateway.topology.simple.JSONProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;
import org.apache.knox.gateway.topology.simple.ProviderConfigurationParser;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorImpl;

public class HadoopXmlResourceParser
implements AdvancedServiceDiscoveryConfigChangeListener {
    private static final HadoopXmlResourceMessages log = (HadoopXmlResourceMessages)MessagesFactory.get(HadoopXmlResourceMessages.class);
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_PREFIX = "providerConfigs:";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_ROLE_PREFIX = "role=";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_NAME_PREFIX = "name=";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_ENABLED_PREFIX = "enabled=";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_PARAM_PREFIX = "param.";
    private static final String CONFIG_NAME_PROVIDER_CONFIGS_PARAM_REMOVE = "remove";
    private static final String CONFIG_NAME_DISCOVERY_TYPE = "discoveryType";
    private static final String CONFIG_NAME_DISCOVERY_ADDRESS = "discoveryAddress";
    private static final String CONFIG_NAME_DISCOVERY_USER = "discoveryUser";
    private static final String CONFIG_NAME_DISCOVERY_PASSWORD_ALIAS = "discoveryPasswordAlias";
    private static final String CONFIG_NAME_DISCOVERY_CLUSTER = "cluster";
    private static final String CONFIG_NAME_PROVIDER_CONFIG_REFERENCE = "providerConfigRef";
    private static final String CONFIG_NAME_APPLICATION_PREFIX = "app";
    private static final String CONFIG_NAME_SERVICE_URL = "url";
    private static final String CONFIG_NAME_SERVICE_VERSION = "version";
    private final Map<String, AdvancedServiceDiscoveryConfig> advancedServiceDiscoveryConfigMap = new ConcurrentHashMap<String, AdvancedServiceDiscoveryConfig>();
    private final String sharedProvidersDir;

    public HadoopXmlResourceParser(GatewayConfig gatewayConfig) {
        this.sharedProvidersDir = gatewayConfig.getGatewayProvidersConfigDir();
    }

    public HadoopXmlResourceParserResult parse(String path) {
        return this.parse(path, null);
    }

    public HadoopXmlResourceParserResult parse(String path, String topologyName) {
        try {
            log.parseHadoopXmlResource(path, topologyName == null ? "all topologies" : topologyName);
            Configuration xmlConfiguration = new Configuration(false);
            xmlConfiguration.addResource(Paths.get(path, new String[0]).toUri().toURL());
            xmlConfiguration.reloadConfiguration();
            HadoopXmlResourceParserResult parserResult = this.parseXmlConfig(xmlConfiguration, topologyName);
            this.logParserResult(path, parserResult);
            return parserResult;
        }
        catch (Exception e) {
            log.failedToParseXmlConfiguration(path, e.getMessage(), e);
            return new HadoopXmlResourceParserResult();
        }
    }

    private void logParserResult(String path, HadoopXmlResourceParserResult parserResult) {
        if (!parserResult.getDescriptors().isEmpty()) {
            log.foundKnoxDescriptors(String.join((CharSequence)", ", parserResult.getDescriptors().stream().map(descriptor -> descriptor.getName()).collect(Collectors.toSet())), path);
        }
        if (!parserResult.getProviders().isEmpty()) {
            log.foundKnoxProviderConfigurations(String.join((CharSequence)", ", parserResult.getProviders().keySet().stream().collect(Collectors.toSet())), path);
        }
    }

    private HadoopXmlResourceParserResult parseXmlConfig(Configuration xmlConfiguration, String topologyName) {
        LinkedHashMap<String, ProviderConfiguration> providers = new LinkedHashMap<String, ProviderConfiguration>();
        LinkedHashSet<SimpleDescriptor> descriptors = new LinkedHashSet<SimpleDescriptor>();
        xmlConfiguration.forEach(xmlDescriptor -> {
            SimpleDescriptor descriptor;
            String xmlConfigurationKey = (String)xmlDescriptor.getKey();
            if (xmlConfigurationKey.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_PREFIX)) {
                String[] providerConfigurations = xmlConfigurationKey.replace(CONFIG_NAME_PROVIDER_CONFIGS_PREFIX, "").split(",");
                Arrays.asList(providerConfigurations).stream().map(providerConfigurationName -> providerConfigurationName.trim()).forEach(providerConfigurationName -> {
                    File providerConfigFile = this.resolveProviderConfiguration((String)providerConfigurationName);
                    try {
                        ProviderConfiguration providerConfiguration = this.getProviderConfiguration(providers, providerConfigFile, (String)providerConfigurationName);
                        providerConfiguration.setReadOnly(true);
                        providerConfiguration.saveOrUpdateProviders(this.parseProviderConfigurations((String)xmlDescriptor.getValue(), providerConfiguration));
                        providers.put((String)providerConfigurationName, providerConfiguration);
                    }
                    catch (Exception e) {
                        log.failedToParseProviderConfiguration((String)providerConfigurationName, e.getMessage(), e);
                    }
                });
            } else if ((topologyName == null || xmlConfigurationKey.equals(topologyName)) && (descriptor = this.parseXmlDescriptor(xmlConfigurationKey, (String)xmlDescriptor.getValue())) != null) {
                descriptors.add(descriptor);
            }
        });
        return new HadoopXmlResourceParserResult(providers, descriptors);
    }

    private ProviderConfiguration getProviderConfiguration(Map<String, ProviderConfiguration> providers, File providerConfigFile, String providerConfigName) throws Exception {
        if (providers.containsKey(providerConfigName)) {
            return providers.get(providerConfigName);
        }
        return providerConfigFile == null ? new JSONProviderConfiguration() : ProviderConfigurationParser.parse((File)providerConfigFile);
    }

    private File resolveProviderConfiguration(String providerConfigurationName) {
        for (String supportedExtension : ProviderConfigurationParser.SUPPORTED_EXTENSIONS) {
            File providerConfigFile = new File(this.sharedProvidersDir, providerConfigurationName + "." + supportedExtension);
            if (!providerConfigFile.exists()) continue;
            return providerConfigFile;
        }
        return null;
    }

    private Set<ProviderConfiguration.Provider> parseProviderConfigurations(String xmlValue, ProviderConfiguration providerConfiguration) {
        LinkedHashSet<ProviderConfiguration.Provider> providers = new LinkedHashSet<ProviderConfiguration.Provider>();
        List<String> configurationPairs = Arrays.asList(xmlValue.split("#"));
        Set roles = configurationPairs.stream().filter(configurationPair -> configurationPair.trim().startsWith(CONFIG_NAME_PROVIDER_CONFIGS_ROLE_PREFIX)).map(configurationPair -> configurationPair.replace(CONFIG_NAME_PROVIDER_CONFIGS_ROLE_PREFIX, "").trim()).collect(Collectors.toSet());
        for (String role : roles) {
            providers.add(this.parseProvider(configurationPairs, role, providerConfiguration));
        }
        return providers;
    }

    private ProviderConfiguration.Provider parseProvider(List<String> configurationPairs, String role, ProviderConfiguration providerConfiguration) {
        JSONProviderConfiguration.JSONProvider provider = new JSONProviderConfiguration.JSONProvider();
        provider.setRole(role);
        this.getParamsForRole(role, providerConfiguration).forEach((key, value) -> provider.addParam(key, value));
        provider.setEnabled(true);
        Set roleConfigurations = configurationPairs.stream().filter(configurationPair -> configurationPair.trim().startsWith(role)).map(configurationPair -> configurationPair.replace(role + ".", "").trim()).collect(Collectors.toSet());
        for (String roleConfiguration : roleConfigurations) {
            if (roleConfiguration.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_PARAM_PREFIX)) {
                String[] paramKeyValue = roleConfiguration.replace(CONFIG_NAME_PROVIDER_CONFIGS_PARAM_PREFIX, "").split("=", 2);
                if (CONFIG_NAME_PROVIDER_CONFIGS_PARAM_REMOVE.equals(paramKeyValue[0])) {
                    provider.removeParam(paramKeyValue[1]);
                    continue;
                }
                provider.addParam(paramKeyValue[0], paramKeyValue[1]);
                continue;
            }
            if (roleConfiguration.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_NAME_PREFIX)) {
                provider.setName(roleConfiguration.replace(CONFIG_NAME_PROVIDER_CONFIGS_NAME_PREFIX, ""));
                continue;
            }
            if (!roleConfiguration.startsWith(CONFIG_NAME_PROVIDER_CONFIGS_ENABLED_PREFIX)) continue;
            provider.setEnabled(Boolean.valueOf(roleConfiguration.replace(CONFIG_NAME_PROVIDER_CONFIGS_ENABLED_PREFIX, "")).booleanValue());
        }
        return provider;
    }

    private Map<String, String> getParamsForRole(String role, ProviderConfiguration providerConfiguration) {
        Optional<ProviderConfiguration.Provider> provider = providerConfiguration.getProviders().stream().filter(p -> p.getRole().equals(role)).findFirst();
        return provider.isPresent() ? provider.get().getParams() : new TreeMap();
    }

    private SimpleDescriptor parseXmlDescriptor(String name, String xmlValue) {
        try {
            String[] configurationPairs;
            SimpleDescriptorImpl descriptor = new SimpleDescriptorImpl();
            descriptor.setReadOnly(true);
            descriptor.setName(name);
            block18: for (String configurationPair : configurationPairs = xmlValue.split("#")) {
                String parameterName;
                String[] parameterPairParts = configurationPair.trim().split("=", 2);
                switch (parameterName = parameterPairParts[0].trim()) {
                    case "discoveryType": {
                        descriptor.setDiscoveryType(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "discoveryAddress": {
                        descriptor.setDiscoveryAddress(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "discoveryUser": {
                        descriptor.setDiscoveryUser(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "discoveryPasswordAlias": {
                        descriptor.setDiscoveryPasswordAlias(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "cluster": {
                        descriptor.setCluster(parameterPairParts[1].trim());
                        continue block18;
                    }
                    case "providerConfigRef": {
                        descriptor.setProviderConfig(parameterPairParts[1].trim());
                        continue block18;
                    }
                    default: {
                        if (parameterName.startsWith(CONFIG_NAME_APPLICATION_PREFIX)) {
                            this.parseApplication(descriptor, configurationPair.trim());
                            continue block18;
                        }
                        this.parseService(descriptor, configurationPair.trim());
                    }
                }
            }
            AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig = this.advancedServiceDiscoveryConfigMap.get(name);
            if (advancedServiceDiscoveryConfig != null) {
                this.setDiscoveryDetails(descriptor, advancedServiceDiscoveryConfig);
                this.addEnabledServices(descriptor, advancedServiceDiscoveryConfig);
            }
            return descriptor;
        }
        catch (Exception e) {
            log.failedToParseDescriptor(name, e.getMessage(), e);
            return null;
        }
    }

    private void setDiscoveryDetails(SimpleDescriptorImpl descriptor, AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig) {
        if (StringUtils.isBlank((CharSequence)descriptor.getDiscoveryAddress())) {
            descriptor.setDiscoveryAddress(advancedServiceDiscoveryConfig.getDiscoveryAddress());
        }
        if (StringUtils.isBlank((CharSequence)descriptor.getCluster())) {
            descriptor.setCluster(advancedServiceDiscoveryConfig.getDiscoveryCluster());
        }
        if (StringUtils.isBlank((CharSequence)descriptor.getDiscoveryType())) {
            descriptor.setDiscoveryType("ClouderaManager");
        }
    }

    private void addEnabledServices(SimpleDescriptorImpl descriptor, AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig) {
        advancedServiceDiscoveryConfig.getEnabledServiceNames().forEach(enabledServiceName -> {
            if (descriptor.getService(enabledServiceName) == null) {
                SimpleDescriptorImpl.ServiceImpl service = new SimpleDescriptorImpl.ServiceImpl();
                service.setName(enabledServiceName);
                descriptor.addService((SimpleDescriptor.Service)service);
            }
        });
    }

    private void parseApplication(SimpleDescriptorImpl descriptor, String configurationPair) {
        String[] applicationParts = configurationPair.split(":");
        String applicationName = applicationParts[1].trim();
        SimpleDescriptorImpl.ApplicationImpl application = (SimpleDescriptorImpl.ApplicationImpl)descriptor.getApplication(applicationName);
        if (application == null) {
            application = new SimpleDescriptorImpl.ApplicationImpl();
            descriptor.addApplication((SimpleDescriptor.Application)application);
            application.setName(applicationParts[1]);
        }
        if (applicationParts.length > 2) {
            String applicationParameters = configurationPair.substring(applicationName.length() + 5);
            String[] applicationParameterParts = applicationParameters.split("=", 2);
            application.addParam(applicationParameterParts[0], applicationParameterParts[1]);
        }
    }

    private void parseService(SimpleDescriptorImpl descriptor, String configurationPair) {
        String[] serviceParts = configurationPair.split(":");
        String serviceName = serviceParts[0].trim();
        if (this.isServiceEnabled(descriptor.getName(), serviceName)) {
            SimpleDescriptorImpl.ServiceImpl service = (SimpleDescriptorImpl.ServiceImpl)descriptor.getService(serviceName);
            if (service == null) {
                service = new SimpleDescriptorImpl.ServiceImpl();
                service.setName(serviceName);
                descriptor.addService((SimpleDescriptor.Service)service);
            }
            if (serviceParts.length > 1) {
                String serviceConfiguration = configurationPair.substring(serviceName.length() + 1).trim();
                String[] serviceConfigurationParts = serviceConfiguration.split("=", 2);
                String serviceConfigurationName = serviceConfigurationParts[0].trim();
                String serviceConfigurationValue = serviceConfigurationParts[1].trim();
                switch (serviceConfigurationName) {
                    case "url": {
                        service.addUrl(serviceConfigurationValue);
                        break;
                    }
                    case "version": {
                        service.setVersion(serviceConfigurationValue);
                        break;
                    }
                    default: {
                        service.addParam(serviceConfigurationName, serviceConfigurationValue);
                    }
                }
            }
        } else {
            log.serviceDisabled(serviceName, descriptor.getName());
        }
    }

    private boolean isServiceEnabled(String descriptorName, String serviceName) {
        return this.advancedServiceDiscoveryConfigMap.containsKey(descriptorName) ? this.advancedServiceDiscoveryConfigMap.get(descriptorName).isServiceEnabled(serviceName) : true;
    }

    @Override
    public void onAdvancedServiceDiscoveryConfigurationChange(Properties newConfiguration) {
        AdvancedServiceDiscoveryConfig advancedServiceDiscoveryConfig = new AdvancedServiceDiscoveryConfig(newConfiguration);
        String topologyName = advancedServiceDiscoveryConfig.getTopologyName();
        if (StringUtils.isBlank((CharSequence)topologyName)) {
            throw new IllegalArgumentException("Invalid advanced service discovery configuration: topology name is missing!");
        }
        this.advancedServiceDiscoveryConfigMap.put(topologyName, advancedServiceDiscoveryConfig);
        log.updatedAdvanceServiceDiscoverytConfiguration(topologyName);
    }
}

