/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.istack.logging.Logger;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.modeler.ModelerException;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceWrapperGenerator;
import com.sun.tools.ws.resources.WebserviceapMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.WsgenOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.jws.WebService;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceProvider;

@SupportedAnnotationTypes(value={"javax.jws.HandlerChain", "javax.jws.Oneway", "javax.jws.WebMethod", "javax.jws.WebParam", "javax.jws.WebResult", "javax.jws.WebService", "javax.jws.soap.InitParam", "javax.jws.soap.SOAPBinding", "javax.jws.soap.SOAPMessageHandler", "javax.jws.soap.SOAPMessageHandlers", "javax.xml.ws.BindingType", "javax.xml.ws.RequestWrapper", "javax.xml.ws.ResponseWrapper", "javax.xml.ws.ServiceMode", "javax.xml.ws.WebEndpoint", "javax.xml.ws.WebFault", "javax.xml.ws.WebServiceClient", "javax.xml.ws.WebServiceProvider", "javax.xml.ws.WebServiceRef"})
@SupportedOptions(value={"doNotOverWrite", "ignoreNoWebServiceFoundWarning", "verbose"})
public class WebServiceAp
extends AbstractProcessor
implements ModelBuilder {
    private static final Logger LOGGER = Logger.getLogger(WebServiceAp.class);
    public static final String DO_NOT_OVERWRITE = "doNotOverWrite";
    public static final String IGNORE_NO_WEB_SERVICE_FOUND_WARNING = "ignoreNoWebServiceFoundWarning";
    public static final String VERBOSE = "verbose";
    private WsgenOptions options;
    protected AnnotationProcessorContext context;
    private File sourceDir;
    private boolean doNotOverWrite;
    private boolean ignoreNoWebServiceFoundWarning = false;
    private TypeMirror exceptionElement;
    private TypeMirror runtimeExceptionElement;
    private TypeElement defHolderElement;
    private boolean isCommandLineInvocation;
    private PrintStream out;
    private Collection<TypeElement> processedTypeElements = new HashSet<TypeElement>();

    public WebServiceAp() {
        this.context = new AnnotationProcessorContext();
    }

    public WebServiceAp(WsgenOptions options, PrintStream out) {
        this.options = options;
        this.sourceDir = options != null ? options.sourceDir : null;
        this.doNotOverWrite = options != null && options.doNotOverWrite;
        this.context = new AnnotationProcessorContext();
        this.out = out;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.exceptionElement = processingEnv.getElementUtils().getTypeElement(Exception.class.getName()).asType();
        this.runtimeExceptionElement = processingEnv.getElementUtils().getTypeElement(RuntimeException.class.getName()).asType();
        this.defHolderElement = processingEnv.getElementUtils().getTypeElement(Holder.class.getName());
        if (this.options == null) {
            this.options = new WsgenOptions();
            this.out = new PrintStream(new ByteArrayOutputStream());
            this.doNotOverWrite = this.getOption(DO_NOT_OVERWRITE);
            this.ignoreNoWebServiceFoundWarning = this.getOption(IGNORE_NO_WEB_SERVICE_FOUND_WARNING);
            this.options.verbose = this.getOption(VERBOSE);
            this.isCommandLineInvocation = true;
        }
        this.options.filer = processingEnv.getFiler();
    }

    private boolean getOption(String key) {
        String value = this.processingEnv.getOptions().get(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.context.getRound() != 1) {
            return true;
        }
        this.context.incrementRound();
        WebServiceWrapperGenerator webServiceVisitor = new WebServiceWrapperGenerator(this, this.context);
        boolean processedEndpoint = false;
        ArrayList<TypeElement> classes = new ArrayList<TypeElement>();
        this.filterClasses(classes, roundEnv.getRootElements());
        for (TypeElement element : classes) {
            WebServiceProvider webServiceProvider = element.getAnnotation(WebServiceProvider.class);
            WebService webService = element.getAnnotation(WebService.class);
            if (webServiceProvider != null) {
                if (webService != null) {
                    this.processError(WebserviceapMessages.WEBSERVICEAP_WEBSERVICE_AND_WEBSERVICEPROVIDER(element.getQualifiedName()));
                }
                processedEndpoint = true;
            }
            if (webService == null) continue;
            element.accept(webServiceVisitor, null);
            processedEndpoint = true;
        }
        if (!processedEndpoint) {
            if (this.isCommandLineInvocation) {
                if (!this.ignoreNoWebServiceFoundWarning) {
                    this.processWarning(WebserviceapMessages.WEBSERVICEAP_NO_WEBSERVICE_ENDPOINT_FOUND());
                }
            } else {
                this.processError(WebserviceapMessages.WEBSERVICEAP_NO_WEBSERVICE_ENDPOINT_FOUND());
            }
        }
        return true;
    }

    private void filterClasses(Collection<TypeElement> classes, Collection<? extends Element> elements) {
        for (Element element : elements) {
            if (!element.getKind().equals((Object)ElementKind.CLASS)) continue;
            classes.add((TypeElement)element);
            this.filterClasses(classes, ElementFilter.typesIn(element.getEnclosedElements()));
        }
    }

    @Override
    public void processWarning(String message) {
        if (this.isCommandLineInvocation) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
        } else {
            this.report(message);
        }
    }

    protected void report(String msg) {
        if (this.out == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "No output set for web service annotation processor reporting.");
            }
            return;
        }
        this.out.println(msg);
        this.out.flush();
    }

    @Override
    public void processError(String message) {
        if (this.isCommandLineInvocation) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
            throw new AbortException();
        }
        throw new ModelerException(message);
    }

    @Override
    public void processError(String message, Element element) {
        if (!this.isCommandLineInvocation) {
            throw new ModelerException(message);
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    @Override
    public boolean canOverWriteClass(String className) {
        return !this.doNotOverWrite || !GeneratorUtil.classExists(this.options, className);
    }

    @Override
    public File getSourceDir() {
        return this.sourceDir;
    }

    @Override
    public boolean isRemote(TypeElement typeElement) {
        return TypeModeler.isRemote(typeElement);
    }

    @Override
    public boolean isServiceException(TypeMirror typeMirror) {
        return this.processingEnv.getTypeUtils().isSubtype(typeMirror, this.exceptionElement) && !this.processingEnv.getTypeUtils().isSubtype(typeMirror, this.runtimeExceptionElement) && !TypeModeler.isRemoteException(this.processingEnv, typeMirror);
    }

    @Override
    public TypeMirror getHolderValueType(TypeMirror type) {
        return TypeModeler.getHolderValueType(type, this.defHolderElement, this.processingEnv);
    }

    @Override
    public boolean checkAndSetProcessed(TypeElement typeElement) {
        if (!this.processedTypeElements.contains(typeElement)) {
            this.processedTypeElements.add(typeElement);
            return false;
        }
        return true;
    }

    @Override
    public void log(String message) {
        if (this.options != null && this.options.verbose) {
            message = '[' + message + ']';
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
        }
    }

    @Override
    public WsgenOptions getOptions() {
        return this.options;
    }

    @Override
    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    @Override
    public String getOperationName(Name messageName) {
        return messageName != null ? messageName.toString() : null;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }
}

