/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.html;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StreamedSource;
import net.htmlparser.jericho.Tag;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterApplyDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterPathDescriptor;
import org.apache.knox.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterReader;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteUtil;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public abstract class HtmlFilterReaderBase
extends Reader
implements UrlRewriteFilterReader {
    private static final String SCRIPTTAG = "script";
    private static final UrlRewriteFilterPathDescriptor.Compiler<Pattern> REGEX_COMPILER = new UrlRewriteFilterReader.RegexCompiler();
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private Stack<Level> stack;
    private Reader reader;
    private StreamedSource parser;
    private Iterator<Segment> iterator;
    private int lastSegEnd;
    private int offset;
    private StringWriter writer;
    private StringBuffer buffer;
    private UrlRewriteFilterContentDescriptor config;

    protected HtmlFilterReaderBase(Reader reader) throws IOException, ParserConfigurationException {
        this.reader = reader;
        this.stack = new Stack();
        this.parser = new StreamedSource(reader);
        this.iterator = this.parser.iterator();
        this.writer = new StringWriter();
        this.buffer = this.writer.getBuffer();
        this.offset = 0;
    }

    protected HtmlFilterReaderBase(Reader reader, UrlRewriteFilterContentDescriptor config) throws IOException, ParserConfigurationException {
        this(reader);
        this.config = config;
    }

    protected abstract String filterAttribute(QName var1, QName var2, String var3, String var4);

    protected abstract String filterText(QName var1, String var2, String var3);

    @Override
    public int read(char[] destBuffer, int destOffset, int destCount) throws IOException {
        int count = 0;
        int available = this.buffer.length() - this.offset;
        if (available == 0) {
            if (this.iterator.hasNext()) {
                this.iterator.next();
                this.processCurrentSegment();
                available = this.buffer.length() - this.offset;
            } else {
                count = -1;
            }
        }
        if (available > 0) {
            count = Math.min(destCount, available);
            this.buffer.getChars(this.offset, this.offset + count, destBuffer, destOffset);
            this.offset += count;
            if (this.offset == this.buffer.length()) {
                this.offset = 0;
                this.buffer.setLength(0);
            }
        }
        return count;
    }

    private void processCurrentSegment() {
        Segment segment = this.parser.getCurrentSegment();
        if (segment.getEnd() <= this.lastSegEnd) {
            return;
        }
        this.lastSegEnd = segment.getEnd();
        if (segment instanceof Tag) {
            if (segment instanceof StartTag) {
                this.processStartTag((StartTag)segment);
            } else if (segment instanceof EndTag) {
                this.processEndTag((EndTag)segment);
            } else {
                this.writer.write(segment.toString());
            }
        } else {
            this.processText(segment);
        }
    }

    private void processEndTag(EndTag tag) {
        Level popped;
        while (!this.stack.isEmpty() && !(popped = this.stack.pop()).getTag().getName().equalsIgnoreCase(tag.getName())) {
        }
        this.writer.write(tag.toString());
    }

    private void processStartTag(StartTag tag) {
        if ("<".equals(tag.getTagType().getStartDelimiter())) {
            this.stack.push(new Level(tag));
            this.writer.write("<");
            this.writer.write(tag.getNameSegment().toString());
            Attributes attributes = tag.getAttributes();
            if (!attributes.isEmpty()) {
                for (Attribute attribute : attributes) {
                    this.processAttribute(attribute);
                }
            }
            if (tag.toString().trim().endsWith("/>") || tag.isEmptyElementTag()) {
                this.stack.pop();
                this.writer.write("/>");
            } else {
                this.writer.write(">");
            }
        } else {
            this.writer.write(tag.toString());
        }
    }

    private void processAttribute(Attribute attribute) {
        this.writer.write(" ");
        this.writer.write(attribute.getName());
        if (attribute.hasValue()) {
            String inputValue;
            String outputValue = inputValue = attribute.getValueSegment().toString();
            try {
                Level tag = this.stack.peek();
                String name = this.getRuleName(inputValue);
                outputValue = this.filterAttribute(tag.getQName(), tag.getQName(attribute.getName()), inputValue, name);
                if (outputValue == null) {
                    outputValue = inputValue;
                }
            }
            catch (Exception e) {
                LOG.failedToFilterAttribute(attribute.getName(), e);
            }
            this.writer.write("=");
            this.writer.write(attribute.getQuoteChar());
            this.writer.write(outputValue);
            this.writer.write(attribute.getQuoteChar());
        }
    }

    private String getRuleName(String inputValue) {
        if (this.config != null && !this.config.getSelectors().isEmpty()) {
            for (UrlRewriteFilterPathDescriptor selector : this.config.getSelectors()) {
                UrlRewriteFilterApplyDescriptor apply;
                Matcher matcher;
                if (!(selector instanceof UrlRewriteFilterApplyDescriptor) || !(matcher = (apply = (UrlRewriteFilterApplyDescriptor)selector).compiledPath(REGEX_COMPILER).matcher(inputValue)).matches()) continue;
                return apply.rule();
            }
        }
        return null;
    }

    private void processText(Segment segment) {
        String inputValue;
        String outputValue = inputValue = segment.toString();
        try {
            if (!this.stack.isEmpty()) {
                String tagName = this.stack.peek().getTag().getName();
                outputValue = SCRIPTTAG.equals(tagName) && this.config != null && !this.config.getSelectors().isEmpty() ? UrlRewriteUtil.filterJavaScript(inputValue, this.config, this, REGEX_COMPILER) : this.filterText(this.stack.peek().getQName(), inputValue, this.getRuleName(inputValue));
            }
            if (outputValue == null) {
                outputValue = inputValue;
            }
        }
        catch (Exception e) {
            LOG.failedToFilterValue(inputValue, null, e);
        }
        this.writer.write(outputValue);
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        this.reader.close();
        this.writer.close();
        this.stack.clear();
    }

    private static class Level {
        private StartTag tag;
        private QName name;
        private Map<String, String> namespaces;

        Level(StartTag tag) {
            this.tag = tag;
            this.name = null;
            this.namespaces = null;
        }

        private StartTag getTag() {
            return this.tag;
        }

        private QName getQName() {
            if (this.name == null) {
                this.name = this.getQName(this.tag.getName());
            }
            return this.name;
        }

        private String getNamespace(String prefix) {
            return this.getNamespaces().get(prefix);
        }

        private QName getQName(String name) {
            String local;
            String prefix;
            int colon;
            int n = colon = name == null ? -1 : name.indexOf(58);
            if (colon < 0) {
                prefix = "";
                local = name;
            } else {
                prefix = name.substring(0, colon);
                local = colon + 1 < name.length() ? name.substring(colon + 1) : "";
            }
            String namespace = this.getNamespace(prefix);
            return new QName(namespace, local, prefix);
        }

        private Map<String, String> getNamespaces() {
            if (this.namespaces == null) {
                this.namespaces = new HashMap<String, String>();
                this.parseNamespaces();
            }
            return this.namespaces;
        }

        private void parseNamespaces() {
            Attributes attributes = this.tag.getAttributes();
            if (attributes != null) {
                for (Attribute attribute : this.tag.getAttributes()) {
                    String name = attribute.getName();
                    if (!name.toLowerCase(Locale.ROOT).startsWith("xmlns")) continue;
                    int colon = name.indexOf(58, 5);
                    String prefix = colon <= 0 ? "" : name.substring(colon);
                    this.namespaces.put(prefix, attribute.getValue());
                }
            }
        }
    }
}

