/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIRequestDecorator;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIResponseContainer;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIResponseDecorator;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIRequest;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIRequestImpl;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponse;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponseImpl;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;

public class WhoAmIFactory
implements ExtendedOperationFactory {
    private LdapApiService codec;

    public WhoAmIFactory(LdapApiService codec) {
        this.codec = codec;
    }

    public String getOid() {
        return "1.3.6.1.4.1.4203.1.11.3";
    }

    public WhoAmIResponse newResponse(byte[] encodedValue) throws DecoderException {
        WhoAmIResponseDecorator response = new WhoAmIResponseDecorator(this.codec, (WhoAmIResponse)new WhoAmIResponseImpl());
        response.setResponseValue(encodedValue);
        return response;
    }

    public WhoAmIRequest newRequest(byte[] value) {
        WhoAmIRequestDecorator req = new WhoAmIRequestDecorator(this.codec, (WhoAmIRequest)new WhoAmIRequestImpl());
        if (value != null) {
            req.setRequestValue(value);
        }
        return req;
    }

    public WhoAmIRequestDecorator decorate(ExtendedRequest modelRequest) {
        if (modelRequest instanceof WhoAmIRequestDecorator) {
            return (WhoAmIRequestDecorator)modelRequest;
        }
        return new WhoAmIRequestDecorator(this.codec, (WhoAmIRequest)modelRequest);
    }

    public WhoAmIResponseDecorator decorate(ExtendedResponse decoratedResponse) {
        if (decoratedResponse instanceof WhoAmIResponseDecorator) {
            return (WhoAmIResponseDecorator)decoratedResponse;
        }
        if (decoratedResponse instanceof WhoAmIResponse) {
            return new WhoAmIResponseDecorator(this.codec, (WhoAmIResponse)decoratedResponse);
        }
        ExtendedResponseDecorator response = (ExtendedResponseDecorator)decoratedResponse;
        Asn1Decoder decoder = new Asn1Decoder();
        byte[] value = response.getResponseValue();
        ByteBuffer buffer = ByteBuffer.wrap(value);
        WhoAmIResponseContainer container = new WhoAmIResponseContainer();
        WhoAmIResponseDecorator whoAmIResponse = null;
        try {
            decoder.decode(buffer, (Asn1Container)container);
            whoAmIResponse = container.getWhoAmIResponse();
            whoAmIResponse.getLdapResult().setResultCode(response.getLdapResult().getResultCode());
            whoAmIResponse.getLdapResult().setDiagnosticMessage(response.getLdapResult().getDiagnosticMessage());
            whoAmIResponse.getLdapResult().setMatchedDn(response.getLdapResult().getMatchedDn());
            whoAmIResponse.getLdapResult().setReferral(response.getLdapResult().getReferral());
        }
        catch (DecoderException de) {
            StringWriter sw = new StringWriter();
            de.printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            whoAmIResponse = new WhoAmIResponseImpl(decoratedResponse.getMessageId(), ResultCodeEnum.OPERATIONS_ERROR, stackTrace);
        }
        return new WhoAmIResponseDecorator(this.codec, whoAmIResponse);
    }
}

