/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.support.VaultToken;

public class CubbyholeAuthenticationOptions {
    private final VaultToken initialToken;
    private final String path;
    private final boolean wrappedToken;
    private final boolean selfLookup;

    private CubbyholeAuthenticationOptions(VaultToken initialToken, String path, boolean wrappedToken, boolean selfLookup) {
        this.initialToken = initialToken;
        this.path = path;
        this.wrappedToken = wrappedToken;
        this.selfLookup = selfLookup;
    }

    public static CubbyholeAuthenticationOptionsBuilder builder() {
        return new CubbyholeAuthenticationOptionsBuilder();
    }

    public VaultToken getInitialToken() {
        return this.initialToken;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isWrappedToken() {
        return this.wrappedToken;
    }

    public boolean isSelfLookup() {
        return this.selfLookup;
    }

    public static class CubbyholeAuthenticationOptionsBuilder {
        @Nullable
        private VaultToken initialToken;
        @Nullable
        private String path;
        private boolean wrappedToken;
        private boolean selfLookup = true;

        CubbyholeAuthenticationOptionsBuilder() {
        }

        public CubbyholeAuthenticationOptionsBuilder initialToken(VaultToken initialToken) {
            Assert.notNull((Object)initialToken, (String)"Initial Vault Token must not be null");
            this.initialToken = initialToken;
            return this;
        }

        public CubbyholeAuthenticationOptionsBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public CubbyholeAuthenticationOptionsBuilder wrapped() {
            this.path = "cubbyhole/response";
            this.wrappedToken = true;
            return this;
        }

        public CubbyholeAuthenticationOptionsBuilder selfLookup(boolean selfLookup) {
            this.selfLookup = selfLookup;
            return this;
        }

        public CubbyholeAuthenticationOptions build() {
            Assert.notNull((Object)this.initialToken, (String)"Initial Vault Token must not be null");
            Assert.notNull((Object)this.path, (String)"Path must not be null");
            return new CubbyholeAuthenticationOptions(this.initialToken, this.path, this.wrappedToken, this.selfLookup);
        }
    }
}

