/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis.cli;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.StdIoLogger;
import de.thetaphi.forbiddenapis.cli.ExitException;
import de.thetaphi.forbiddenapis.commons.cli.CommandLine;
import de.thetaphi.forbiddenapis.commons.cli.DefaultParser;
import de.thetaphi.forbiddenapis.commons.cli.HelpFormatter;
import de.thetaphi.forbiddenapis.commons.cli.Option;
import de.thetaphi.forbiddenapis.commons.cli.OptionGroup;
import de.thetaphi.forbiddenapis.commons.cli.Options;
import de.thetaphi.forbiddenapis.plexus.util.DirectoryScanner;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Locale;

public final class CliMain
implements Constants {
    private final Option classpathOpt;
    private final Option dirOpt;
    private final Option includesOpt;
    private final Option excludesOpt;
    private final Option signaturesfileOpt;
    private final Option bundledsignaturesOpt;
    private final Option suppressannotationsOpt;
    private final Option internalruntimeforbiddenOpt;
    private final Option allowmissingclassesOpt;
    private final Option allowunresolvablesignaturesOpt;
    private final Option versionOpt;
    private final Option helpOpt;
    private final CommandLine cmd;
    private static final Logger LOG = StdIoLogger.INSTANCE;
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_VIOLATION = 1;
    public static final int EXIT_ERR_CMDLINE = 2;
    public static final int EXIT_UNSUPPORTED_JDK = 3;
    public static final int EXIT_ERR_OTHER = 4;

    public CliMain(String ... args) throws ExitException {
        OptionGroup required = new OptionGroup();
        required.setRequired(true);
        this.dirOpt = Option.builder("d").desc("directory with class files to check for forbidden api usage; this directory is also added to classpath").longOpt("dir").hasArg().argName("directory").build();
        required.addOption(this.dirOpt);
        this.versionOpt = Option.builder("V").desc("print product version and exit").longOpt("version").build();
        required.addOption(this.versionOpt);
        this.helpOpt = Option.builder("h").desc("print this help").longOpt("help").build();
        required.addOption(this.helpOpt);
        Options options = new Options();
        options.addOptionGroup(required);
        this.classpathOpt = Option.builder("c").desc("class search path of directories and zip/jar files").longOpt("classpath").hasArgs().valueSeparator(File.pathSeparatorChar).argName("path").build();
        options.addOption(this.classpathOpt);
        this.includesOpt = Option.builder("i").desc("ANT-style pattern to select class files (separated by commas or option can be given multiple times, defaults to '**/*.class')").longOpt("includes").hasArgs().valueSeparator(',').argName("pattern").build();
        options.addOption(this.includesOpt);
        this.excludesOpt = Option.builder("e").desc("ANT-style pattern to exclude some files from checks (separated by commas or option can be given multiple times)").longOpt("excludes").hasArgs().valueSeparator(',').argName("pattern").build();
        options.addOption(this.excludesOpt);
        this.signaturesfileOpt = Option.builder("f").desc("path to a file containing signatures (option can be given multiple times)").longOpt("signaturesfile").hasArg().argName("file").build();
        options.addOption(this.signaturesfileOpt);
        this.bundledsignaturesOpt = Option.builder("b").desc("name of a bundled signatures definition (separated by commas or option can be given multiple times)").longOpt("bundledsignatures").hasArgs().valueSeparator(',').argName("name").build();
        options.addOption(this.bundledsignaturesOpt);
        this.suppressannotationsOpt = Option.builder().desc("class name or glob pattern of annotation that suppresses error reporting in classes/methods/fields (separated by commas or option can be given multiple times)").longOpt("suppressannotation").hasArgs().valueSeparator(',').argName("classname").build();
        options.addOption(this.suppressannotationsOpt);
        this.internalruntimeforbiddenOpt = Option.builder().desc(String.format(Locale.ENGLISH, "DEPRECATED: forbids calls to non-portable runtime APIs; use bundled signatures '%s' instead", "jdk-non-portable")).longOpt("internalruntimeforbidden").build();
        options.addOption(this.internalruntimeforbiddenOpt);
        this.allowmissingclassesOpt = Option.builder().desc("don't fail if a referenced class is missing on classpath").longOpt("allowmissingclasses").build();
        options.addOption(this.allowmissingclassesOpt);
        this.allowunresolvablesignaturesOpt = Option.builder().desc("don't fail if a signature is not resolving").longOpt("allowunresolvablesignatures").build();
        options.addOption(this.allowunresolvablesignaturesOpt);
        try {
            this.cmd = new DefaultParser().parse(options, args);
            if (this.cmd.hasOption(this.helpOpt.getLongOpt())) {
                this.printHelp(options);
                throw new ExitException(0);
            }
            if (this.cmd.hasOption(this.versionOpt.getLongOpt())) {
                this.printVersion();
                throw new ExitException(0);
            }
        }
        catch (de.thetaphi.forbiddenapis.commons.cli.ParseException pe) {
            this.printHelp(options);
            throw new ExitException(2);
        }
    }

    private void printVersion() {
        Package pkg = this.getClass().getPackage();
        LOG.info(String.format(Locale.ENGLISH, "%s %s", pkg.getImplementationTitle(), pkg.getImplementationVersion()));
    }

    private void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String clazzName = this.getClass().getName();
        String cmdline = "java " + clazzName;
        try {
            URL jarUrl;
            URLConnection conn = this.getClass().getClassLoader().getResource(AsmUtils.getClassResourceName(clazzName)).openConnection();
            if (conn instanceof JarURLConnection && "file".equalsIgnoreCase((jarUrl = ((JarURLConnection)conn).getJarFileURL()).getProtocol())) {
                String cwd = new File(".").getCanonicalPath();
                String path = new File(jarUrl.toURI()).getCanonicalPath();
                cmdline = "java -jar " + (path.startsWith(cwd) ? path.substring(cwd.length() + File.separator.length()) : path);
            }
        }
        catch (IOException ioe) {
        }
        catch (URISyntaxException use) {
            // empty catch block
        }
        formatter.printHelp(cmdline + " [options]", "Scans a set of class files for forbidden API usage.", options, String.format(Locale.ENGLISH, "Exit codes: %d = SUCCESS, %d = forbidden API detected, %d = invalid command line, %d = unsupported JDK version, %d = other error (I/O,...)", 0, 1, 2, 3, 4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ExitException {
        URL[] urls;
        File classesDirectory = new File(this.cmd.getOptionValue(this.dirOpt.getLongOpt())).getAbsoluteFile();
        String[] classpath = this.cmd.getOptionValues(this.classpathOpt.getLongOpt());
        try {
            if (classpath == null) {
                urls = new URL[]{classesDirectory.toURI().toURL()};
            } else {
                urls = new URL[classpath.length + 1];
                int i = 0;
                for (String cpElement : classpath) {
                    urls[i++] = new File(cpElement).toURI().toURL();
                }
                urls[i++] = classesDirectory.toURI().toURL();
                assert (i == urls.length);
            }
        }
        catch (MalformedURLException mfue) {
            throw new ExitException(4, "The given classpath is invalid: " + mfue);
        }
        URLClassLoader loader = URLClassLoader.newInstance(urls, ClassLoader.getSystemClassLoader());
        try {
            EnumSet<Checker.Option> options = EnumSet.of(Checker.Option.FAIL_ON_VIOLATION);
            if (!this.cmd.hasOption(this.allowmissingclassesOpt.getLongOpt())) {
                options.add(Checker.Option.FAIL_ON_MISSING_CLASSES);
            }
            if (!this.cmd.hasOption(this.allowunresolvablesignaturesOpt.getLongOpt())) {
                options.add(Checker.Option.FAIL_ON_UNRESOLVABLE_SIGNATURES);
            }
            Checker checker = new Checker(LOG, (ClassLoader)loader, options);
            if (!checker.isSupportedJDK) {
                throw new ExitException(3, String.format(Locale.ENGLISH, "Your Java runtime (%s %s) is not supported by forbiddenapis. Please run the checks with a supported JDK!", System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version")));
            }
            String[] suppressAnnotations = this.cmd.getOptionValues(this.suppressannotationsOpt.getLongOpt());
            if (suppressAnnotations != null) {
                for (String a : suppressAnnotations) {
                    checker.addSuppressAnnotation(a);
                }
            }
            LOG.info("Scanning for classes to check...");
            if (!classesDirectory.exists()) {
                throw new ExitException(4, "Directory with class files does not exist: " + classesDirectory);
            }
            Object[] includes = this.cmd.getOptionValues(this.includesOpt.getLongOpt());
            if (includes == null || includes.length == 0) {
                includes = new String[]{"**/*.class"};
            }
            Object[] excludes = this.cmd.getOptionValues(this.excludesOpt.getLongOpt());
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(classesDirectory);
            ds.setCaseSensitive(true);
            ds.setIncludes((String[])includes);
            ds.setExcludes((String[])excludes);
            ds.addDefaultExcludes();
            ds.scan();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                throw new ExitException(4, String.format(Locale.ENGLISH, "No classes found in directory %s (includes=%s, excludes=%s).", classesDirectory, Arrays.toString(includes), Arrays.toString(excludes)));
            }
            try {
                String[] signaturesFiles;
                String[] bundledSignatures = this.cmd.getOptionValues(this.bundledsignaturesOpt.getLongOpt());
                if (bundledSignatures != null) {
                    for (String bs : new LinkedHashSet<String>(Arrays.asList(bundledSignatures))) {
                        checker.addBundledSignatures(bs, null);
                    }
                }
                if (this.cmd.hasOption(this.internalruntimeforbiddenOpt.getLongOpt())) {
                    LOG.warn(DEPRECATED_WARN_INTERNALRUNTIME);
                    checker.addBundledSignatures("jdk-non-portable", null);
                }
                if ((signaturesFiles = this.cmd.getOptionValues(this.signaturesfileOpt.getLongOpt())) != null) {
                    for (String sf : new LinkedHashSet<String>(Arrays.asList(signaturesFiles))) {
                        File f = new File(sf).getAbsoluteFile();
                        checker.parseSignaturesFile(f);
                    }
                }
            }
            catch (IOException ioe) {
                throw new ExitException(4, "IO problem while reading files with API signatures: " + ioe);
            }
            catch (ParseException pe) {
                throw new ExitException(4, "Parsing signatures failed: " + pe.getMessage());
            }
            if (checker.hasNoSignatures()) {
                throw new ExitException(2, String.format(Locale.ENGLISH, "No API signatures found; use parameters '--%s' and/or '--%s' to specify those!", this.bundledsignaturesOpt.getLongOpt(), this.signaturesfileOpt.getLongOpt()));
            }
            try {
                checker.addClassesToCheck(classesDirectory, files);
            }
            catch (IOException ioe) {
                throw new ExitException(4, "Failed to load one of the given class files: " + ioe);
            }
            try {
                checker.run();
            }
            catch (ForbiddenApiException fae) {
                throw new ExitException(1, fae.getMessage());
            }
        }
        finally {
            if (loader instanceof Closeable) {
                try {
                    ((Closeable)loader).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void main(String ... args) {
        block3: {
            try {
                new CliMain(args).run();
            }
            catch (ExitException e) {
                if (e.getMessage() != null) {
                    LOG.error(e.getMessage());
                }
                if (e.exitCode == 0) break block3;
                System.exit(e.exitCode);
            }
        }
    }
}

