/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hbase;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class WebHBaseServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "WEBHBASE";
    private static final String SERVICE_TYPE = "HBASE";
    private static final String ROLE_TYPE = "HBASERESTSERVER";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return SERVICE_TYPE.equals(service.getType()) && ROLE_TYPE.equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, "hbase_restserver_port");
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, "hbase_restserver_ssl_enable"));
        String scheme = sslEnabled ? "https" : "http";
        return new ServiceModel(ServiceModel.Type.API, SERVICE, String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
    }
}

