/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.creator;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.credentials.OAuth20Credentials;
import org.pac4j.oauth.profile.OAuth20Profile;
import org.pac4j.oauth.profile.creator.OAuthProfileCreator;

public class OAuth20ProfileCreator<U extends OAuth20Profile>
extends OAuthProfileCreator<OAuth20Credentials, U, OAuth20Configuration, OAuth2AccessToken, OAuth20Service> {
    public OAuth20ProfileCreator(OAuth20Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    protected OAuth2AccessToken getAccessToken(OAuth20Credentials credentials) {
        return credentials.getAccessToken();
    }

    @Override
    protected void addAccessTokenToProfile(U profile, OAuth2AccessToken accessToken) {
        if (profile != null) {
            String token = accessToken.getAccessToken();
            this.logger.debug("add access_token: {} to profile", (Object)token);
            ((OAuth20Profile)((Object)profile)).setAccessToken(token);
        }
    }

    @Override
    protected void signRequest(OAuth20Service service, OAuth2AccessToken accessToken, OAuthRequest request) {
        service.signRequest(accessToken, request);
        if (((OAuth20Configuration)this.configuration).isTokenAsHeader()) {
            request.addHeader("Authorization", "Bearer " + accessToken.getAccessToken());
        }
        if (Verb.POST.equals((Object)request.getVerb())) {
            request.addParameter("oauth_token", accessToken.getAccessToken());
        }
    }
}

