/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import com.github.scribejava.apis.HiOrgServerApi20;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.hiorgserver.HiOrgServerConfiguration;
import org.pac4j.oauth.profile.hiorgserver.HiOrgServerProfile;
import org.pac4j.oauth.profile.hiorgserver.HiOrgServerProfileDefinition;

public class HiOrgServerClient
extends OAuth20Client<HiOrgServerProfile> {
    private static final String LOGOUT_URL = "https://www.hiorg-server.de/logout.php";

    public HiOrgServerClient() {
        this.configuration = new HiOrgServerConfiguration();
    }

    public HiOrgServerClient(String key, String secret) {
        this.configuration = new HiOrgServerConfiguration();
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        this.configuration.setApi(HiOrgServerApi20.instance());
        this.configuration.setProfileDefinition(new HiOrgServerProfileDefinition());
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error");
            String errorDescription = ctx.getRequestParameter("error_description");
            if ("access_denied".equals(error)) {
                this.logger.debug(errorDescription);
                return true;
            }
            return false;
        });
        this.configuration.setWithState(true);
        this.defaultLogoutActionBuilder((ctx, profile, targetUrl) -> RedirectAction.redirect((String)LOGOUT_URL));
        super.clientInit();
    }
}

