/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.hdfs.dispatch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.hdfs.dispatch.HdfsHttpClientDispatch;
import org.apache.knox.gateway.hdfs.dispatch.SafeModeException;
import org.apache.knox.gateway.hdfs.dispatch.StandbyException;
import org.apache.knox.gateway.hdfs.i18n.WebHdfsMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public abstract class AbstractHdfsHaDispatch
extends HdfsHttpClientDispatch {
    private static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    private static final WebHdfsMessages LOG = (WebHdfsMessages)MessagesFactory.get(WebHdfsMessages.class);
    private int maxFailoverAttempts = 3;
    private int failoverSleep = 1000;
    private HaProvider haProvider;

    public void init() {
        super.init();
        if (this.haProvider != null) {
            HaServiceConfig serviceConfig = this.haProvider.getHaDescriptor().getServiceConfig(this.getResourceRole());
            this.maxFailoverAttempts = serviceConfig.getMaxFailoverAttempts();
            this.failoverSleep = serviceConfig.getFailoverSleep();
        }
    }

    public HaProvider getHaProvider() {
        return this.haProvider;
    }

    abstract String getResourceRole();

    @Configure
    public void setHaProvider(HaProvider haProvider) {
        this.haProvider = haProvider;
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (StandbyException e) {
            LOG.errorReceivedFromStandbyNode(e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
        catch (SafeModeException e) {
            LOG.errorReceivedFromSafeModeNode(e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    protected void writeOutboundResponse(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        if (inboundResponse.getStatusLine().getStatusCode() == 403) {
            BufferedHttpEntity entity = new BufferedHttpEntity(inboundResponse.getEntity());
            inboundResponse.setEntity((HttpEntity)entity);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            inboundResponse.getEntity().writeTo((OutputStream)outputStream);
            String body = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            if (body.contains("StandbyException")) {
                throw new StandbyException();
            }
            if (body.contains("SafeModeException") || body.contains("RetriableException")) {
                throw new SafeModeException();
            }
        }
        super.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
    }

    private void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        LOG.failedToConnectTo(outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(FAILOVER_COUNTER_ATTRIBUTE, (Object)counter);
        if (counter.incrementAndGet() <= this.maxFailoverAttempts) {
            this.haProvider.markFailedURL(this.getResourceRole(), outboundRequest.getURI().toString());
            inboundRequest.setAttribute("targetRequestUrl", null);
            URI uri = this.getDispatchUrl(inboundRequest);
            ((HttpRequestBase)outboundRequest).setURI(uri);
            if (this.failoverSleep > 0) {
                try {
                    Thread.sleep(this.failoverSleep);
                }
                catch (InterruptedException e) {
                    LOG.failoverSleepFailed(this.getResourceRole(), e);
                }
            }
            LOG.failingOverRequest(outboundRequest.getURI().toString());
            this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.maxFailoverAttempts, this.getResourceRole());
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }
}

