/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.security;

import java.security.AccessController;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.knox.gateway.security.ImpersonatedPrincipal;
import org.apache.knox.gateway.security.PrimaryPrincipal;

public class SubjectUtils {
    public static Subject getCurrentSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    public static String getPrimaryPrincipalName(Subject subject) {
        String name;
        block1: {
            name = null;
            Set<PrimaryPrincipal> primaryPrincipals = subject.getPrincipals(PrimaryPrincipal.class);
            if (!primaryPrincipals.isEmpty()) {
                return ((PrimaryPrincipal)primaryPrincipals.toArray()[0]).getName();
            }
            Set<Principal> principals = subject.getPrincipals();
            Iterator<Principal> iterator = principals.iterator();
            if (!iterator.hasNext()) break block1;
            Principal p = iterator.next();
            name = p.getName();
        }
        return name;
    }

    public static boolean isImpersonating(Subject subject) {
        boolean impersonating = false;
        impersonating = subject.getPrincipals(ImpersonatedPrincipal.class).size() > 0;
        return impersonating;
    }

    public static String getImpersonatedPrincipalName(Subject subject) {
        String name = null;
        Set<ImpersonatedPrincipal> impPrincipals = subject.getPrincipals(ImpersonatedPrincipal.class);
        if (!impPrincipals.isEmpty()) {
            return ((Principal)impPrincipals.toArray()[0]).getName();
        }
        return name;
    }

    public static String getEffectivePrincipalName(Subject subject) {
        String name = null;
        name = SubjectUtils.getImpersonatedPrincipalName(subject);
        if (name == null) {
            name = SubjectUtils.getPrimaryPrincipalName(subject);
        }
        return name;
    }

    public static String getCurrentEffectivePrincipalName() {
        String name = null;
        Subject subject = SubjectUtils.getCurrentSubject();
        if (subject != null && (name = SubjectUtils.getImpersonatedPrincipalName(subject)) == null) {
            name = SubjectUtils.getPrimaryPrincipalName(subject);
        }
        return name;
    }
}

