/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.ambari.ServiceURLFactory;

class AmbariCluster
implements ServiceDiscovery.Cluster {
    private static final AmbariServiceDiscoveryMessages log;
    private static final String ZK_CONFIG_MAPPING_FILE = "ambari-service-discovery-zk-config-mapping.properties";
    private static final String ZK_CONFIG_MAPPING_OVERRIDE_FILE = "ambari-discovery-zk-config.properties";
    static final String ZK_CONFIG_MAPPING_SYSTEM_PROPERTY = "org.apache.knox.gateway.topology.discovery.ambari.zk.mapping";
    private static final Properties zooKeeperHAConfigMappings;
    private String name;
    private ServiceURLFactory urlFactory;
    private Map<String, Map<String, ServiceConfiguration>> serviceConfigurations = new HashMap<String, Map<String, ServiceConfiguration>>();
    private Map<String, AmbariComponent> components;

    AmbariCluster(String name) {
        this.name = name;
        this.components = new HashMap<String, AmbariComponent>();
        this.urlFactory = ServiceURLFactory.newInstance(this);
    }

    void addServiceConfiguration(String serviceName, String configurationType, ServiceConfiguration serviceConfig) {
        if (!this.serviceConfigurations.keySet().contains(serviceName)) {
            this.serviceConfigurations.put(serviceName, new HashMap());
        }
        this.serviceConfigurations.get(serviceName).put(configurationType, serviceConfig);
    }

    void addComponent(AmbariComponent component) {
        this.components.put(component.getName(), component);
    }

    ServiceConfiguration getServiceConfiguration(String serviceName, String configurationType) {
        ServiceConfiguration sc = null;
        Map<String, ServiceConfiguration> configs = this.serviceConfigurations.get(serviceName);
        if (configs != null) {
            sc = configs.get(configurationType);
        }
        return sc;
    }

    Map<String, Map<String, ServiceConfiguration>> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    Map<String, AmbariComponent> getComponents() {
        return this.components;
    }

    AmbariComponent getComponent(String name) {
        return this.components.get(name);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getServiceURLs(String serviceName) {
        return this.getServiceURLs(serviceName, null);
    }

    public List<String> getServiceURLs(String serviceName, Map<String, String> serviceParams) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.addAll(this.urlFactory.create(serviceName, serviceParams));
        return urls;
    }

    public ServiceDiscovery.Cluster.ZooKeeperConfig getZooKeeperConfiguration(String serviceName) {
        ServiceConfiguration sc;
        String[] parts;
        ZooKeeperConfiguration result = null;
        String config = zooKeeperHAConfigMappings.getProperty(serviceName + ".config");
        if (config != null && (parts = config.split(":")).length == 2 && (sc = this.getServiceConfiguration(parts[0], parts[1])) != null) {
            String enabledProp = zooKeeperHAConfigMappings.getProperty(serviceName + ".enabled");
            String ensembleProp = zooKeeperHAConfigMappings.getProperty(serviceName + ".ensemble");
            String portProp = zooKeeperHAConfigMappings.getProperty(serviceName + ".port");
            String namespaceProp = zooKeeperHAConfigMappings.getProperty(serviceName + ".namespace");
            Map<String, String> scProps = sc.getProperties();
            if (scProps != null) {
                String[] ensembleProps;
                if (ensembleProp != null && (ensembleProps = ensembleProp.split(",")).length > 1) {
                    for (String prop : ensembleProps) {
                        String value;
                        if (prop.isEmpty() || (value = scProps.get(prop)) == null) continue;
                        ensembleProp = prop;
                        break;
                    }
                }
                result = new ZooKeeperConfiguration(enabledProp != null ? scProps.get(enabledProp) : null, ensembleProp != null ? scProps.get(ensembleProp) : null, portProp != null ? scProps.get(portProp) : null, namespaceProp != null ? scProps.get(namespaceProp) : null);
            }
        }
        return result;
    }

    static {
        block18: {
            log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
            zooKeeperHAConfigMappings = new Properties();
            try {
                File overridesFile;
                Properties defaults = new Properties();
                defaults.load(AmbariServiceDiscovery.class.getClassLoader().getResourceAsStream(ZK_CONFIG_MAPPING_FILE));
                for (String name : defaults.stringPropertyNames()) {
                    zooKeeperHAConfigMappings.setProperty(name, defaults.getProperty(name));
                }
                String overridesPath = null;
                String gatewayConfDir = System.getProperty("org.apache.knox.gateway.conf.dir");
                if (gatewayConfDir != null && (overridesFile = new File(gatewayConfDir, ZK_CONFIG_MAPPING_OVERRIDE_FILE)).exists()) {
                    overridesPath = overridesFile.getAbsolutePath();
                }
                if (overridesPath == null) {
                    overridesPath = System.getProperty(ZK_CONFIG_MAPPING_SYSTEM_PROPERTY);
                }
                if (overridesPath == null) break block18;
                Properties overrides = new Properties();
                try (FileInputStream in = new FileInputStream(overridesPath);){
                    overrides.load(in);
                    for (String name : overrides.stringPropertyNames()) {
                        zooKeeperHAConfigMappings.setProperty(name, overrides.getProperty(name));
                    }
                }
            }
            catch (Exception e) {
                log.failedToLoadZooKeeperConfigurationMapping(e);
            }
        }
    }

    static class ZooKeeperConfiguration
    implements ServiceDiscovery.Cluster.ZooKeeperConfig {
        boolean isEnabled;
        String ensemble;
        String namespace;

        ZooKeeperConfiguration(String enabled, String ensemble, String port, String namespace) {
            this.namespace = namespace;
            this.ensemble = port == null ? ensemble : this.applyPortToEnsemble(ensemble, port);
            this.isEnabled = enabled != null ? Boolean.valueOf(enabled) : true;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public String getEnsemble() {
            return this.ensemble;
        }

        public String getNamespace() {
            return this.namespace;
        }

        private String applyPortToEnsemble(String ensemble, String port) {
            String updatedEnsemble = "";
            String[] hosts = ensemble.split(",");
            int index = 0;
            for (String host : hosts) {
                int portIndex = host.indexOf(58);
                if (portIndex > 0) {
                    host = host.substring(0, portIndex);
                }
                updatedEnsemble = updatedEnsemble + host + ":" + port;
                if (++index >= hosts.length) continue;
                updatedEnsemble = updatedEnsemble + ",";
            }
            return updatedEnsemble;
        }
    }

    static class ServiceConfiguration {
        private String type;
        private String version;
        private Map<String, String> props;

        ServiceConfiguration(String type, String version, Map<String, String> properties) {
            this.type = type;
            this.version = version;
            this.props = properties;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getProperties() {
            return this.props;
        }
    }
}

