/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.directory.mavibot.btree.AbstractBTree;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.AbstractValueHolder;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.BTreeHeader;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.InMemoryBTree;
import org.apache.directory.mavibot.btree.InMemoryBTreeBuilder;
import org.apache.directory.mavibot.btree.InMemoryBTreeConfiguration;
import org.apache.directory.mavibot.btree.InMemoryLeaf;
import org.apache.directory.mavibot.btree.InMemoryValueHolder;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.LevelInfo;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedKeyHolder;
import org.apache.directory.mavibot.btree.PersistedLeaf;
import org.apache.directory.mavibot.btree.PersistedNode;
import org.apache.directory.mavibot.btree.PersistedValueHolder;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleComparator;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.comparator.IntComparator;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;

public class BulkLoader<K, V> {
    private BulkLoader() {
    }

    private static <K, V> int readElements(BTree<K, V> btree, Iterator<Tuple<K, V>> iterator, List<File> sortedFiles, List<Tuple<K, V>> tuples, int chunkSize) throws IOException {
        int nbRead = 0;
        int nbIteration = 0;
        int nbElems = 0;
        boolean inMemory = true;
        HashSet<K> keys = new HashSet<K>();
        while (true) {
            ++nbIteration;
            tuples.clear();
            keys.clear();
            while (iterator.hasNext() && nbRead < chunkSize) {
                Tuple<K, V> tuple = iterator.next();
                tuples.add(tuple);
                if (keys.contains(tuple.getKey())) continue;
                keys.add(tuple.getKey());
                ++nbRead;
            }
            if (nbRead < chunkSize) {
                if (nbIteration != 1) {
                    inMemory = false;
                    sortedFiles.add(BulkLoader.flushToDisk(nbIteration, tuples, btree));
                }
                nbElems += nbRead;
                break;
            }
            if (!iterator.hasNext()) {
                if (nbIteration > 1) {
                    inMemory = false;
                    sortedFiles.add(BulkLoader.flushToDisk(nbIteration, tuples, btree));
                }
                nbElems += nbRead;
                break;
            }
            nbElems += nbRead;
            nbRead = 0;
            sortedFiles.add(BulkLoader.flushToDisk(nbIteration, tuples, btree));
        }
        if (!inMemory) {
            tuples.clear();
        }
        return nbElems;
    }

    private static <K, V> Tuple<Iterator<Tuple<K, Set<V>>>, SortedFile> processFiles(BTree<K, V> btree, Iterator<Tuple<K, Set<V>>> dataIterator) throws IOException {
        File file = File.createTempFile("sortedUnique", "data");
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        int nbReads = 0;
        while (dataIterator.hasNext()) {
            ++nbReads;
            Tuple<K, Set<V>> tuple = dataIterator.next();
            byte[] bytesKey = btree.getKeySerializer().serialize(tuple.key);
            fos.write(IntSerializer.serialize(bytesKey.length));
            fos.write(bytesKey);
            int nbValues = tuple.getValue().size();
            fos.write(IntSerializer.serialize(nbValues));
            for (V value : tuple.getValue()) {
                byte[] bytesValue = btree.getValueSerializer().serialize(value);
                fos.write(IntSerializer.serialize(bytesValue.length));
                fos.write(bytesValue);
            }
        }
        fos.flush();
        fos.close();
        FileInputStream fis = new FileInputStream(file);
        Iterator<Tuple<K, Set<V>>> uniqueIterator = BulkLoader.createUniqueFileIterator(btree, fis);
        SortedFile sortedFile = new SortedFile(file, nbReads);
        Tuple<Iterator<Tuple<K, Set<V>>>, SortedFile> result = new Tuple<Iterator<Tuple<K, Set<V>>>, SortedFile>(uniqueIterator, sortedFile);
        return result;
    }

    public static <K, V> BTree<K, V> load(BTree<K, V> btree, Iterator<Tuple<K, V>> iterator, int chunkSize) throws IOException {
        int nbFiles;
        if (btree == null) {
            throw new RuntimeException("Invalid BTree : it's null");
        }
        if (iterator == null) {
            return null;
        }
        boolean inMemory = true;
        ArrayList<File> sortedFiles = new ArrayList<File>();
        ArrayList<Tuple<K, V>> tuples = new ArrayList<Tuple<K, V>>(chunkSize);
        int nbElems = BulkLoader.readElements(btree, iterator, sortedFiles, tuples, chunkSize);
        if (nbElems > 0) {
            inMemory = tuples.size() > 0;
        }
        Iterator<Tuple<K, Set<V>>> dataIterator = null;
        FileInputStream[] streams = null;
        BTree<K, V> resultBTree = null;
        if (inMemory) {
            dataIterator = BulkLoader.createTupleIterator(btree, tuples);
            resultBTree = BulkLoader.bulkLoad(btree, dataIterator, nbElems);
        } else {
            nbFiles = sortedFiles.size();
            streams = new FileInputStream[nbFiles];
            for (int i = 0; i < nbFiles; ++i) {
                streams[i] = new FileInputStream((File)sortedFiles.get(i));
            }
            dataIterator = BulkLoader.createIterator(btree, streams);
            Tuple<Iterator<Tuple<K, Set<V>>>, SortedFile> result = BulkLoader.processFiles(btree, dataIterator);
            resultBTree = BulkLoader.bulkLoad(btree, (Iterator)result.key, ((SortedFile)result.value).nbValues);
            ((SortedFile)result.value).file.delete();
        }
        if (!inMemory) {
            nbFiles = sortedFiles.size();
            for (int i = 0; i < nbFiles; ++i) {
                streams[i].close();
                ((File)sortedFiles.get(i)).delete();
            }
        }
        return resultBTree;
    }

    static <K, V> LevelInfo<K, V> computeLevel(BTree<K, V> btree, int nbElems, LevelEnum levelType) {
        int pageSize = btree.getPageSize();
        int incrementNode = 0;
        if (levelType == LevelEnum.NODE) {
            incrementNode = 1;
        }
        LevelInfo<K, V> level = new LevelInfo<K, V>();
        level.setType(levelType == LevelEnum.NODE);
        level.setNbElems(nbElems);
        level.setNbPages(nbElems / (pageSize + incrementNode));
        level.setLevelNumber(0);
        level.setNbAddedElems(0);
        level.setCurrentPos(0);
        if (nbElems <= pageSize + incrementNode) {
            if (nbElems % (pageSize + incrementNode) != 0) {
                level.setNbPages(1);
            }
            level.setNbElemsLimit(nbElems);
            if (level.isNode()) {
                level.setCurrentPage(BTreeFactory.createNode(btree, 0L, nbElems - 1));
            } else {
                level.setCurrentPage(BTreeFactory.createLeaf(btree, 0L, nbElems));
            }
        } else {
            int remaining = nbElems % (pageSize + incrementNode);
            if (remaining == 0) {
                level.setNbElemsLimit(nbElems);
                if (level.isNode()) {
                    level.setCurrentPage(BTreeFactory.createNode(btree, 0L, pageSize));
                } else {
                    level.setCurrentPage(BTreeFactory.createLeaf(btree, 0L, pageSize));
                }
            } else {
                level.incNbPages();
                if (remaining < pageSize / 2 + incrementNode) {
                    level.setNbElemsLimit(nbElems - remaining - (pageSize + incrementNode));
                    if (level.getNbElemsLimit() > 0) {
                        if (level.isNode()) {
                            level.setCurrentPage(BTreeFactory.createNode(btree, 0L, pageSize));
                        } else {
                            level.setCurrentPage(BTreeFactory.createLeaf(btree, 0L, pageSize));
                        }
                    } else if (level.isNode()) {
                        level.setCurrentPage(BTreeFactory.createNode(btree, 0L, pageSize / 2 + remaining - 1));
                    } else {
                        level.setCurrentPage(BTreeFactory.createLeaf(btree, 0L, pageSize / 2 + remaining));
                    }
                } else {
                    level.setNbElemsLimit(nbElems - remaining);
                    if (level.isNode()) {
                        level.setCurrentPage(BTreeFactory.createNode(btree, 0L, pageSize));
                    } else {
                        level.setCurrentPage(BTreeFactory.createLeaf(btree, 0L, pageSize));
                    }
                }
            }
        }
        return level;
    }

    static <K, V> List<LevelInfo<K, V>> computeLevels(BTree<K, V> btree, int nbElems) {
        ArrayList<LevelInfo<K, V>> levelList = new ArrayList<LevelInfo<K, V>>();
        LevelInfo<K, V> leafLevel = BulkLoader.computeLevel(btree, nbElems, LevelEnum.LEAF);
        levelList.add(leafLevel);
        int nbPages = leafLevel.getNbPages();
        int levelNumber = 1;
        while (nbPages > 1) {
            LevelInfo<K, V> nodeLevel = BulkLoader.computeLevel(btree, nbPages, LevelEnum.NODE);
            nodeLevel.setLevelNumber(levelNumber++);
            levelList.add(nodeLevel);
            nbPages = nodeLevel.getNbPages();
        }
        return levelList;
    }

    private static <K, V> void injectInLeaf(BTree<K, V> btree, Tuple<K, Set<V>> tuple, LevelInfo<K, V> leafLevel) {
        PersistedLeaf leaf = (PersistedLeaf)leafLevel.getCurrentPage();
        PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), tuple.getKey());
        leaf.setKey(leafLevel.getCurrentPos(), keyHolder);
        if (btree.getType() != BTreeTypeEnum.PERSISTED_SUB) {
            PersistedValueHolder<Object> valueHolder = new PersistedValueHolder<Object>(btree, tuple.getValue().toArray());
            leaf.setValue(leafLevel.getCurrentPos(), valueHolder);
        }
        leafLevel.incCurrentPos();
    }

    private static <K, V> int computeNbElemsLeaf(BTree<K, V> btree, LevelInfo<K, V> levelInfo) {
        int pageSize = btree.getPageSize();
        int remaining = levelInfo.getNbElems() - levelInfo.getNbAddedElems();
        if (remaining < pageSize) {
            return remaining;
        }
        if (remaining == pageSize) {
            return pageSize;
        }
        if (remaining > levelInfo.getNbElems() - levelInfo.getNbElemsLimit()) {
            return pageSize;
        }
        return remaining - pageSize / 2;
    }

    int computeNbElemsNode(BTree<K, V> btree, LevelInfo<K, V> levelInfo) {
        int pageSize = btree.getPageSize();
        int remaining = levelInfo.getNbElems() - levelInfo.getNbAddedElems();
        if (remaining < pageSize + 1) {
            return remaining;
        }
        if (remaining == pageSize + 1) {
            return pageSize + 1;
        }
        if (remaining > levelInfo.getNbElems() - levelInfo.getNbElemsLimit()) {
            return pageSize + 1;
        }
        return remaining - pageSize / 2;
    }

    private static <K, V> void injectInRoot(BTree<K, V> btree, Page<K, V> page, PageHolder<K, V> pageHolder, LevelInfo<K, V> level) throws IOException {
        PersistedNode node = (PersistedNode)level.getCurrentPage();
        if (level.getCurrentPos() == 0 && node.getPage(0) == null) {
            node.setPageHolder(0, pageHolder);
            level.incNbAddedElems();
        } else {
            node.setPageHolder(level.getCurrentPos() + 1, pageHolder);
            PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
            node.setKey(level.getCurrentPos(), keyHolder);
            level.incCurrentPos();
            level.incNbAddedElems();
            if (level.getNbAddedElems() == level.getNbElems()) {
                PageHolder<K, V> rootHolder = ((PersistedBTree)btree).getRecordManager().writePage(btree, node, 0L);
                ((PersistedBTree)btree).setRootPage(rootHolder.getValue());
            }
        }
    }

    private static <K, V> void injectInNode(BTree<K, V> btree, Page<K, V> page, List<LevelInfo<K, V>> levels, int levelIndex) throws IOException {
        int pageSize = btree.getPageSize();
        LevelInfo<K, V> level = levels.get(levelIndex);
        PersistedNode node = (PersistedNode)level.getCurrentPage();
        PageHolder<K, V> pageHolder = ((PersistedBTree)btree).getRecordManager().writePage(btree, page, 0L);
        if (level.getNbElems() <= pageSize + 1) {
            BulkLoader.injectInRoot(btree, page, pageHolder, level);
            return;
        }
        if (level.getNbAddedElems() < level.getNbElemsLimit()) {
            if (level.getCurrentPos() == 0 && node.getKey(0) == null) {
                node.setPageHolder(0, pageHolder);
            } else {
                node.setPageHolder(level.getCurrentPos(), pageHolder);
                PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                node.setKey(level.getCurrentPos() - 1, keyHolder);
            }
            level.incCurrentPos();
            level.incNbAddedElems();
            if (level.getNbAddedElems() == level.getNbElems()) {
                BulkLoader.injectInNode(btree, node, levels, levelIndex + 1);
                return;
            }
            if (level.getCurrentPos() == pageSize + 1 && level.getLevelNumber() < levels.size() - 1) {
                BulkLoader.injectInNode(btree, node, levels, levelIndex + 1);
                if (level.getNbAddedElems() < level.getNbElemsLimit()) {
                    level.setCurrentPage(BTreeFactory.createNode(btree, 0L, pageSize));
                } else if (level.getNbElems() - level.getNbAddedElems() <= pageSize) {
                    level.setCurrentPage(BTreeFactory.createNode(btree, 0L, level.getNbElems() - level.getNbAddedElems() - 1));
                } else {
                    level.setCurrentPage(BTreeFactory.createNode(btree, 0L, level.getNbElems() - 1 - (level.getNbAddedElems() + 1) - pageSize / 2));
                }
                level.setCurrentPos(0);
            }
            return;
        }
        if (level.getNbElems() - level.getNbElemsLimit() > pageSize) {
            if (level.getNbElems() - level.getNbAddedElems() <= pageSize / 2 + 1) {
                if (level.getCurrentPos() == 0 && node.getKey(0) == null) {
                    node.setPageHolder(0, pageHolder);
                } else {
                    node.setPageHolder(level.getCurrentPos(), pageHolder);
                    PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                    node.setKey(level.getCurrentPos() - 1, keyHolder);
                }
                level.incCurrentPos();
                level.incNbAddedElems();
                if (level.getNbAddedElems() == level.getNbElems()) {
                    BulkLoader.injectInNode(btree, node, levels, levelIndex + 1);
                }
            } else {
                if (level.getCurrentPos() == 0 && node.getKey(0) == null) {
                    node.setPageHolder(0, pageHolder);
                } else {
                    node.setPageHolder(level.getCurrentPos(), pageHolder);
                    PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                    node.setKey(level.getCurrentPos() - 1, keyHolder);
                }
                level.incCurrentPos();
                level.incNbAddedElems();
                if (level.getCurrentPos() == node.getNbElems() + 1) {
                    BulkLoader.injectInNode(btree, node, levels, levelIndex + 1);
                    level.setCurrentPage(BTreeFactory.createNode(btree, 0L, pageSize / 2));
                    level.setCurrentPos(0);
                }
            }
        } else {
            if (level.getNbAddedElems() == level.getNbElems()) {
                BulkLoader.injectInNode(btree, node, levels, levelIndex + 1);
            } else {
                if (level.getCurrentPos() == 0 && node.getKey(0) == null) {
                    node.setPageHolder(0, pageHolder);
                } else {
                    node.setPageHolder(level.getCurrentPos(), pageHolder);
                    PersistedKeyHolder<K> keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), page.getLeftMostKey());
                    node.setKey(level.getCurrentPos() - 1, keyHolder);
                }
                level.incCurrentPos();
                level.incNbAddedElems();
                if (level.getCurrentPos() == node.getNbElems() + 1) {
                    BulkLoader.injectInNode(btree, node, levels, levelIndex + 1);
                    level.setCurrentPage(BTreeFactory.createNode(btree, 0L, pageSize / 2));
                    level.setCurrentPos(0);
                }
            }
            return;
        }
    }

    private static <K, V> BTree<K, V> bulkLoadSinglePage(BTree<K, V> btree, Iterator<Tuple<K, Set<V>>> dataIterator, int nbElems) throws IOException {
        Page<K, V> rootPage = btree.getRootPage();
        ((AbstractPage)rootPage).setNbElems(nbElems);
        KeyHolder[] keys = new KeyHolder[nbElems];
        ValueHolder[] values = new ValueHolder[nbElems];
        switch (btree.getType()) {
            case IN_MEMORY: {
                ((InMemoryLeaf)rootPage).values = values;
                break;
            }
            default: {
                ((PersistedLeaf)rootPage).values = values;
            }
        }
        int pos = 0;
        while (dataIterator.hasNext()) {
            PersistedKeyHolder<K> keyHolder;
            Tuple<K, Set<V>> tuple = dataIterator.next();
            keys[pos] = keyHolder = new PersistedKeyHolder<K>(btree.getKeySerializer(), tuple.getKey());
            switch (btree.getType()) {
                case IN_MEMORY: {
                    AbstractValueHolder valueHolder = new InMemoryValueHolder<Object>(btree, tuple.getValue().toArray());
                    ((InMemoryLeaf)rootPage).values[pos] = valueHolder;
                    break;
                }
                default: {
                    AbstractValueHolder valueHolder = new PersistedValueHolder<Object>(btree, tuple.getValue().toArray());
                    ((PersistedLeaf)rootPage).values[pos] = valueHolder;
                }
            }
            ++pos;
        }
        ((AbstractPage)rootPage).setKeys(keys);
        BTreeHeader btreeHeader = ((AbstractBTree)btree).getBtreeHeader();
        btreeHeader.setNbElems(nbElems);
        return btree;
    }

    private static <K, V> BTree<K, V> bulkLoad(BTree<K, V> btree, Iterator<Tuple<K, Set<V>>> dataIterator, int nbElems) throws IOException {
        int pageSize = btree.getPageSize();
        if (nbElems <= pageSize) {
            return BulkLoader.bulkLoadSinglePage(btree, dataIterator, nbElems);
        }
        List<LevelInfo<K, V>> levels = BulkLoader.computeLevels(btree, nbElems);
        LevelInfo<K, V> leafLevel = levels.get(0);
        while (dataIterator.hasNext()) {
            if (leafLevel.getNbAddedElems() < leafLevel.getNbElemsLimit()) {
                Tuple<K, Set<V>> tuple = dataIterator.next();
                BulkLoader.injectInLeaf(btree, tuple, leafLevel);
                leafLevel.incNbAddedElems();
                if (leafLevel.getCurrentPos() != pageSize) continue;
                BulkLoader.injectInNode(btree, leafLevel.getCurrentPage(), levels, 1);
                leafLevel.setCurrentPage(BTreeFactory.createLeaf(btree, 0L, BulkLoader.computeNbElemsLeaf(btree, leafLevel)));
                leafLevel.setCurrentPos(0);
                continue;
            }
            if (leafLevel.getNbAddedElems() == nbElems) break;
            if (nbElems - leafLevel.getNbElemsLimit() > pageSize) {
                int nbToAdd;
                for (nbToAdd = nbElems - leafLevel.getNbElemsLimit() - pageSize / 2; nbToAdd > 0; --nbToAdd) {
                    Tuple<K, Set<V>> tuple = dataIterator.next();
                    BulkLoader.injectInLeaf(btree, tuple, leafLevel);
                    leafLevel.incNbAddedElems();
                }
                Page<K, V> currentPage = leafLevel.getCurrentPage();
                BulkLoader.injectInNode(btree, currentPage, levels, 1);
                leafLevel.setCurrentPage(BTreeFactory.createLeaf(btree, 0L, nbToAdd));
                leafLevel.setCurrentPos(0);
                for (nbToAdd = pageSize / 2; nbToAdd > 0; --nbToAdd) {
                    Tuple<K, Set<V>> tuple = dataIterator.next();
                    BulkLoader.injectInLeaf(btree, tuple, leafLevel);
                    leafLevel.incNbAddedElems();
                }
                Page<K, V> levelCurrentPage = leafLevel.getCurrentPage();
                BulkLoader.injectInNode(btree, levelCurrentPage, levels, 1);
                break;
            }
            for (int nbToAdd = nbElems - leafLevel.getNbElemsLimit(); nbToAdd > 0; --nbToAdd) {
                Tuple<K, Set<V>> tuple = dataIterator.next();
                BulkLoader.injectInLeaf(btree, tuple, leafLevel);
                leafLevel.incNbAddedElems();
            }
            BulkLoader.injectInNode(btree, leafLevel.getCurrentPage(), levels, 1);
            break;
        }
        BTreeHeader btreeHeader = ((AbstractBTree)btree).getBtreeHeader();
        btreeHeader.setNbElems(nbElems);
        return btree;
    }

    private static <K, V> File flushToDisk(int fileNb, List<Tuple<K, V>> tuples, BTree<K, V> btree) throws IOException {
        Tuple<K, Set<V>>[] sortedTuples = BulkLoader.sort(btree, tuples);
        File file = File.createTempFile("sorted", Integer.toString(fileNb));
        file.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(file);
        for (Tuple<K, Set<V>> tuple : sortedTuples) {
            byte[] bytesKey = btree.getKeySerializer().serialize(tuple.key);
            fos.write(IntSerializer.serialize(bytesKey.length));
            fos.write(bytesKey);
            int nbValues = tuple.getValue().size();
            fos.write(IntSerializer.serialize(nbValues));
            for (V value : tuple.getValue()) {
                byte[] bytesValue = btree.getValueSerializer().serialize(value);
                fos.write(IntSerializer.serialize(bytesValue.length));
                fos.write(bytesValue);
            }
        }
        fos.flush();
        fos.close();
        return file;
    }

    private static <K, V> Tuple<K, Set<V>>[] sort(BTree<K, V> btree, List<Tuple<K, V>> tuples) {
        TupleComparator<K, V> tupleComparator = new TupleComparator<K, V>(btree.getKeyComparator(), btree.getValueComparator());
        Tuple[] tuplesArray = tuples.toArray(new Tuple[0]);
        HashMap mapTuples = new HashMap();
        for (Tuple tuple : tuplesArray) {
            Set foundSet = (Set)mapTuples.get(tuple.key);
            if (foundSet != null) {
                foundSet.add(tuple.value);
                continue;
            }
            TreeSet set = new TreeSet();
            set.add(tuple.value);
            mapTuples.put(tuple.key, set);
        }
        int size = mapTuples.size();
        Tuple[] sortedTuples = new Tuple[size];
        int pos = 0;
        for (Map.Entry entry : mapTuples.entrySet()) {
            sortedTuples[pos] = new Tuple();
            sortedTuples[pos].key = entry.getKey();
            sortedTuples[pos].value = entry.getValue();
            ++pos;
        }
        Arrays.sort(sortedTuples, tupleComparator);
        return sortedTuples;
    }

    private static <K, V> Iterator<Tuple<K, Set<V>>> createTupleIterator(BTree<K, V> btree, List<Tuple<K, V>> tuples) {
        final Tuple[] sortedTuples = BulkLoader.sort(btree, tuples);
        Iterator tupleIterator = new Iterator<Tuple<K, Set<V>>>(){
            private int pos = 0;

            @Override
            public Tuple<K, Set<V>> next() {
                if (this.pos < sortedTuples.length) {
                    Tuple tuple = sortedTuples[this.pos];
                    ++this.pos;
                    return tuple;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.pos < sortedTuples.length;
            }

            @Override
            public void remove() {
            }
        };
        return tupleIterator;
    }

    private static <K, V> Tuple<K, Set<V>> fetchTuple(BTree<K, V> btree, FileInputStream fis) {
        try {
            if (fis.available() == 0) {
                return null;
            }
            Tuple tuple = new Tuple();
            tuple.value = new TreeSet();
            byte[] intBytes = new byte[4];
            fis.read(intBytes);
            int keyLength = IntSerializer.deserialize(intBytes);
            byte[] keyBytes = new byte[keyLength];
            fis.read(keyBytes);
            K key = btree.getKeySerializer().fromBytes(keyBytes);
            tuple.key = key;
            fis.read(intBytes);
            int nbValues = IntSerializer.deserialize(intBytes);
            for (int i = 0; i < nbValues; ++i) {
                fis.read(intBytes);
                int valueLength = IntSerializer.deserialize(intBytes);
                byte[] valueBytes = new byte[valueLength];
                fis.read(valueBytes);
                V value = btree.getValueSerializer().fromBytes(valueBytes);
                ((Set)tuple.value).add(value);
            }
            return tuple;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static <K, V> Iterator<Tuple<K, Set<V>>> createIterator(final BTree<K, V> btree, final FileInputStream[] streams) throws FileNotFoundException {
        int nbFiles = streams.length;
        final Tuple[] readTuples = new Tuple[nbFiles];
        final TreeMap candidates = new TreeMap(new TupleComparator<K, Integer>(btree.getKeyComparator(), IntComparator.INSTANCE));
        block0: for (int i = 0; i < nbFiles; ++i) {
            while (true) {
                readTuples[i] = BulkLoader.fetchTuple(btree, streams[i]);
                if (readTuples[i] == null) continue block0;
                Tuple candidate = new Tuple(readTuples[i].key, i, btree.getKeySerializer().getComparator());
                if (!candidates.containsKey(candidate)) {
                    candidates.put(candidate, readTuples[i].getValue());
                    continue block0;
                }
                Set oldValues = (Set)candidates.get(candidate);
                oldValues.addAll((Collection)readTuples[i].getValue());
            }
        }
        Iterator tupleIterator = new Iterator<Tuple<K, Set<V>>>(){

            @Override
            public Tuple<K, Set<V>> next() {
                Tuple tuple;
                block1: {
                    Tuple tupleCandidate = (Tuple)candidates.firstKey();
                    candidates.remove(tupleCandidate);
                    tuple = readTuples[(Integer)tupleCandidate.value];
                    while (true) {
                        readTuples[((Integer)tupleCandidate.value).intValue()] = BulkLoader.fetchTuple(btree, streams[(Integer)tupleCandidate.value]);
                        if (readTuples[(Integer)tupleCandidate.value] == null) break block1;
                        if (readTuples[(Integer)tupleCandidate.value] == null) continue;
                        Set oldValues = (Set)candidates.get(readTuples[(Integer)tupleCandidate.value]);
                        if (oldValues == null) break;
                        oldValues.addAll((Collection)readTuples[((Integer)tupleCandidate.value).intValue()].value);
                    }
                    Tuple newTuple = new Tuple(readTuples[((Integer)tupleCandidate.value).intValue()].key, tupleCandidate.value);
                    candidates.put(newTuple, readTuples[(Integer)tupleCandidate.value].getValue());
                }
                return tuple;
            }

            @Override
            public boolean hasNext() {
                return !candidates.isEmpty();
            }

            @Override
            public void remove() {
            }
        };
        return tupleIterator;
    }

    private static <K, V> Iterator<Tuple<K, Set<V>>> createUniqueFileIterator(final BTree<K, V> btree, final FileInputStream stream) throws FileNotFoundException {
        Iterator tupleIterator = new Iterator<Tuple<K, Set<V>>>(){
            boolean hasNext = true;

            @Override
            public Tuple<K, Set<V>> next() {
                Tuple tuple = BulkLoader.fetchTuple(btree, stream);
                return tuple;
            }

            @Override
            public boolean hasNext() {
                try {
                    return stream.available() > 0;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public void remove() {
            }
        };
        return tupleIterator;
    }

    public static void compact(RecordManager recordManager, BTree<?, ?> btree) {
    }

    public static BTree<?, ?> compact(BTree<?, ?> btree) throws IOException, KeyNotFoundException {
        InMemoryBTreeConfiguration configuration = new InMemoryBTreeConfiguration();
        configuration.setName(btree.getName());
        configuration.setPageSize(btree.getPageSize());
        configuration.setKeySerializer(btree.getKeySerializer());
        configuration.setValueSerializer(btree.getValueSerializer());
        configuration.setAllowDuplicates(btree.isAllowDuplicates());
        configuration.setReadTimeOut(btree.getReadTimeOut());
        configuration.setWriteBufferSize(btree.getWriteBufferSize());
        File file = ((InMemoryBTree)btree).getFile();
        if (file != null) {
            configuration.setFilePath(file.getPath());
        }
        InMemoryBTreeBuilder btreeBuilder = new InMemoryBTreeBuilder(configuration);
        final TupleCursor<?, ?> cursor = btree.browse();
        Iterator<Tuple> tupleItr = new Iterator<Tuple>(){

            @Override
            public Tuple next() {
                try {
                    return cursor.next();
                }
                catch (EndOfFileExceededException e) {
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    return cursor.hasNext();
                }
                catch (EndOfFileExceededException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }

            @Override
            public void remove() {
            }
        };
        return btreeBuilder.build(tupleItr);
    }

    private static class SortedFile {
        private File file;
        private int nbValues;

        SortedFile(File file, int nbValues) {
            this.file = file;
            this.nbValues = nbValues;
        }
    }

    static enum LevelEnum {
        LEAF,
        NODE;

    }
}

