/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.registry.ServiceRegistry;

abstract class ServiceRegistryFunctionProcessorBase<T extends UrlRewriteFunctionDescriptor>
implements UrlRewriteFunctionProcessor<T> {
    private String cluster;
    private GatewayServices services;
    private ServiceRegistry registry;
    private HaProvider haProvider;

    ServiceRegistryFunctionProcessorBase() {
    }

    public void initialize(UrlRewriteEnvironment environment, T descriptor) throws Exception {
        if (environment == null) {
            throw new IllegalArgumentException("environment==null");
        }
        this.cluster = (String)environment.getAttribute("org.apache.knox.gateway.gateway.cluster");
        if (this.cluster == null) {
            throw new IllegalArgumentException("cluster==null");
        }
        this.services = (GatewayServices)environment.getAttribute("org.apache.knox.gateway.gateway.services");
        if (this.services == null) {
            throw new IllegalArgumentException("services==null");
        }
        this.registry = (ServiceRegistry)this.services.getService("ServiceRegistryService");
        if (this.registry == null) {
            throw new IllegalArgumentException("registry==null");
        }
        this.haProvider = (HaProvider)environment.getAttribute("haProvider");
    }

    public void destroy() throws Exception {
        this.registry = null;
        this.cluster = null;
    }

    public String lookupServiceUrl(String role) throws Exception {
        if (this.haProvider != null && this.haProvider.isHaEnabled(role)) {
            return this.haProvider.getActiveURL(role);
        }
        return this.registry.lookupServiceURL(this.cluster, role);
    }

    String cluster() {
        return this.cluster;
    }

    GatewayServices services() {
        return this.services;
    }

    ServiceRegistry registry() {
        return this.registry;
    }
}

