/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.MapEntryUtils;

public interface PropertyResolver {
    public static final PropertyResolver EMPTY = new PropertyResolver(){

        @Override
        public PropertyResolver getParentPropertyResolver() {
            return null;
        }

        @Override
        public Map<String, Object> getProperties() {
            return Collections.emptyMap();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public PropertyResolver getParentPropertyResolver();

    public Map<String, Object> getProperties();

    default public boolean isEmpty() {
        return MapEntryUtils.isEmpty(this.getProperties());
    }

    default public long getLongProperty(String name, long def) {
        return PropertyResolverUtils.getLongProperty(this, name, def);
    }

    default public Long getLong(String name) {
        return PropertyResolverUtils.getLong(this, name);
    }

    default public int getIntProperty(String name, int def) {
        return PropertyResolverUtils.getIntProperty(this, name, def);
    }

    default public Integer getInteger(String name) {
        return PropertyResolverUtils.getInteger(this, name);
    }

    default public boolean getBooleanProperty(String name, boolean def) {
        return PropertyResolverUtils.getBooleanProperty(this, name, def);
    }

    default public Boolean getBoolean(String name) {
        return PropertyResolverUtils.getBoolean(this, name);
    }

    default public String getStringProperty(String name, String def) {
        return PropertyResolverUtils.getStringProperty(this, name, def);
    }

    default public String getString(String name) {
        return PropertyResolverUtils.getString(this, name);
    }

    default public Object getObject(String name) {
        return PropertyResolverUtils.getObject(this, name);
    }

    default public Charset getCharset(String name, Charset defaultValue) {
        Object value = this.getObject(name);
        return value == null ? defaultValue : PropertyResolverUtils.toCharset(value);
    }

    public static boolean isEmpty(PropertyResolver resolver) {
        return resolver == null || resolver.isEmpty();
    }
}

