/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.aries.blueprint.container.GenericType;
import org.apache.aries.blueprint.di.ExecutionContext;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.osgi.framework.BundleReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;

public class ReflectionUtils {
    private static Map<Class<?>, WeakReference<Method[]>> publicMethods = Collections.synchronizedMap(new WeakHashMap());
    private static Map<Class<?>, PropertyDescriptor[][]> beanInfos = Collections.synchronizedMap(new WeakHashMap());

    public static boolean hasDefaultConstructor(Class type) {
        Constructor<?>[] constructors;
        if (!Modifier.isPublic(type.getModifiers())) {
            return false;
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            return false;
        }
        for (Constructor<?> constructor : constructors = type.getConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getImplementedInterfaces(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            for (Class<?> itf : clazz.getInterfaces()) {
                if (Modifier.isPublic(itf.getModifiers())) {
                    classes.add(itf.getName());
                }
                ReflectionUtils.getImplementedInterfaces(classes, itf);
            }
            ReflectionUtils.getImplementedInterfaces(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Set<Class<?>> getImplementedInterfacesAsClasses(Set<Class<?>> classes, Class<?> clazz) {
        if (clazz != null && clazz != Object.class) {
            for (Class<?> itf : clazz.getInterfaces()) {
                if (Modifier.isPublic(itf.getModifiers())) {
                    classes.add(itf);
                }
                ReflectionUtils.getImplementedInterfacesAsClasses(classes, itf);
            }
            ReflectionUtils.getImplementedInterfacesAsClasses(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Set<String> getSuperClasses(Set<String> classes, Class clazz) {
        if (clazz != null && clazz != Object.class) {
            if (Modifier.isPublic(clazz.getModifiers())) {
                classes.add(clazz.getName());
            }
            ReflectionUtils.getSuperClasses(classes, clazz.getSuperclass());
        }
        return classes;
    }

    public static Method getLifecycleMethod(Class clazz, String name) {
        if (name != null) {
            for (Method method : ReflectionUtils.getPublicMethods(clazz)) {
                if (!method.getName().equals(name) || method.getParameterTypes().length != 0 || !Void.TYPE.equals(method.getReturnType())) continue;
                return method;
            }
        }
        return null;
    }

    public static Method[] getPublicMethods(Class clazz) {
        Method[] methods;
        WeakReference<Method[]> ref = publicMethods.get(clazz);
        Method[] methodArray = methods = ref != null ? (Method[])ref.get() : null;
        if (methods == null) {
            ArrayList<Method> array = new ArrayList<Method>();
            ReflectionUtils.doGetPublicMethods(clazz, array);
            methods = array.toArray(new Method[array.size()]);
            publicMethods.put(clazz, new WeakReference<Method[]>(methods));
        }
        return methods;
    }

    private static void doGetPublicMethods(Class clazz, ArrayList<Method> methods) {
        Class parent = clazz.getSuperclass();
        if (parent != null) {
            ReflectionUtils.doGetPublicMethods(parent, methods);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            ReflectionUtils.doGetPublicMethods(clazz2, methods);
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            for (GenericDeclaration genericDeclaration : clazz.getMethods()) {
                ReflectionUtils.removeByNameAndSignature(methods, (Method)genericDeclaration);
                methods.add((Method)genericDeclaration);
            }
        }
    }

    private static void removeByNameAndSignature(ArrayList<Method> methods, Method toRemove) {
        for (int i = 0; i < methods.size(); ++i) {
            Method m = methods.get(i);
            if (m == null || m.getReturnType() != toRemove.getReturnType() || m.getName() != toRemove.getName() || !ReflectionUtils.arrayContentsEq(m.getParameterTypes(), toRemove.getParameterTypes())) continue;
            methods.remove(i--);
        }
    }

    private static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static List<Method> findCompatibleMethods(Class clazz, String name, Class[] paramTypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : ReflectionUtils.getPublicMethods(clazz)) {
            Class<?>[] methodParams = method.getParameterTypes();
            if (!name.equals(method.getName()) || !Void.TYPE.equals(method.getReturnType()) || methodParams.length != paramTypes.length || method.isBridge()) continue;
            boolean assignable = true;
            for (int i = 0; i < paramTypes.length && assignable; assignable &= paramTypes[i] == null || methodParams[i].isAssignableFrom(paramTypes[i]), ++i) {
            }
            if (!assignable) continue;
            methods.add(method);
        }
        return methods;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class clazz, boolean allowFieldInjection) {
        int index;
        PropertyDescriptor[][] properties = beanInfos.get(clazz);
        int n = index = allowFieldInjection ? 0 : 1;
        if (properties == null) {
            properties = new PropertyDescriptor[2][];
            beanInfos.put(clazz, properties);
        }
        if (properties[index] == null) {
            HashSet<String> propertyNames = new HashSet<String>();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            HashMap setters = new HashMap();
            HashSet<String> illegalProperties = new HashSet<String>();
            for (Method method : ReflectionUtils.getPublicMethods(clazz)) {
                if (Modifier.isStatic(method.getModifiers()) || method.isBridge()) continue;
                String name = method.getName();
                Class<?>[] argTypes = method.getParameterTypes();
                Class<?> resultType = method.getReturnType();
                if (name.length() > 3 && name.startsWith("set") && resultType == Void.TYPE && argTypes.length == 1) {
                    if (!setters.containsKey(name = ReflectionUtils.decapitalize(name.substring(3)))) {
                        setters.put(name, new ArrayList());
                    }
                    ((List)setters.get(name)).add(method);
                    propertyNames.add(name);
                    continue;
                }
                if (name.length() > 3 && name.startsWith("get") && resultType != Void.TYPE && argTypes.length == 0) {
                    if (getters.containsKey(name = ReflectionUtils.decapitalize(name.substring(3)))) {
                        illegalProperties.add(name);
                    } else {
                        propertyNames.add(name);
                    }
                    getters.put(name, method);
                    continue;
                }
                if (name.length() <= 2 || !name.startsWith("is") || argTypes.length != 0 || resultType != Boolean.TYPE) continue;
                if (getters.containsKey(name = ReflectionUtils.decapitalize(name.substring(2)))) {
                    illegalProperties.add(name);
                } else {
                    propertyNames.add(name);
                }
                getters.put(name, method);
            }
            HashMap<String, PropertyDescriptor> props = new HashMap<String, PropertyDescriptor>();
            for (String propName : propertyNames) {
                props.put(propName, new MethodPropertyDescriptor(propName, (Method)getters.get(propName), (Collection)setters.get(propName)));
            }
            if (allowFieldInjection) {
                for (Class cl = clazz; cl != null && cl != Object.class; cl = cl.getSuperclass()) {
                    for (Field field : cl.getDeclaredFields()) {
                        if (Modifier.isStatic(field.getModifiers())) continue;
                        String name = ReflectionUtils.decapitalize(field.getName());
                        PropertyDescriptor desc = (PropertyDescriptor)props.get(name);
                        if (desc == null) {
                            props.put(name, new FieldPropertyDescriptor(name, field));
                            continue;
                        }
                        if (desc instanceof MethodPropertyDescriptor) {
                            props.put(name, new JointPropertyDescriptor((MethodPropertyDescriptor)desc, new FieldPropertyDescriptor(name, field)));
                            continue;
                        }
                        illegalProperties.add(name);
                    }
                }
            }
            ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
            for (PropertyDescriptor prop : props.values()) {
                if (illegalProperties.contains(prop.getName())) continue;
                result.add(prop);
            }
            properties[index] = result.toArray(new PropertyDescriptor[result.size()]);
        }
        return properties[index];
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static Object invoke(AccessControlContext acc, final Method method, final Object instance, final Object ... args) throws Exception {
        if (acc == null) {
            return method.invoke(instance, args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return method.invoke(instance, args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Class clazz) throws Exception {
        if (acc == null) {
            return clazz.newInstance();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return clazz.newInstance();
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Object newInstance(AccessControlContext acc, final Constructor constructor, final Object ... args) throws Exception {
        if (acc == null) {
            return constructor.newInstance(args);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return constructor.newInstance(args);
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static Throwable getRealCause(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    private static class MethodPropertyDescriptor
    extends PropertyDescriptor {
        private final MethodDescriptor getter;
        private final Collection<MethodDescriptor> setters;

        private MethodPropertyDescriptor(String name, Method getter, Collection<Method> setters) {
            super(name);
            MethodDescriptor methodDescriptor = this.getter = getter != null ? new MethodDescriptor(getter) : null;
            if (setters != null) {
                ArrayList<MethodDescriptor> accumulator = new ArrayList<MethodDescriptor>();
                for (Method s : setters) {
                    accumulator.add(new MethodDescriptor(s));
                }
                this.setters = Collections.unmodifiableCollection(accumulator);
            } else {
                this.setters = Collections.emptyList();
            }
        }

        @Override
        public boolean allowsGet() {
            return this.getter != null;
        }

        @Override
        public boolean allowsSet() {
            return !this.setters.isEmpty();
        }

        @Override
        protected Object internalGet(ExtendedBlueprintContainer container, Object instance) throws Exception {
            if (this.getter != null) {
                return this.getter.getMethod(container).invoke(instance, new Object[0]);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        protected void internalSet(ExtendedBlueprintContainer container, Object instance, Object value) throws Exception {
            Method setterMethod = this.findSetter(container, value);
            if (setterMethod == null) {
                throw new ComponentDefinitionException("No converter available to convert value " + value + " into a form applicable for the setters of property " + this.getName());
            }
            setterMethod.invoke(instance, this.convert(value, this.resolveParameterType(instance.getClass(), setterMethod)));
        }

        private Type resolveParameterType(Class<?> impl, Method setterMethod) {
            Type type = setterMethod.getGenericParameterTypes()[0];
            Class<?> declaringClass = setterMethod.getDeclaringClass();
            TypeVariable<Class<?>>[] declaredVariables = declaringClass.getTypeParameters();
            if (TypeVariable.class.isInstance(type)) {
                int index;
                TypeVariable variable = (TypeVariable)TypeVariable.class.cast(type);
                for (index = 0; index < declaredVariables.length && variable != declaredVariables[index]; ++index) {
                }
                if (index >= declaredVariables.length) {
                    return type;
                }
                for (Class<?> c = impl; c != null && c != declaringClass; c = c.getSuperclass()) {
                    ParameterizedType pt;
                    Type sup = c.getGenericSuperclass();
                    if (sup == null || !ParameterizedType.class.isInstance(sup) || declaringClass != (pt = (ParameterizedType)ParameterizedType.class.cast(sup)).getRawType()) continue;
                    Type t = pt.getActualTypeArguments()[index];
                    return t;
                }
                return type;
            }
            return type;
        }

        private Method findSetter(ExtendedBlueprintContainer container, Object value) throws Exception {
            Collection<Method> setterMethods;
            Class<?> valueType = value == null ? null : value.getClass();
            Method getterMethod = this.getter != null ? this.getter.getMethod(container) : null;
            Method result = this.findMethodByClass(getterMethod, setterMethods = this.getSetters(container), valueType);
            if (result == null) {
                result = this.findMethodWithConversion(setterMethods, value);
            }
            return result;
        }

        private Collection<Method> getSetters(ExtendedBlueprintContainer container) throws Exception {
            ArrayList<Method> result = new ArrayList<Method>();
            for (MethodDescriptor md : this.setters) {
                result.add(md.getMethod(container));
            }
            return result;
        }

        private Method findMethodByClass(Method getterMethod, Collection<Method> setterMethods, Class<?> arg) throws ComponentDefinitionException {
            Method result = null;
            if (!this.hasSameTypeSetter(getterMethod, setterMethods)) {
                throw new ComponentDefinitionException("At least one Setter method has to match the type of the Getter method for property " + this.getName());
            }
            if (setterMethods.size() == 1) {
                return setterMethods.iterator().next();
            }
            for (Method m : setterMethods) {
                Class<?> paramType = m.getParameterTypes()[0];
                if ((arg != null || !Object.class.isAssignableFrom(paramType)) && (arg == null || !paramType.isAssignableFrom(arg))) continue;
                if (result != null) {
                    Class<?> oldParamType = result.getParameterTypes()[0];
                    if (paramType.isAssignableFrom(oldParamType)) continue;
                    if (oldParamType.isAssignableFrom(paramType)) {
                        result = m;
                        continue;
                    }
                    throw new ComponentDefinitionException("Ambiguous setter method for property " + this.getName() + ". More than one method matches the  parameter type " + arg);
                }
                result = m;
            }
            return result;
        }

        private boolean hasSameTypeSetter(Method getterMethod, Collection<Method> setterMethods) {
            if (getterMethod == null) {
                return true;
            }
            for (Method m : setterMethods) {
                if (!m.getParameterTypes()[0].equals(getterMethod.getReturnType())) continue;
                return true;
            }
            return false;
        }

        private Method findMethodWithConversion(Collection<Method> setterMethods, Object value) throws Exception {
            ExecutionContext ctx = ExecutionContext.Holder.getContext();
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            for (Method m : setterMethods) {
                Type paramType = m.getGenericParameterTypes()[0];
                if (!ctx.canConvert(value, new GenericType(paramType))) continue;
                matchingMethods.add(m);
            }
            if (matchingMethods.isEmpty()) {
                return null;
            }
            if (matchingMethods.size() == 1) {
                return (Method)matchingMethods.get(0);
            }
            throw new ComponentDefinitionException("Ambiguous setter method for property " + this.getName() + ". More than one method matches the parameter " + value + " after applying conversion.");
        }

        public String toString() {
            return "PropertyDescriptor <name: " + this.getName() + ", getter: " + this.getter + ", setter: " + this.setters;
        }
    }

    private static class MethodDescriptor {
        private final String methodName;
        private final WeakReference<Class<?>> declaringClass;
        private final List<WeakReference<Class<?>>> argClasses;

        public MethodDescriptor(Method method) {
            this.methodName = method.getName();
            this.declaringClass = new WeakReference(method.getDeclaringClass());
            ArrayList accumulator = new ArrayList();
            for (Class<?> c : method.getParameterTypes()) {
                accumulator.add(new WeakReference(c));
            }
            this.argClasses = Collections.unmodifiableList(accumulator);
        }

        public Method getMethod(ExtendedBlueprintContainer container) throws ClassNotFoundException, NoSuchMethodException {
            Class[] argumentClasses = new Class[this.argClasses.size()];
            for (int i = 0; i < this.argClasses.size(); ++i) {
                argumentClasses[i] = (Class)this.argClasses.get(i).get();
                if (argumentClasses[i] != null) continue;
                throw new ClassNotFoundException("Argument class was garbage collected");
            }
            if (this.declaringClass.get() == null) {
                throw new ClassNotFoundException("Declaring class was garbage collected");
            }
            return ((Class)this.declaringClass.get()).getMethod(this.methodName, argumentClasses);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.declaringClass.get()).append(".").append(this.methodName).append("(");
            boolean first = true;
            for (WeakReference<Class<?>> wcl : this.argClasses) {
                if (!first) {
                    builder.append(",");
                } else {
                    first = false;
                }
                builder.append(wcl.get());
            }
            builder.append(")");
            return builder.toString();
        }
    }

    private static class FieldPropertyDescriptor
    extends PropertyDescriptor {
        private final String fieldName;
        private final WeakReference<Class<?>> declaringClass;

        public FieldPropertyDescriptor(String name, Field field) {
            super(name);
            this.fieldName = field.getName();
            this.declaringClass = new WeakReference(field.getDeclaringClass());
        }

        @Override
        public boolean allowsGet() {
            return true;
        }

        @Override
        public boolean allowsSet() {
            return true;
        }

        private Field getField(ExtendedBlueprintContainer container) throws ClassNotFoundException, NoSuchFieldException {
            if (this.declaringClass.get() == null) {
                throw new ClassNotFoundException("Declaring class was garbage collected");
            }
            return ((Class)this.declaringClass.get()).getDeclaredField(this.fieldName);
        }

        @Override
        protected Object internalGet(final ExtendedBlueprintContainer container, final Object instance) throws Exception {
            if (this.useContainersPermission(container)) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return FieldPropertyDescriptor.this.doInternalGet(container, instance);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    if (e instanceof IllegalAccessException) {
                        throw (IllegalAccessException)e;
                    }
                    throw (RuntimeException)e;
                }
            }
            return this.doInternalGet(container, instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object doInternalGet(ExtendedBlueprintContainer container, Object instance) throws Exception {
            Field field = this.getField(container);
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object object = field.get(instance);
                return object;
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }

        @Override
        protected void internalSet(final ExtendedBlueprintContainer container, final Object instance, final Object value) throws Exception {
            try {
                Boolean wasSet = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws Exception {
                        if (FieldPropertyDescriptor.this.useContainersPermission(container)) {
                            FieldPropertyDescriptor.this.doInternalSet(container, instance, value);
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                });
                if (!wasSet.booleanValue()) {
                    this.doInternalSet(container, instance, value);
                }
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doInternalSet(ExtendedBlueprintContainer container, Object instance, Object value) throws Exception {
            Field field = this.getField(container);
            Object convertedValue = this.convert(value, field.getGenericType());
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(instance, convertedValue);
            }
            finally {
                field.setAccessible(isAccessible);
            }
        }

        private boolean useContainersPermission(ExtendedBlueprintContainer container) throws ClassNotFoundException {
            if (this.declaringClass.get() == null) {
                throw new ClassNotFoundException("Declaring class was garbage collected");
            }
            ClassLoader loader = ((Class)this.declaringClass.get()).getClassLoader();
            if (loader == null) {
                return false;
            }
            if (loader instanceof BundleReference) {
                BundleReference ref = (BundleReference)loader;
                return ref.getBundle().equals(container.getBundleContext().getBundle());
            }
            return false;
        }
    }

    private static class JointPropertyDescriptor
    extends PropertyDescriptor {
        private final MethodPropertyDescriptor mpd;
        private final FieldPropertyDescriptor fpd;

        public JointPropertyDescriptor(MethodPropertyDescriptor mpd, FieldPropertyDescriptor fpd) {
            super(mpd.getName());
            this.mpd = mpd;
            this.fpd = fpd;
        }

        @Override
        public boolean allowsGet() {
            return this.mpd.allowsGet() || this.fpd.allowsGet();
        }

        @Override
        public boolean allowsSet() {
            return this.mpd.allowsSet() || this.fpd.allowsSet();
        }

        @Override
        protected Object internalGet(ExtendedBlueprintContainer container, Object instance) throws Exception {
            if (this.mpd.allowsGet()) {
                return this.mpd.internalGet(container, instance);
            }
            if (this.fpd.allowsGet()) {
                return this.fpd.internalGet(container, instance);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        protected void internalSet(ExtendedBlueprintContainer container, Object instance, Object value) throws Exception {
            if (this.mpd.allowsSet()) {
                this.mpd.internalSet(container, instance, value);
            } else if (this.fpd.allowsSet()) {
                this.fpd.internalSet(container, instance, value);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static abstract class PropertyDescriptor {
        private final String name;

        public PropertyDescriptor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract boolean allowsGet();

        public abstract boolean allowsSet();

        protected abstract Object internalGet(ExtendedBlueprintContainer var1, Object var2) throws Exception;

        protected abstract void internalSet(ExtendedBlueprintContainer var1, Object var2, Object var3) throws Exception;

        public Object get(final Object instance, final ExtendedBlueprintContainer container) throws Exception {
            if (container.getAccessControlContext() == null) {
                return this.internalGet(container, instance);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        return PropertyDescriptor.this.internalGet(container, instance);
                    }
                }, container.getAccessControlContext());
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }

        public void set(final Object instance, final Object value, final ExtendedBlueprintContainer container) throws Exception {
            if (container.getAccessControlContext() == null) {
                this.internalSet(container, instance, value);
            } else {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            PropertyDescriptor.this.internalSet(container, instance, value);
                            return null;
                        }
                    }, container.getAccessControlContext());
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        }

        protected Object convert(Object obj, Type type) throws Exception {
            return ExecutionContext.Holder.getContext().convert(obj, new GenericType(type));
        }
    }
}

