/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.OCD;
import org.apache.felix.metatype.internal.LocalizedObjectClassDefinition;
import org.apache.felix.metatype.internal.l10n.BundleResources;
import org.apache.felix.metatype.internal.l10n.Resources;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class DefaultMetaTypeProvider
implements MetaTypeProvider {
    private final Bundle bundle;
    private final String localePrefix;
    private Map objectClassDefinitions;
    private List designates;
    private String[] locales;

    public DefaultMetaTypeProvider(Bundle bundle, MetaData metadata) {
        Cloneable copy;
        this.bundle = bundle;
        if (metadata.getObjectClassDefinitions() == null) {
            this.objectClassDefinitions = Collections.EMPTY_MAP;
        } else {
            copy = new HashMap(metadata.getObjectClassDefinitions());
            this.objectClassDefinitions = Collections.unmodifiableMap(copy);
        }
        if (metadata.getDesignates() == null) {
            this.designates = Collections.EMPTY_LIST;
        } else {
            copy = new ArrayList(metadata.getDesignates());
            this.designates = Collections.unmodifiableList(copy);
        }
        String metaDataLocalePrefix = metadata.getLocalePrefix();
        if (metaDataLocalePrefix == null && (metaDataLocalePrefix = (String)bundle.getHeaders().get("Bundle-Localization")) == null) {
            metaDataLocalePrefix = "OSGI-INF/l10n/bundle";
        }
        this.localePrefix = metaDataLocalePrefix;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String[] getLocales() {
        if (this.locales == null) {
            String pattern;
            String path;
            int lastSlash = this.localePrefix.lastIndexOf(47);
            if (lastSlash < 0) {
                path = "/";
                pattern = this.localePrefix;
            } else {
                path = this.localePrefix.substring(0, lastSlash);
                pattern = this.localePrefix.substring(lastSlash + 1);
            }
            TreeSet<String> localeSet = new TreeSet<String>();
            Enumeration entries = this.getBundle().findEntries(path, pattern + "*.properties", false);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    URL url = (URL)entries.nextElement();
                    String name = url.getPath();
                    if ((name = name.substring(name.lastIndexOf(47) + 1 + pattern.length(), name.length() - ".properties".length())).startsWith("_")) {
                        name = name.substring(1);
                    }
                    if (name.length() <= 0) continue;
                    localeSet.add(name);
                }
            }
            this.locales = localeSet.toArray(new String[localeSet.size()]);
        }
        return this.locales.length == 0 ? null : this.locales;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        Designate designate = this.getDesignate(id);
        if (designate == null || designate.getObject() == null) {
            return null;
        }
        String ocdRef = designate.getObject().getOcdRef();
        OCD ocd = (OCD)this.objectClassDefinitions.get(ocdRef);
        if (ocd == null) {
            return null;
        }
        Resources resources = BundleResources.getResources(this.bundle, this.localePrefix, locale);
        return new LocalizedObjectClassDefinition(this.bundle, ocd, resources);
    }

    public Designate getDesignate(String pid) {
        int size = this.designates.size();
        for (int i = 0; i < size; ++i) {
            Designate designate = (Designate)this.designates.get(i);
            String factoryPid = designate.getFactoryPid();
            if (factoryPid != null && pid.equals(factoryPid)) {
                return designate;
            }
            if (factoryPid != null || !pid.equals(designate.getPid())) continue;
            return designate;
        }
        return null;
    }

    protected Map getObjectClassDefinitions() {
        return this.objectClassDefinitions;
    }

    protected List getDesignates() {
        return this.designates;
    }
}

