/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.modules.publickey.PublickeyCallback;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafJaasAuthenticator
implements PasswordAuthenticator,
PublickeyAuthenticator {
    public static final Session.AttributeKey<Subject> SUBJECT_ATTRIBUTE_KEY = new Session.AttributeKey();
    private final Logger LOGGER = LoggerFactory.getLogger(KarafJaasAuthenticator.class);
    private String realm;
    private String role;

    public KarafJaasAuthenticator() {
    }

    public KarafJaasAuthenticator(String realm, String role) {
        this.realm = realm;
        this.role = role;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean authenticate(final String username, final String password, ServerSession session) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            });
            loginContext.login();
            int roleCount = 0;
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof RolePrincipal)) continue;
                ++roleCount;
            }
            if (roleCount == 0) {
                throw new FailedLoginException("User doesn't have role defined");
            }
            session.setAttribute(SUBJECT_ATTRIBUTE_KEY, (Object)subject);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.debug("User authentication failed with " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean authenticate(final String username, final PublicKey key, ServerSession session) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                            continue;
                        }
                        if (callback instanceof PublickeyCallback) {
                            ((PublickeyCallback)callback).setPublicKey(key);
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            });
            loginContext.login();
            boolean hasCorrectRole = this.role == null || this.role.isEmpty();
            int roleCount = 0;
            for (Principal principal : subject.getPrincipals()) {
                if (!(principal instanceof RolePrincipal)) continue;
                if (!hasCorrectRole) {
                    hasCorrectRole = this.role.equals(principal.getName());
                }
                ++roleCount;
            }
            if (roleCount == 0) {
                throw new FailedLoginException("User doesn't have role defined");
            }
            if (!hasCorrectRole) {
                throw new FailedLoginException("User doesn't have the required role " + this.role);
            }
            session.setAttribute(SUBJECT_ATTRIBUTE_KEY, (Object)subject);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.debug("User authentication failed with " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

