/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AllPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.URLHandlersBundleURLConnection;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.util.ImmutableList;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.ManifestParser;
import org.apache.felix.framework.util.manifestparser.NativeLibrary;
import org.apache.felix.framework.util.manifestparser.NativeLibraryClause;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.apache.felix.framework.wiring.BundleWireImpl;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

class ExtensionManager
extends URLStreamHandler
implements Content {
    static final ExtensionManager m_extensionManager;
    private final Logger m_logger;
    private final Map m_configMap;
    private final Map m_headerMap = new StringMap();
    private final BundleRevisionImpl m_systemBundleRevision;
    private volatile List<BundleCapability> m_capabilities = Collections.EMPTY_LIST;
    private volatile Set<String> m_exportNames = Collections.EMPTY_SET;
    private volatile Object m_securityContext = null;
    private final List m_extensions;
    private volatile Bundle[] m_extensionsCache;
    private final Set m_names;
    private final Map m_sourceToExtensions;
    private final List<ExtensionTuple> m_extensionTuples = Collections.synchronizedList(new ArrayList());

    private ExtensionManager() {
        this.m_logger = null;
        this.m_configMap = null;
        this.m_systemBundleRevision = null;
        this.m_extensions = new ArrayList();
        this.m_extensionsCache = new Bundle[0];
        this.m_names = new HashSet();
        this.m_sourceToExtensions = new HashMap();
    }

    ExtensionManager(Logger logger, Map configMap, Felix felix) {
        this.m_logger = logger;
        this.m_configMap = configMap;
        this.m_systemBundleRevision = new ExtensionManagerRevision(felix);
        this.m_extensions = null;
        this.m_extensionsCache = null;
        this.m_names = null;
        this.m_sourceToExtensions = null;
        this.m_headerMap.put("Bundle-Version", this.m_configMap.get("felix.version"));
        this.m_headerMap.put("Bundle-SymbolicName", "org.apache.felix.framework");
        this.m_headerMap.put("Bundle-Name", "System Bundle");
        this.m_headerMap.put("Bundle-Description", "This bundle is system specific; it implements various system services.");
        this.m_headerMap.put("Export-Service", "org.osgi.service.packageadmin.PackageAdmin,org.osgi.service.startlevel.StartLevel,org.osgi.service.url.URLHandlers");
        String syspkgs = (String)this.m_configMap.get("org.osgi.framework.system.packages");
        syspkgs = syspkgs == null ? Util.getDefaultProperty(logger, "org.osgi.framework.system.packages") : syspkgs;
        syspkgs = syspkgs == null ? "" : syspkgs;
        String pkgextra = (String)this.m_configMap.get("org.osgi.framework.system.packages.extra");
        syspkgs = pkgextra == null || pkgextra.trim().length() == 0 ? syspkgs : syspkgs + "," + pkgextra;
        this.m_headerMap.put("Bundle-ManifestVersion", "2");
        this.m_headerMap.put("Export-Package", syspkgs);
        String syscaps = (String)this.m_configMap.get("org.osgi.framework.system.capabilities");
        syscaps = syscaps == null ? Util.getDefaultProperty(logger, "org.osgi.framework.system.capabilities") : syscaps;
        syscaps = syscaps == null ? "" : syscaps;
        String capextra = (String)this.m_configMap.get("org.osgi.framework.system.capabilities.extra");
        syscaps = capextra == null || capextra.trim().length() == 0 ? syscaps : syscaps + "," + capextra;
        this.m_headerMap.put("Provide-Capability", syscaps);
        try {
            ManifestParser mp = new ManifestParser(this.m_logger, this.m_configMap, this.m_systemBundleRevision, this.m_headerMap);
            List<BundleCapability> caps = ExtensionManager.aliasSymbolicName(mp.getCapabilities());
            caps.add(this.buildNativeCapabilites());
            this.appendCapabilities(caps);
        }
        catch (Exception ex) {
            this.m_capabilities = Collections.EMPTY_LIST;
            this.m_logger.log(1, "Error parsing system bundle export statement: " + syspkgs, ex);
        }
    }

    protected BundleCapability buildNativeCapabilites() {
        String osArchitecture = (String)this.m_configMap.get("org.osgi.framework.processor");
        String osName = (String)this.m_configMap.get("org.osgi.framework.os.name");
        String osVersion = (String)this.m_configMap.get("org.osgi.framework.os.version");
        String userLang = (String)this.m_configMap.get("org.osgi.framework.language");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(this.m_configMap);
        if (osArchitecture != null) {
            attributes.put("osgi.native.processor", NativeLibraryClause.getProcessorWithAliases(osArchitecture));
        }
        if (osName != null) {
            attributes.put("osgi.native.osname", NativeLibraryClause.getOsNameWithAliases(osName));
        }
        if (osVersion != null) {
            attributes.put("osgi.native.osversion", new Version(NativeLibraryClause.normalizeOSVersion(osVersion)));
        }
        if (userLang != null) {
            attributes.put("osgi.native.language", userLang);
        }
        return new BundleCapabilityImpl(this.getRevision(), "osgi.native", Collections.<String, String>emptyMap(), attributes);
    }

    private static List<BundleCapability> aliasSymbolicName(List<BundleCapability> caps) {
        if (caps == null) {
            return new ArrayList<BundleCapability>(0);
        }
        ArrayList<BundleCapability> aliasCaps = new ArrayList<BundleCapability>(caps);
        String[] aliases = new String[]{"org.apache.felix.framework", "system.bundle"};
        block0: for (int capIdx = 0; capIdx < aliasCaps.size(); ++capIdx) {
            BundleCapability cap = (BundleCapability)aliasCaps.get(capIdx);
            if (cap.getNamespace().equals("osgi.wiring.bundle") || cap.getNamespace().equals("osgi.wiring.host")) {
                HashMap<String, Object> aliasAttrs = new HashMap<String, Object>(cap.getAttributes());
                aliasAttrs.put(cap.getNamespace(), aliases);
                cap = new BundleCapabilityImpl(cap.getRevision(), cap.getNamespace(), cap.getDirectives(), aliasAttrs);
                aliasCaps.set(capIdx, cap);
            }
            for (Map.Entry<String, Object> entry : cap.getAttributes().entrySet()) {
                if (!entry.getKey().equalsIgnoreCase("bundle-symbolic-name")) continue;
                HashMap<String, Object> aliasAttrs = new HashMap<String, Object>(cap.getAttributes());
                aliasAttrs.put("bundle-symbolic-name", aliases);
                aliasCaps.set(capIdx, new BundleCapabilityImpl(cap.getRevision(), cap.getNamespace(), cap.getDirectives(), aliasAttrs));
                continue block0;
            }
        }
        return aliasCaps;
    }

    public BundleRevisionImpl getRevision() {
        return this.m_systemBundleRevision;
    }

    public Object getSecurityContext() {
        return this.m_securityContext;
    }

    public synchronized void setSecurityContext(Object securityContext) {
        this.m_securityContext = securityContext;
    }

    synchronized void addExtensionBundle(Felix felix, BundleImpl bundle) throws SecurityException, BundleException, Exception {
        String directive;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, "extensionLifecycle"));
            if (!((BundleProtectionDomain)bundle.getProtectionDomain()).impliesDirect(new AllPermission())) {
                throw new SecurityException("Extension Bundles must have AllPermission");
            }
        }
        if (!"framework".equals(directive = ManifestParser.parseExtensionBundleHeader((String)((BundleRevisionImpl)bundle.adapt(BundleRevision.class)).getHeaders().get("Fragment-Host")))) {
            throw new BundleException("Unsupported Extension Bundle type: " + directive, new UnsupportedOperationException("Unsupported Extension Bundle type!"));
        }
        List<BundleCapability> exports = null;
        try {
            exports = ManifestParser.parseExportHeader(this.m_logger, this.m_systemBundleRevision, (String)bundle.adapt(BundleRevisionImpl.class).getHeaders().get("Export-Package"), this.m_systemBundleRevision.getSymbolicName(), this.m_systemBundleRevision.getVersion());
            exports = ExtensionManager.aliasSymbolicName(exports);
        }
        catch (Exception ex) {
            this.m_logger.log(bundle, 1, "Error parsing extension bundle export statement: " + bundle.adapt(BundleRevisionImpl.class).getHeaders().get("Export-Package"), (Throwable)ex);
            return;
        }
        if (m_extensionManager == null) {
            this.m_logger.log(bundle, 2, "Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
            throw new UnsupportedOperationException("Unable to add extension bundle to FrameworkClassLoader - Maybe not an URLClassLoader?");
        }
        m_extensionManager.addExtension(felix, bundle);
        this.appendCapabilities(exports);
        BundleRevisionImpl bri = bundle.adapt(BundleRevisionImpl.class);
        List<BundleRequirement> reqs = bri.getDeclaredRequirements("osgi.wiring.host");
        List<BundleCapability> caps = this.getCapabilities("osgi.wiring.host");
        BundleWireImpl bw = new BundleWireImpl(bri, reqs.get(0), this.m_systemBundleRevision, caps.get(0));
        bri.resolve(new BundleWiringImpl(this.m_logger, this.m_configMap, null, bri, null, Collections.singletonList(bw), Collections.EMPTY_MAP, Collections.EMPTY_MAP));
        felix.getDependencies().addDependent(bw);
        felix.setBundleStateAndNotify(bundle, 4);
    }

    void startExtensionBundle(Felix felix, BundleImpl bundle) {
        Map<String, Object> headers = bundle.adapt(BundleRevisionImpl.class).getHeaders();
        String activatorClass = (String)headers.get("ExtensionBundle-Activator");
        boolean felixExtension = false;
        if (activatorClass == null) {
            felixExtension = true;
            activatorClass = (String)headers.get("Felix-Activator");
        }
        if (activatorClass != null) {
            ExtensionTuple tuple = null;
            try {
                BundleActivator activator = (BundleActivator)felix.getClass().getClassLoader().loadClass(activatorClass.trim()).newInstance();
                BundleContext context = felix._getBundleContext();
                bundle.setBundleContext(context);
                if (!felixExtension) {
                    tuple = new ExtensionTuple(activator, bundle);
                    this.m_extensionTuples.add(tuple);
                } else {
                    felix.m_activatorList.add(activator);
                }
                if (felix.getState() == 32 || felix.getState() == 8) {
                    if (tuple != null) {
                        tuple.m_started = true;
                    }
                    Felix.m_secureAction.startActivator(activator, context);
                }
            }
            catch (Throwable ex) {
                if (tuple != null) {
                    tuple.m_failed = true;
                }
                felix.fireFrameworkEvent(2, bundle, new BundleException("Unable to start Bundle", ex));
                this.m_logger.log(bundle, 2, "Unable to start Extension Activator", ex);
            }
        }
    }

    void startPendingExtensionBundles(Felix felix) {
        for (int i = 0; i < this.m_extensionTuples.size(); ++i) {
            if (this.m_extensionTuples.get(i).m_started) continue;
            this.m_extensionTuples.get(i).m_started = true;
            try {
                Felix.m_secureAction.startActivator(this.m_extensionTuples.get(i).m_activator, felix._getBundleContext());
                continue;
            }
            catch (Throwable ex) {
                this.m_extensionTuples.get(i).m_failed = true;
                felix.fireFrameworkEvent(2, this.m_extensionTuples.get(i).m_bundle, new BundleException("Unable to start Bundle", 5, ex));
                this.m_logger.log(this.m_extensionTuples.get(i).m_bundle, 2, "Unable to start Extension Activator", ex);
            }
        }
    }

    void stopExtensionBundles(Felix felix) {
        for (int i = this.m_extensionTuples.size() - 1; i >= 0; --i) {
            if (!this.m_extensionTuples.get(i).m_started || this.m_extensionTuples.get(i).m_failed) continue;
            try {
                Felix.m_secureAction.stopActivator(this.m_extensionTuples.get(i).m_activator, felix._getBundleContext());
                continue;
            }
            catch (Throwable ex) {
                felix.fireFrameworkEvent(2, this.m_extensionTuples.get(i).m_bundle, new BundleException("Unable to stop Bundle", 5, ex));
                this.m_logger.log(this.m_extensionTuples.get(i).m_bundle, 2, "Unable to stop Extension Activator", ex);
            }
        }
        this.m_extensionTuples.clear();
    }

    void removeExtensions(Felix felix) {
        if (m_extensionManager != null) {
            m_extensionManager._removeExtensions(felix);
        }
    }

    private List<BundleCapability> getCapabilities(String namespace) {
        List<BundleCapability> caps;
        List<BundleCapability> result = caps = this.m_capabilities;
        if (namespace != null) {
            result = new ArrayList<BundleCapability>();
            for (BundleCapability cap : caps) {
                if (!cap.getNamespace().equals(namespace)) continue;
                result.add(cap);
            }
        }
        return result;
    }

    private synchronized void appendCapabilities(List<BundleCapability> caps) {
        ArrayList<BundleCapability> newCaps = new ArrayList<BundleCapability>(this.m_capabilities.size() + caps.size());
        newCaps.addAll(this.m_capabilities);
        newCaps.addAll(caps);
        this.m_capabilities = ImmutableList.newInstance(newCaps);
        this.m_headerMap.put("Export-Package", this.convertCapabilitiesToHeaders(this.m_headerMap));
    }

    private String convertCapabilitiesToHeaders(Map headers) {
        StringBuffer exportSB = new StringBuffer("");
        HashSet<String> exportNames = new HashSet<String>();
        List<BundleCapability> caps = this.m_capabilities;
        for (BundleCapability cap : caps) {
            if (!cap.getNamespace().equals("osgi.wiring.package")) continue;
            if (exportSB.length() > 0) {
                exportSB.append(", ");
            }
            exportSB.append(cap.getAttributes().get("osgi.wiring.package"));
            for (Map.Entry<String, String> entry : cap.getDirectives().entrySet()) {
                exportSB.append("; ");
                exportSB.append(entry.getKey());
                exportSB.append(":=\"");
                exportSB.append(entry.getValue());
                exportSB.append("\"");
            }
            for (Map.Entry<String, Object> entry : cap.getAttributes().entrySet()) {
                if (entry.getKey().equals("osgi.wiring.package") || entry.getKey().equals("bundle-symbolic-name") || entry.getKey().equals("bundle-version")) continue;
                exportSB.append("; ");
                exportSB.append(entry.getKey());
                exportSB.append("=\"");
                exportSB.append(entry.getValue());
                exportSB.append("\"");
            }
            exportNames.add((String)cap.getAttributes().get("osgi.wiring.package"));
        }
        this.m_exportNames = exportNames;
        return exportSB.toString();
    }

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        String path = url.getPath();
        if (path.trim().equals("/")) {
            return new URLHandlersBundleURLConnection(url);
        }
        Bundle[] extensions = this.m_extensionsCache;
        URL result = null;
        for (Bundle extBundle : extensions) {
            try {
                BundleRevisionImpl bri = (BundleRevisionImpl)extBundle.adapt(BundleRevision.class);
                if (bri != null) {
                    result = bri.getResourceLocal(path);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) continue;
            return result.openConnection();
        }
        return new URLConnection(url){

            @Override
            public void connect() throws IOException {
                throw new IOException("Resource not provided by any extension!");
            }
        };
    }

    @Override
    protected InetAddress getHostAddress(URL u) {
        return null;
    }

    private synchronized void addExtension(Object source, Bundle extension) {
        ArrayList<Bundle> sourceExtensions = (ArrayList<Bundle>)this.m_sourceToExtensions.get(source);
        if (sourceExtensions == null) {
            sourceExtensions = new ArrayList<Bundle>();
            this.m_sourceToExtensions.put(source, sourceExtensions);
        }
        sourceExtensions.add(extension);
        this._add(extension.getSymbolicName(), extension);
        this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
    }

    private synchronized void _removeExtensions(Object source) {
        if (this.m_sourceToExtensions.remove(source) == null) {
            return;
        }
        this.m_extensions.clear();
        this.m_names.clear();
        for (List extensions : this.m_sourceToExtensions.values()) {
            for (Bundle bundle : extensions) {
                this._add(bundle.getSymbolicName(), bundle);
            }
            this.m_extensionsCache = this.m_extensions.toArray(new Bundle[this.m_extensions.size()]);
        }
    }

    private void _add(String name, Bundle extension) {
        if (!this.m_names.contains(name)) {
            this.m_names.add(name);
            this.m_extensions.add(extension);
        }
    }

    @Override
    public void close() {
    }

    public Enumeration getEntries() {
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean hasEntry(String name) {
        return false;
    }

    @Override
    public byte[] getEntryAsBytes(String name) {
        return null;
    }

    @Override
    public InputStream getEntryAsStream(String name) throws IOException {
        return null;
    }

    @Override
    public Content getEntryAsContent(String name) {
        return null;
    }

    @Override
    public String getEntryAsNativeLibrary(String name) {
        return null;
    }

    @Override
    public URL getEntryAsURL(String name) {
        return null;
    }

    static {
        ExtensionManager extensionManager = null;
        if (!"true".equalsIgnoreCase(Felix.m_secureAction.getSystemProperty("felix.extensions.disable", "false"))) {
            try {
                new URL("http://felix.extensions:9/").openConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                extensionManager = new ExtensionManager();
                Felix.m_secureAction.addURLToURLClassLoader(Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "http:", extensionManager), "http://felix.extensions:9/", extensionManager), Felix.class.getClassLoader());
            }
            catch (Throwable ex) {
                extensionManager = null;
            }
        }
        m_extensionManager = extensionManager;
    }

    class ExtensionManagerWiring
    extends BundleWiringImpl {
        ExtensionManagerWiring(Logger logger, Map configMap, BundleRevisionImpl revision) throws Exception {
            super(logger, configMap, null, revision, null, Collections.EMPTY_LIST, null, null);
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.getClass().getClassLoader();
        }

        @Override
        public List<BundleCapability> getCapabilities(String namespace) {
            return ExtensionManager.this.getCapabilities(namespace);
        }

        @Override
        public List<NativeLibrary> getNativeLibraries() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public Class getClassByDelegation(String name) throws ClassNotFoundException {
            Class<?> clazz;
            block6: {
                clazz = null;
                String pkgName = Util.getClassPackage(name);
                if (this.shouldBootDelegate(pkgName)) {
                    try {
                        ClassLoader bdcl = this.getBootDelegationClassLoader();
                        clazz = bdcl.loadClass(name);
                        if (pkgName.startsWith("java.") || clazz != null) {
                            return clazz;
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        if (!pkgName.startsWith("java.")) break block6;
                        throw ex;
                    }
                }
            }
            if (clazz == null) {
                if (!ExtensionManager.this.m_exportNames.contains(Util.getClassPackage(name))) {
                    throw new ClassNotFoundException(name);
                }
                clazz = this.getClass().getClassLoader().loadClass(name);
            }
            return clazz;
        }

        @Override
        public URL getResourceByDelegation(String name) {
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        public Enumeration getResourcesByDelegation(String name) {
            try {
                return this.getClass().getClassLoader().getResources(name);
            }
            catch (IOException ex) {
                return null;
            }
        }

        @Override
        public void dispose() {
        }
    }

    class ExtensionManagerRevision
    extends BundleRevisionImpl {
        private final Version m_version;
        private volatile BundleWiring m_wiring;

        ExtensionManagerRevision(Felix felix) {
            super(felix, "0");
            this.m_version = new Version((String)ExtensionManager.this.m_configMap.get("felix.version"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getHeaders() {
            ExtensionManager extensionManager = ExtensionManager.this;
            synchronized (extensionManager) {
                return ExtensionManager.this.m_headerMap;
            }
        }

        @Override
        public List<BundleCapability> getDeclaredCapabilities(String namespace) {
            return ExtensionManager.this.getCapabilities(namespace);
        }

        @Override
        public String getSymbolicName() {
            return "org.apache.felix.framework";
        }

        @Override
        public Version getVersion() {
            return this.m_version;
        }

        @Override
        public void close() {
        }

        @Override
        public Content getContent() {
            return ExtensionManager.this;
        }

        @Override
        public URL getEntry(String name) {
            return null;
        }

        @Override
        public boolean hasInputStream(int index, String urlPath) {
            return this.getClass().getClassLoader().getResource(urlPath) != null;
        }

        @Override
        public InputStream getInputStream(int index, String urlPath) {
            return this.getClass().getClassLoader().getResourceAsStream(urlPath);
        }

        @Override
        public URL getLocalURL(int index, String urlPath) {
            return this.getClass().getClassLoader().getResource(urlPath);
        }

        @Override
        public void resolve(BundleWiringImpl wire) {
            try {
                this.m_wiring = new ExtensionManagerWiring(ExtensionManager.this.m_logger, ExtensionManager.this.m_configMap, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public BundleWiring getWiring() {
            return this.m_wiring;
        }
    }

    private static class ExtensionTuple {
        private final BundleActivator m_activator;
        private final Bundle m_bundle;
        private volatile boolean m_failed;
        private volatile boolean m_started;

        public ExtensionTuple(BundleActivator activator, Bundle bundle) {
            this.m_activator = activator;
            this.m_bundle = bundle;
        }
    }
}

