/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.geometry.Vector;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000b\u001a&\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003\u001a6\u0010\u0014\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003\u001a\u0016\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\u001a\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003\u001a\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003\u001a.\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\u001a\u0012\u0010#\u001a\u00020\u0003*\u00020$2\u0006\u0010%\u001a\u00020$\u00a8\u0006&"}, d2={"areEqual", "", "a", "", "b", "epsilon", "ceil", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "x", "y", "v", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "distance", "vector", "doubleVector", "pointSqrDistance", "x1", "y1", "x2", "y2", "pointToLineSqrDistance", "l1x", "l1y", "l2x", "l2y", "round", "toDegrees", "radians", "toRadians", "degrees", "yOnLine", "p1x", "p1y", "p2x", "p2y", "ipow", "", "e", "commons"})
public final class MathKt {
    public static final double toRadians(double degrees) {
        return degrees * Math.PI / 180.0;
    }

    public static final double toDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    @NotNull
    public static final Vector round(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return MathKt.round(v.getX(), v.getY());
    }

    @NotNull
    public static final Vector ceil(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return MathKt.ceil(v.getX(), v.getY());
    }

    @NotNull
    public static final Vector round(double x2, double y2) {
        return new Vector((int)Math.rint(x2), (int)Math.rint(y2));
    }

    @NotNull
    public static final Vector ceil(double x2, double y2) {
        return new Vector((int)Math.ceil(x2), (int)Math.ceil(y2));
    }

    public static final double distance(@NotNull Vector vector, @NotNull DoubleVector doubleVector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)doubleVector, (String)"doubleVector");
        double dx = doubleVector.getX() - (double)vector.getX();
        double dy = doubleVector.getY() - (double)vector.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static final double ipow(int $this$ipow, int e) {
        return Math.pow($this$ipow, e);
    }

    public static final boolean areEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    public static /* synthetic */ boolean areEqual$default(double d, double d2, double d3, int n, Object object) {
        if ((n & 4) != 0) {
            d3 = 1.0E-5;
        }
        return MathKt.areEqual(d, d2, d3);
    }

    public static final double pointToLineSqrDistance(double x2, double y2, double l1x, double l1y, double l2x, double l2y) {
        double d;
        if (l1x == l2x && l1y == l2y) {
            d = MathKt.pointSqrDistance(x2, y2, l1x, l1y);
        } else {
            double ortX = l2x - l1x;
            double ortY = -(l2y - l1y);
            double dot = (x2 - l1x) * ortY + (y2 - l1y) * ortX;
            double len = ortY * ortY + ortX * ortX;
            d = dot * dot / len;
        }
        return d;
    }

    public static final double pointSqrDistance(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    public static final double yOnLine(double p1x, double p1y, double p2x, double p2y, double x2) {
        double m = (p2y - p1y) / (p2x - p1x);
        double b = p2y - m * p2x;
        return m * x2 + b;
    }
}

