/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.types;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public class Interval {
    private final long period;
    private final ChronoUnit unit;

    public static Interval of(Period period) {
        return new Interval(period.getDays(), ChronoUnit.DAYS);
    }

    public static Interval of(Duration duration) {
        return new Interval(duration.getSeconds(), ChronoUnit.SECONDS);
    }

    public static Interval of(long period, ChronoUnit unit) {
        return new Interval(period, unit);
    }

    private Interval(long period, ChronoUnit unit) {
        this.period = Math.abs(period);
        this.unit = unit;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    public boolean longerThan(Interval other) {
        if (this.unit == other.unit) {
            return this.period > other.period;
        }
        throw new UnsupportedOperationException("Units are different. " + this.unit + " vs " + other.unit);
    }

    public String describe(Locale locale) {
        return this.period + " " + this.unit.toString();
    }
}

