/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.presentation.LabelSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotAxisLayoutUtil;", "", "()V", "INITIAL_TICK_LABEL_IN_CHARS", "", "initialThickness", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "initialTickLabelSize", "tickLabelSpec", "Lorg/jetbrains/letsPlot/core/plot/builder/presentation/LabelSpec;", "plot-builder"})
public final class PlotAxisLayoutUtil {
    @NotNull
    public static final PlotAxisLayoutUtil INSTANCE = new PlotAxisLayoutUtil();
    @NotNull
    private static final String INITIAL_TICK_LABEL_IN_CHARS = "_";

    private PlotAxisLayoutUtil() {
    }

    public final double initialThickness(@NotNull Orientation orientation, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (theme.showTickMarks() || theme.showLabels()) {
            double v = theme.tickLabelDistance(orientation.isHorizontal());
            return theme.showLabels() ? v + this.initialTickLabelSize(orientation, PlotLabelSpecFactory.INSTANCE.axisTick(theme)) : v;
        }
        return 0.0;
    }

    private final double initialTickLabelSize(Orientation orientation, LabelSpec tickLabelSpec) {
        return orientation.isHorizontal() ? tickLabelSpec.height() : tickLabelSpec.width(INITIAL_TICK_LABEL_IN_CHARS);
    }
}

