/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.Transform;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleUtil;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.assemble.StitchedPlotLayer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B1\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0017\u001a\u00020\b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J>\u0010\u0019\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u00122\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00072\u001a\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0014\u0010\u001e\u001a\u00020\u00162\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0010\u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext;", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "layersByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "scaleMap", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "(Ljava/util/List;Ljava/util/Map;)V", "layers", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext$Layer;", "getLayers", "()Ljava/util/List;", "stitchedPlotLayers", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer;", "tooltipFormatters", "", "Lkotlin/Function1;", "", "", "transformedDomainByAes", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "getScale", "aes", "getTooltipFormatter", "defaultValue", "Lkotlin/Function0;", "hasScale", "", "overallTransformedDomain", "Companion", "ContextPlotLayer", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotAssemblerPlotContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotAssemblerPlotContext.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,178:1\n1549#2:179\n1620#2,3:180\n372#3,7:183\n372#3,7:190\n*S KotlinDebug\n*F\n+ 1 PlotAssemblerPlotContext.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext\n*L\n31#1:179\n31#1:180,3\n42#1:183,7\n52#1:190,7\n*E\n"})
public final class PlotAssemblerPlotContext
implements PlotContext {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Aes<?>, Scale> scaleMap;
    @NotNull
    private final List<StitchedPlotLayer> stitchedPlotLayers;
    @NotNull
    private final Map<Aes<?>, DoubleSpan> transformedDomainByAes;
    @NotNull
    private final Map<Aes<?>, Function1<Object, String>> tooltipFormatters;
    @NotNull
    private final List<PlotContext.Layer> layers;

    /*
     * WARNING - void declaration
     */
    public PlotAssemblerPlotContext(@NotNull List<? extends List<? extends GeomLayer>> layersByTile, @NotNull Map<Aes<?>, ? extends Scale> scaleMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(layersByTile, (String)"layersByTile");
        Intrinsics.checkNotNullParameter(scaleMap, (String)"scaleMap");
        this.scaleMap = scaleMap;
        this.stitchedPlotLayers = Companion.createStitchedLayers(layersByTile);
        this.transformedDomainByAes = new HashMap();
        this.tooltipFormatters = new HashMap();
        Iterable iterable = this.stitchedPlotLayers;
        PlotAssemblerPlotContext plotAssemblerPlotContext = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            StitchedPlotLayer stitchedPlotLayer = (StitchedPlotLayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ContextPlotLayer((StitchedPlotLayer)p0));
        }
        plotAssemblerPlotContext.layers = (List)destination$iv$iv;
    }

    @NotNull
    public List<PlotContext.Layer> getLayers() {
        return this.layers;
    }

    public boolean hasScale(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return this.scaleMap.containsKey(aes);
    }

    @NotNull
    public Scale getScale(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Companion.checkPositionalAes(aes);
        return (Scale)MapsKt.getValue(this.scaleMap, aes);
    }

    @NotNull
    public DoubleSpan overallTransformedDomain(@NotNull Aes<?> aes) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Companion.checkPositionalAes(aes);
        Map<Aes<?>, DoubleSpan> $this$getOrPut$iv = this.transformedDomainByAes;
        boolean $i$f$getOrPut = false;
        DoubleSpan value$iv = $this$getOrPut$iv.get(aes);
        if (value$iv == null) {
            boolean bl = false;
            DoubleSpan answer$iv = Companion.computeOverallTransformedDomain(aes, this.stitchedPlotLayers, this.scaleMap);
            $this$getOrPut$iv.put(aes, answer$iv);
            doubleSpan = answer$iv;
        } else {
            doubleSpan = value$iv;
        }
        return doubleSpan;
    }

    @NotNull
    public Function1<Object, String> getTooltipFormatter(@NotNull Aes<?> aes, @NotNull Function0<? extends Function1<Object, String>> defaultValue) {
        Object object;
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        Companion.checkPositionalAes(aes);
        Map<Aes<?>, Function1<Object, String>> $this$getOrPut$iv = this.tooltipFormatters;
        boolean $i$f$getOrPut = false;
        Function1<Object, String> value$iv = $this$getOrPut$iv.get(aes);
        if (value$iv == null) {
            Object answer$iv = defaultValue.invoke();
            $this$getOrPut$iv.put(aes, (Function1<Object, String>)answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006J8\u0010\u0007\u001a\u00020\b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u000e0\rJ \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\n0\nJ\u001a\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext$Companion;", "", "()V", "checkPositionalAes", "", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "computeOverallTransformedDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "stitchedLayers", "", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer;", "scaleMap", "", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "createStitchedLayers", "layersByPanel", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "finalizeOverallTransformedDomain", "transformedDomain", "transform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nPlotAssemblerPlotContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotAssemblerPlotContext.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n766#2:179\n857#2,2:180\n766#2:182\n857#2,2:183\n2730#2,7:185\n*S KotlinDebug\n*F\n+ 1 PlotAssemblerPlotContext.kt\norg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext$Companion\n*L\n105#1:179\n105#1:180,2\n106#1:182\n106#1:183,2\n116#1:185,7\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<StitchedPlotLayer> createStitchedLayers(@NotNull List<? extends List<? extends GeomLayer>> layersByPanel) {
            Intrinsics.checkNotNullParameter(layersByPanel, (String)"layersByPanel");
            if (layersByPanel.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            int layerCount = layersByPanel.get(0).size();
            ArrayList<StitchedPlotLayer> stitchedLayers = new ArrayList<StitchedPlotLayer>();
            for (int i = 0; i < layerCount; ++i) {
                ArrayList<GeomLayer> layersOnPlane = new ArrayList<GeomLayer>();
                for (List<? extends GeomLayer> list : layersByPanel) {
                    layersOnPlane.add(list.get(i));
                }
                stitchedLayers.add(new StitchedPlotLayer((List<? extends GeomLayer>)layersOnPlane));
            }
            return stitchedLayers;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DoubleSpan computeOverallTransformedDomain(@NotNull Aes<?> aes, @NotNull List<StitchedPlotLayer> stitchedLayers, @NotNull Map<Aes<?>, ? extends Scale> scaleMap) {
            DoubleSpan doubleSpan;
            Object v0;
            DoubleSpan domain;
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            Intrinsics.checkNotNullParameter(stitchedLayers, (String)"stitchedLayers");
            Intrinsics.checkNotNullParameter(scaleMap, (String)"scaleMap");
            this.checkPositionalAes(aes);
            ArrayList<DoubleSpan> domainsRaw = new ArrayList<DoubleSpan>();
            for (StitchedPlotLayer layer : stitchedLayers) {
                DataFrame.Variable it;
                Iterable $this$filterTo$iv$iv;
                Object $this$filter$iv;
                Iterable iterable = layer.getVariables$plot_builder();
                boolean $i$f$filter = false;
                void var10_13 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (DataFrame.Variable)element$iv$iv;
                    boolean bl = false;
                    if (!it.isTransform()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (DataFrame.Variable)element$iv$iv;
                    boolean bl = false;
                    if (!org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssemblerPlotContext$Companion.computeOverallTransformedDomain$isMatching(it, aes, layer.isYOrientation())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List variables = (List)destination$iv$iv;
                $this$filter$iv = variables.iterator();
                while ($this$filter$iv.hasNext()) {
                    DataFrame.Variable transformVar = (DataFrame.Variable)$this$filter$iv.next();
                    domain = layer.getDataRange(transformVar);
                    if (domain == null) continue;
                    domainsRaw.add(domain);
                }
            }
            Iterable $this$reduceOrNull$iv = domainsRaw;
            boolean $i$f$reduceOrNull = false;
            Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void v;
                    domain = (DoubleSpan)iterator$iv.next();
                    DoubleSpan acc = (DoubleSpan)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc.union((DoubleSpan)v);
                }
                v0 = accumulator$iv;
            }
            DoubleSpan overallTransformedDomain = v0;
            Scale scale = (Scale)MapsKt.getValue(scaleMap, aes);
            if (scale.isContinuousDomain()) {
                Transform transform = scale.getTransform();
                Intrinsics.checkNotNull((Object)transform, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.ContinuousTransform");
                doubleSpan = this.finalizeOverallTransformedDomain(overallTransformedDomain, (ContinuousTransform)transform);
            } else {
                doubleSpan = overallTransformedDomain;
                if (doubleSpan == null) {
                    doubleSpan = DoubleSpan.Companion.singleton(0.0);
                }
            }
            return doubleSpan;
        }

        private final DoubleSpan finalizeOverallTransformedDomain(DoubleSpan transformedDomain, ContinuousTransform transform) {
            Pair pair = transformedDomain == null ? new Pair((Object)Double.NaN, (Object)Double.NaN) : new Pair((Object)transformedDomain.getLowerEnd(), (Object)transformedDomain.getUpperEnd());
            double dataLower = ((Number)pair.component1()).doubleValue();
            double dataUpper = ((Number)pair.component2()).doubleValue();
            Pair pair2 = ScaleUtil.INSTANCE.transformedDefinedLimits(transform);
            double scaleLower = ((Number)pair2.component1()).doubleValue();
            double scaleUpper = ((Number)pair2.component2()).doubleValue();
            double d = scaleLower;
            double lowerEnd = !Double.isInfinite(d) && !Double.isNaN(d) ? scaleLower : dataLower;
            double d2 = scaleUpper;
            double upperEnd = !Double.isInfinite(d2) && !Double.isNaN(d2) ? scaleUpper : dataUpper;
            double d3 = lowerEnd;
            DoubleSpan newRange = !Double.isInfinite(d3) && !Double.isNaN(d3) && !Double.isInfinite(d3 = upperEnd) && !Double.isNaN(d3) ? new DoubleSpan(lowerEnd, upperEnd) : (!Double.isInfinite(d3 = lowerEnd) && !Double.isNaN(d3) ? new DoubleSpan(lowerEnd, lowerEnd) : (!Double.isInfinite(d3 = upperEnd) && !Double.isNaN(d3) ? new DoubleSpan(upperEnd, upperEnd) : null));
            return SeriesUtil.ensureApplicableRange$default((SeriesUtil)SeriesUtil.INSTANCE, (DoubleSpan)newRange, null, (int)2, null);
        }

        public final void checkPositionalAes(@NotNull Aes<?> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            if (!(!Aes.Companion.isPositionalXY(aes) || Intrinsics.areEqual(aes, (Object)Aes.Companion.getX()) || Intrinsics.areEqual(aes, (Object)Aes.Companion.getY()))) {
                boolean bl = false;
                String string = "Positional aesthetic should be either X or Y but was " + aes;
                throw new IllegalStateException(string.toString());
            }
        }

        private static final boolean computeOverallTransformedDomain$isMatching(DataFrame.Variable v, Aes<?> aes, boolean isYOrientation) {
            Aes varAes = TransformVar.INSTANCE.toAes(v);
            return Aes.Companion.isPositionalXY(varAes) ? Intrinsics.areEqual((Object)Aes.Companion.toAxisAes(varAes, isYOrientation), aes) : Intrinsics.areEqual((Object)varAes, aes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\nH\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u00112\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0014\u0010\u001c\u001a\u00020\u00112\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0012\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u001eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssemblerPlotContext$ContextPlotLayer;", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext$Layer;", "stitchedPlotLayer", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer;", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/StitchedPlotLayer;)V", "aestheticsDefaults", "Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "getAestheticsDefaults", "()Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "colorByAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getColorByAes", "()Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "fillByAes", "getFillByAes", "isLegendDisabled", "", "()Z", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getConstant", "T", "aes", "(Lorg/jetbrains/letsPlot/core/plot/base/Aes;)Ljava/lang/Object;", "hasBinding", "hasConstant", "renderedAes", "", "plot-builder"})
    private static final class ContextPlotLayer
    implements PlotContext.Layer {
        @NotNull
        private final StitchedPlotLayer stitchedPlotLayer;

        public ContextPlotLayer(@NotNull StitchedPlotLayer stitchedPlotLayer) {
            Intrinsics.checkNotNullParameter((Object)stitchedPlotLayer, (String)"stitchedPlotLayer");
            this.stitchedPlotLayer = stitchedPlotLayer;
        }

        public boolean isLegendDisabled() {
            return this.stitchedPlotLayer.isLegendDisabled();
        }

        @NotNull
        public AestheticsDefaults getAestheticsDefaults() {
            return this.stitchedPlotLayer.getAestheticsDefaults();
        }

        @NotNull
        public LegendKeyElementFactory getLegendKeyElementFactory() {
            return this.stitchedPlotLayer.getLegendKeyElementFactory();
        }

        @NotNull
        public Aes<Color> getColorByAes() {
            return this.stitchedPlotLayer.getColorByAes();
        }

        @NotNull
        public Aes<Color> getFillByAes() {
            return this.stitchedPlotLayer.getFillByAes();
        }

        @NotNull
        public List<Aes<?>> renderedAes() {
            return this.stitchedPlotLayer.renderedAes();
        }

        public boolean hasBinding(@NotNull Aes<?> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            return this.stitchedPlotLayer.hasBinding(aes);
        }

        public boolean hasConstant(@NotNull Aes<?> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            return this.stitchedPlotLayer.hasConstant(aes);
        }

        public <T> T getConstant(@NotNull Aes<T> aes) {
            Intrinsics.checkNotNullParameter(aes, (String)"aes");
            return this.stitchedPlotLayer.getConstant(aes);
        }
    }
}

