/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.codec.IByteArrayCodec;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonClosingOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public class GZIPCodec
implements IByteArrayCodec {
    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (GZIPInputStream gZIPInputStream = new GZIPInputStream(new NonBlockingByteArrayInputStream(byArray, n, n2));){
            if (StreamHelper.copyInputStreamToOutputStream(gZIPInputStream, outputStream).isFailure()) {
                throw new DecodeException("Failed to GZIP decode!");
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to GZIP encode", iOException);
        }
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(new NonClosingOutputStream(outputStream));){
            if (StreamHelper.copyInputStreamToOutputStream(new NonBlockingByteArrayInputStream(byArray, n, n2), gZIPOutputStream).isFailure()) {
                throw new EncodeException("Failed to GZIP encode!");
            }
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to GZIP encode", iOException);
        }
    }
}

