/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public class SingletonIterator<E>
implements Iterator<E> {
    private E value;

    public static <E> Iterator<E> newInstance(E e) {
        return new SingletonIterator<E>(e);
    }

    private SingletonIterator(E value) {
        this.value = value;
    }

    @Override
    public boolean hasNext() {
        return this.value != null;
    }

    @Override
    public E next() {
        if (this.value != null) {
            E result = this.value;
            this.value = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.value = null;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
    }
}

