/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.jmap.api.change.JmapChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.mailbox.model.MessageId;

public class EmailChange
implements JmapChange {
    private final AccountId accountId;
    private final State state;
    private final ZonedDateTime date;
    private final boolean isDelegated;
    private final ImmutableList<MessageId> created;
    private final ImmutableList<MessageId> updated;
    private final ImmutableList<MessageId> destroyed;
    private final boolean isDelivery;

    public static Builder.RequireAccountId builder() {
        return accountId -> state -> date -> isDelegated -> new Builder(accountId, state, date, isDelegated);
    }

    private EmailChange(AccountId accountId, State state, ZonedDateTime date, boolean isDelegated, ImmutableList<MessageId> created, ImmutableList<MessageId> updated, ImmutableList<MessageId> destroyed, boolean isDelivery) {
        this.accountId = accountId;
        this.state = state;
        this.date = date;
        this.isDelegated = isDelegated;
        this.created = created;
        this.updated = updated;
        this.destroyed = destroyed;
        this.isDelivery = isDelivery;
    }

    @Override
    public AccountId getAccountId() {
        return this.accountId;
    }

    public State getState() {
        return this.state;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    public List<MessageId> getCreated() {
        return this.created;
    }

    public List<MessageId> getUpdated() {
        return this.updated;
    }

    public List<MessageId> getDestroyed() {
        return this.destroyed;
    }

    public boolean isDelegated() {
        return this.isDelegated;
    }

    public boolean isDelivery() {
        return this.isDelivery;
    }

    public final boolean equals(Object o) {
        if (o instanceof EmailChange) {
            EmailChange that = (EmailChange)o;
            return Objects.equals(this.accountId, that.accountId) && Objects.equals(this.state, that.state) && Objects.equals(this.date, that.date) && Objects.equals(this.isDelegated, that.isDelegated) && Objects.equals(this.created, that.created) && Objects.equals(this.updated, that.updated) && Objects.equals(this.destroyed, that.destroyed) && Objects.equals(this.isDelivery, that.isDelivery);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.accountId, this.state, this.date, this.isDelegated, this.created, this.updated, this.destroyed, this.isDelivery);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountId", (Object)this.accountId).add("state", (Object)this.state).add("date", (Object)this.date).add("isDelegated", this.isDelegated).add("created", this.created).add("updated", this.updated).add("destroyed", this.destroyed).add("isDelivery", this.isDelivery).toString();
    }

    public static class Builder {
        private final AccountId accountId;
        private final State state;
        private final ZonedDateTime date;
        private final boolean isDelegated;
        private final ImmutableList.Builder<MessageId> created;
        private final ImmutableList.Builder<MessageId> updated;
        private final ImmutableList.Builder<MessageId> destroyed;
        private Optional<Boolean> isDelivery;

        private Builder(AccountId accountId, State state, ZonedDateTime date, boolean isDelegated) {
            Preconditions.checkNotNull((Object)accountId, (Object)"'accountId' should not be null");
            Preconditions.checkNotNull((Object)state, (Object)"'state' should not be null");
            Preconditions.checkNotNull((Object)date, (Object)"'date' should not be null");
            this.accountId = accountId;
            this.state = state;
            this.date = date;
            this.isDelegated = isDelegated;
            this.destroyed = ImmutableList.builder();
            this.updated = ImmutableList.builder();
            this.created = ImmutableList.builder();
            this.isDelivery = Optional.empty();
        }

        public Builder updated(MessageId ... messageId) {
            this.updated.add((Object[])messageId);
            return this;
        }

        public Builder destroyed(MessageId ... messageId) {
            this.destroyed.add((Object[])messageId);
            return this;
        }

        public Builder created(MessageId ... messageId) {
            this.created.add((Object[])messageId);
            return this;
        }

        public Builder created(Collection<MessageId> messageIds) {
            this.created.addAll(messageIds);
            return this;
        }

        public Builder destroyed(Collection<MessageId> messageIds) {
            this.destroyed.addAll(messageIds);
            return this;
        }

        public Builder updated(Collection<MessageId> messageIds) {
            this.updated.addAll(messageIds);
            return this;
        }

        public Builder isDelivery(boolean isDelivery) {
            this.isDelivery = Optional.of(isDelivery);
            return this;
        }

        public EmailChange build() {
            return new EmailChange(this.accountId, this.state, this.date, this.isDelegated, (ImmutableList<MessageId>)this.created.build(), (ImmutableList<MessageId>)this.updated.build(), (ImmutableList<MessageId>)this.destroyed.build(), this.isDelivery.orElse(false));
        }

        @FunctionalInterface
        public static interface RequireIsDelegated {
            public Builder isDelegated(boolean var1);
        }

        @FunctionalInterface
        public static interface RequireDate {
            public RequireIsDelegated date(ZonedDateTime var1);
        }

        @FunctionalInterface
        public static interface RequireState {
            public RequireDate state(State var1);
        }

        @FunctionalInterface
        public static interface RequireAccountId {
            public RequireState accountId(AccountId var1);
        }
    }
}

