/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import javax.inject.Inject;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.task.TaskManager;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.service.EventDeadLettersRedeliverService;
import org.apache.james.webadmin.service.EventDeadLettersService;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.ParametersExtractor;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class EventDeadLettersRoutes
implements Routes {
    public static final String BASE_PATH = "/events/deadLetter";
    private static final String GROUP_PARAM = ":group";
    private static final String INSERTION_ID_PARAMETER = ":insertionId";
    private static final TaskRegistrationKey RE_DELIVER = TaskRegistrationKey.of((String)"reDeliver");
    private final EventDeadLettersService eventDeadLettersService;
    private final EventSerializer eventSerializer;
    private final TaskManager taskManager;
    private final JsonTransformer jsonTransformer;

    @Inject
    EventDeadLettersRoutes(EventDeadLettersService eventDeadLettersService, EventSerializer eventSerializer, TaskManager taskManager, JsonTransformer jsonTransformer) {
        this.eventDeadLettersService = eventDeadLettersService;
        this.eventSerializer = eventSerializer;
        this.taskManager = taskManager;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return BASE_PATH;
    }

    public void define(Service service) {
        service.post(BASE_PATH, this.performActionOnAllEvents(), (ResponseTransformer)this.jsonTransformer);
        service.get("/events/deadLetter/groups", this::listGroups, (ResponseTransformer)this.jsonTransformer);
        service.get("/events/deadLetter/groups/:group", this::listFailedEvents, (ResponseTransformer)this.jsonTransformer);
        service.post("/events/deadLetter/groups/:group", this.performActionOnGroupEvents(), (ResponseTransformer)this.jsonTransformer);
        service.get("/events/deadLetter/groups/:group/:insertionId", this::getEventDetails);
        service.delete("/events/deadLetter/groups/:group/:insertionId", this::deleteEvent);
        service.delete("/events/deadLetter/groups/:group", this::deleteEventsOfAGroup);
        service.post("/events/deadLetter/groups/:group/:insertionId", this.performActionOnSingleEvent(), (ResponseTransformer)this.jsonTransformer);
    }

    public Route performActionOnAllEvents() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)RE_DELIVER, request -> this.eventDeadLettersService.redeliverAllEvents(this.parseRunningOptions(request))).asRoute(this.taskManager);
    }

    private Iterable<String> listGroups(Request request, Response response) {
        return this.eventDeadLettersService.listGroupsAsStrings();
    }

    private Iterable<String> listFailedEvents(Request request, Response response) {
        Group group = this.parseGroup(request);
        return this.eventDeadLettersService.listGroupsInsertionIdsAsStrings(group);
    }

    public Route performActionOnGroupEvents() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)RE_DELIVER, request -> this.eventDeadLettersService.redeliverGroupEvents(this.parseGroup(request), this.parseRunningOptions(request))).asRoute(this.taskManager);
    }

    private String getEventDetails(Request request, Response response) {
        Group group = this.parseGroup(request);
        EventDeadLetters.InsertionId insertionId = this.parseInsertionId(request);
        return (String)this.eventDeadLettersService.getEvent(group, insertionId).map(arg_0 -> ((EventSerializer)this.eventSerializer).toJson(arg_0)).block();
    }

    private String deleteEvent(Request request, Response response) {
        Group group = this.parseGroup(request);
        EventDeadLetters.InsertionId insertionId = this.parseInsertionId(request);
        this.eventDeadLettersService.deleteEvent(group, insertionId);
        return Responses.returnNoContent((Response)response);
    }

    private String deleteEventsOfAGroup(Request request, Response response) {
        Group group = this.parseGroup(request);
        this.eventDeadLettersService.deleteEvents(group);
        return Responses.returnNoContent((Response)response);
    }

    public Route performActionOnSingleEvent() {
        return TaskFromRequestRegistry.of((TaskRegistrationKey)RE_DELIVER, request -> this.eventDeadLettersService.redeliverSingleEvent(this.parseGroup(request), this.parseInsertionId(request))).asRoute(this.taskManager);
    }

    private Group parseGroup(Request request) {
        String groupAsString = request.params(GROUP_PARAM);
        try {
            return Group.deserialize((String)groupAsString);
        }
        catch (Group.GroupDeserializationException e) {
            throw ErrorResponder.builder().statusCode(400).message("Can not deserialize the supplied group: %s", new Object[]{groupAsString}).cause((Exception)((Object)e)).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError();
        }
    }

    private EventDeadLetters.InsertionId parseInsertionId(Request request) {
        String insertionIdAsString = request.params(INSERTION_ID_PARAMETER);
        try {
            return EventDeadLetters.InsertionId.of((String)insertionIdAsString);
        }
        catch (Exception e) {
            throw ErrorResponder.builder().statusCode(400).message("Can not deserialize the supplied insertionId: %s", new Object[]{insertionIdAsString}).cause(e).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).haltError();
        }
    }

    private EventDeadLettersRedeliverService.RunningOptions parseRunningOptions(Request request) {
        return ParametersExtractor.extractPositiveInteger((Request)request, (String)"limit").map(limit -> new EventDeadLettersRedeliverService.RunningOptions(Limit.from((int)limit))).orElse(EventDeadLettersRedeliverService.RunningOptions.DEFAULT);
    }
}

