/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.send;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.jmap.draft.send.MailMetadata;
import org.apache.james.jmap.draft.send.exception.MailShouldBeInOutboxException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SystemMailboxesProvider;
import org.apache.james.mailbox.exception.MailboxRoleNotFoundException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostDequeueDecorator
extends MailQueueItemDecoratorFactory.MailQueueItemDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(PostDequeueDecorator.class);
    private static final Attribute IS_DELIVERED = Attribute.convertToAttribute((String)"DELIVERED", (Object)"DELIVERED");
    private final MailboxManager mailboxManager;
    private final MessageId.Factory messageIdFactory;
    private final MessageIdManager messageIdManager;
    private final SystemMailboxesProvider systemMailboxesProvider;

    public PostDequeueDecorator(MailQueue.MailQueueItem mailQueueItem, MailboxManager mailboxManager, MessageId.Factory messageIdFactory, MessageIdManager messageIdManager, SystemMailboxesProvider systemMailboxesProvider) {
        super(mailQueueItem);
        this.mailboxManager = mailboxManager;
        this.messageIdFactory = messageIdFactory;
        this.messageIdManager = messageIdManager;
        this.systemMailboxesProvider = systemMailboxesProvider;
    }

    public Mail getMail() {
        return this.mailQueueItem.getMail();
    }

    public void done(MailQueue.MailQueueItem.CompletionStatus success) throws MailQueue.MailQueueException {
        this.mailQueueItem.done(success);
        if (success == MailQueue.MailQueueItem.CompletionStatus.SUCCESS && this.mandatoryJmapMetaDataIsPresent()) {
            Optional<?> optionalRawMessageId = this.retrieveMessageId();
            MessageId messageId = this.messageIdFactory.fromString((String)optionalRawMessageId.get());
            Optional<String> username = this.retrieveUsername();
            if (!this.getMail().getAttribute(IS_DELIVERED.getName()).isPresent()) {
                try {
                    MailboxSession mailboxSession = this.mailboxManager.createSystemSession(Username.of((String)username.get()));
                    this.moveFromOutboxToSentWithSeenFlag(messageId, mailboxSession);
                    this.getMail().setAttribute(IS_DELIVERED);
                    this.mailboxManager.endProcessingRequest(mailboxSession);
                }
                catch (MailShouldBeInOutboxException e) {
                    LOG.info("Message does not exist on Outbox anymore, it could have already been sent", (Throwable)e);
                }
            }
        }
    }

    private Optional<?> retrieveMessageId() {
        return AttributeUtils.getAttributeValueFromMail((Mail)this.getMail(), (AttributeName)MailMetadata.MAIL_METADATA_MESSAGE_ID_ATTRIBUTE);
    }

    private Optional<String> retrieveUsername() {
        return AttributeUtils.getValueAndCastFromMail((Mail)this.getMail(), (AttributeName)MailMetadata.MAIL_METADATA_USERNAME_ATTRIBUTE, String.class);
    }

    private boolean mandatoryJmapMetaDataIsPresent() {
        return this.checkMessageIdAttribute() && this.checkUsernameAttribute();
    }

    private boolean checkMessageIdAttribute() {
        return this.retrieveMessageId().map(this::validateMessageId).orElse(false);
    }

    private boolean validateMessageId(Object messageId) {
        if (messageId instanceof String) {
            try {
                this.messageIdFactory.fromString((String)messageId);
                return true;
            }
            catch (Exception e) {
                LOG.error("Invalid messageId: {}", messageId, (Object)e);
            }
        }
        LOG.error("Non-String messageId {} has type {}", messageId, messageId.getClass());
        return false;
    }

    private boolean checkUsernameAttribute() {
        return this.retrieveUsername().isPresent();
    }

    private void moveFromOutboxToSentWithSeenFlag(MessageId messageId, MailboxSession mailboxSession) {
        this.assertMessageBelongsToOutbox(messageId, mailboxSession).then(this.getSentMailboxId(mailboxSession).switchIfEmpty(Mono.error(() -> new MailboxRoleNotFoundException(Role.SENT))).flatMap(sentMailboxId -> Mono.from((Publisher)this.messageIdManager.setInMailboxesReactive(messageId, (Collection)ImmutableList.of((Object)sentMailboxId), mailboxSession)).then(Mono.from((Publisher)this.messageIdManager.setFlagsReactive(new Flags(Flags.Flag.SEEN), MessageManager.FlagsUpdateMode.ADD, messageId, (List)ImmutableList.of((Object)sentMailboxId), mailboxSession))))).block();
    }

    private Mono<Void> assertMessageBelongsToOutbox(MessageId messageId, MailboxSession mailboxSession) {
        return this.getOutboxMailboxId(mailboxSession).flatMap(outboxMailboxId -> Flux.from((Publisher)this.messageIdManager.getMessagesReactive((Collection)ImmutableList.of((Object)messageId), FetchGroup.MINIMAL, mailboxSession)).filter(message -> message.getMailboxId().equals(outboxMailboxId)).next().switchIfEmpty(Mono.error(() -> new MailShouldBeInOutboxException(messageId)))).then();
    }

    private Mono<MailboxId> getSentMailboxId(MailboxSession session) {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(Role.SENT, session.getUser())).next().map(MessageManager::getId);
    }

    private Mono<MailboxId> getOutboxMailboxId(MailboxSession session) {
        return Flux.from((Publisher)this.systemMailboxesProvider.getMailboxByRole(Role.OUTBOX, session.getUser())).next().map(MessageManager::getId);
    }
}

