/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import java.time.ZoneId;
import java.util.function.Function;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.opensearch.IndexAttachments;
import org.apache.james.mailbox.opensearch.IndexHeaders;
import org.apache.james.mailbox.opensearch.json.IndexableMessage;
import org.apache.james.mailbox.opensearch.json.MessageUpdateJson;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import reactor.core.publisher.Mono;

public class MessageToOpenSearchJson {
    private final ObjectMapper mapper;
    private final TextExtractor textExtractor;
    private final ZoneId zoneId;
    private final IndexAttachments indexAttachments;
    private final IndexHeaders indexHeaders;

    public MessageToOpenSearchJson(TextExtractor textExtractor, ZoneId zoneId, IndexAttachments indexAttachments, IndexHeaders indexHeaders) {
        this.textExtractor = textExtractor;
        this.zoneId = zoneId;
        this.indexAttachments = indexAttachments;
        this.indexHeaders = indexHeaders;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.registerModule((Module)new Jdk8Module());
    }

    @Inject
    public MessageToOpenSearchJson(TextExtractor textExtractor, IndexAttachments indexAttachments, IndexHeaders indexHeaders) {
        this(textExtractor, ZoneId.systemDefault(), indexAttachments, indexHeaders);
    }

    public Mono<String> convertToJson(MailboxMessage message) {
        Preconditions.checkNotNull((Object)message);
        return IndexableMessage.builder().message(message).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(this.indexAttachments).indexHeaders(this.indexHeaders).build().map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.mapper).writeValueAsString(arg_0)));
    }

    public Mono<String> convertToJsonWithoutAttachment(MailboxMessage message) {
        return IndexableMessage.builder().message(message).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(IndexAttachments.NO).indexHeaders(this.indexHeaders).build().map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.mapper).writeValueAsString(arg_0)));
    }

    public String getUpdatedJsonMessagePart(Flags flags, ModSeq modSeq) throws JsonProcessingException {
        Preconditions.checkNotNull((Object)flags);
        return this.mapper.writeValueAsString((Object)new MessageUpdateJson(flags, modSeq));
    }
}

