/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

enum TextLogMessages {
    ERR_TEXT_ACCESS_READER_CANNOT_DETERMINE_MESSAGE_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because the message type could not be determined."),
    ERR_TEXT_ACCESS_READER_UNSUPPORTED_ASSURANCE_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for an assurance completed log message."),
    ERR_TEXT_ACCESS_READER_UNSUPPORTED_FORWARD_FAILED_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a forward failed log message."),
    ERR_TEXT_ACCESS_READER_UNSUPPORTED_FORWARD_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a forward log message."),
    ERR_TEXT_ACCESS_READER_UNSUPPORTED_REQUEST_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a request log message."),
    ERR_TEXT_ACCESS_READER_UNSUPPORTED_RESULT_OP_TYPE("Unable to parse string ''{0}'' as a text-formatted access log message because it uses an unsupported operation type for a result log message."),
    ERR_TEXT_LOG_MESSAGE_INVALID_ESCAPED_CHARACTER("Unable to parse value ''{0}'' in log message ''{1}'' because it has an invalid hex-escaped character."),
    ERR_TEXT_LOG_MESSAGE_MISSING_TIMESTAMP("Unable to parse string ''{0}'' as a text-formatted log message because it does not start with a valid timestamp."),
    ERR_TEXT_LOG_MESSAGE_VALUE_NOT_BOOLEAN("Unable to parse the value of field ''{0}'' as a Boolean in text-formatted log message {1}."),
    ERR_TEXT_LOG_MESSAGE_VALUE_NOT_FLOATING_POINT("Unable to parse the value of field ''{0}'' as a floating-point number in text-formatted log message {1}."),
    ERR_TEXT_LOG_MESSAGE_VALUE_NOT_GENERALIZED_TIME("Unable to parse the value of field ''{0}'' as a generalized time value in text-formatted log message {1}."),
    ERR_TEXT_LOG_MESSAGE_VALUE_NOT_INTEGER("Unable to parse the value of field ''{0}'' as an integer in text-formatted log message ''{1}''."),
    ERR_TEXT_LOG_MESSAGE_VALUE_NOT_RFC_3339_TIMESTAMP("Unable to parse the value of field ''{0}'' as an RFC 3339 timestamp in text-formatted log message {1}.");

    private static final boolean IS_WITHIN_UNIT_TESTS;
    private static final Object[] NO_ARGS;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<TextLogMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<TextLogMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private TextLogMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(NO_ARGS);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        String formattedMessage;
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            if (RESOURCE_BUNDLE == null) {
                f = new MessageFormat(this.defaultText);
            } else {
                try {
                    f = new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
                }
                catch (Exception e) {
                    f = new MessageFormat(this.defaultText);
                }
            }
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            formattedMessage = f.format(args);
        }
        if (IS_WITHIN_UNIT_TESTS && (formattedMessage.contains("{0}") || formattedMessage.contains("{0,number,0}") || formattedMessage.contains("{1}") || formattedMessage.contains("{1,number,0}") || formattedMessage.contains("{2}") || formattedMessage.contains("{2,number,0}") || formattedMessage.contains("{3}") || formattedMessage.contains("{3,number,0}") || formattedMessage.contains("{4}") || formattedMessage.contains("{4,number,0}") || formattedMessage.contains("{5}") || formattedMessage.contains("{5,number,0}") || formattedMessage.contains("{6}") || formattedMessage.contains("{6,number,0}") || formattedMessage.contains("{7}") || formattedMessage.contains("{7,number,0}") || formattedMessage.contains("{8}") || formattedMessage.contains("{8,number,0}") || formattedMessage.contains("{9}") || formattedMessage.contains("{9,number,0}") || formattedMessage.contains("{10}") || formattedMessage.contains("{10,number,0}"))) {
            throw new IllegalArgumentException("Message " + ((Object)((Object)this)).getClass().getName() + '.' + this.name() + " contains an un-replaced token:  " + formattedMessage);
        }
        return formattedMessage;
    }

    public String toString() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                s = this.defaultText;
            } else {
                try {
                    s = RESOURCE_BUNDLE.getString(this.name());
                }
                catch (Exception e) {
                    s = this.defaultText;
                }
                MESSAGE_STRINGS.putIfAbsent(this, s);
            }
        }
        return s;
    }

    static {
        IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
        NO_ARGS = new Object[0];
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("unboundid-ldapsdk-text-log");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap(100);
        MESSAGES = new ConcurrentHashMap(100);
    }
}

