/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.cassandra;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.user.api.DelegationStore;
import org.apache.james.user.cassandra.CassandraUsersDAO;
import org.reactivestreams.Publisher;

public class CassandraDelegationStore
implements DelegationStore {
    private final CassandraUsersDAO cassandraUsersDAO;

    @Inject
    public CassandraDelegationStore(CassandraUsersDAO cassandraUsersDAO) {
        this.cassandraUsersDAO = cassandraUsersDAO;
    }

    public Publisher<Username> authorizedUsers(Username baseUser) {
        return this.cassandraUsersDAO.getAuthorizedUsers(baseUser);
    }

    public Publisher<Void> clear(Username baseUser) {
        return this.cassandraUsersDAO.removeAllAuthorizedUsers(baseUser);
    }

    public Publisher<Void> addAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.cassandraUsersDAO.addAuthorizedUsers(baseUser, userWithAccess);
    }

    public Publisher<Void> removeAuthorizedUser(Username baseUser, Username userWithAccess) {
        return this.cassandraUsersDAO.removeAuthorizedUser(baseUser, userWithAccess);
    }

    public Publisher<Username> delegatedUsers(Username baseUser) {
        return this.cassandraUsersDAO.getDelegatedToUsers(baseUser);
    }

    public Publisher<Void> removeDelegatedUser(Username baseUser, Username delegatedToUser) {
        return this.cassandraUsersDAO.removeDelegatedToUser(baseUser, delegatedToUser);
    }
}

