/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.server.core.MailImpl;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;

public class AddDefaultAttributesMessageHook
implements JamesMessageHook {
    public static final String SMTP_AUTH_NETWORK_NAME = "org.apache.james.SMTPIsAuthNetwork";

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        if (mail instanceof MailImpl) {
            MailImpl mailImpl = (MailImpl)mail;
            mailImpl.setRemoteHost(session.getRemoteAddress().getHostName());
            mailImpl.setRemoteAddr(session.getRemoteAddress().getAddress().getHostAddress());
            if (session.getUsername() != null) {
                mail.setAttribute(new Attribute(Mail.SMTP_AUTH_USER, AttributeValue.of((String)session.getUsername().asString())));
            }
            if (session.isRelayingAllowed()) {
                mail.setAttribute(Attribute.convertToAttribute((String)SMTP_AUTH_NETWORK_NAME, (Object)true));
            }
        }
        return HookResult.DECLINED;
    }
}

