/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.eventsourcing.acl;

import java.util.List;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Command;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.MailboxACLAggregate;
import org.apache.james.mailbox.cassandra.mail.eventsourcing.acl.MailboxAggregateId;
import org.apache.james.mailbox.model.MailboxACL;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SetACLCommand
implements Command {
    private final MailboxAggregateId id;
    private final MailboxACL acl;

    public SetACLCommand(MailboxAggregateId id, MailboxACL acl) {
        this.id = id;
        this.acl = acl;
    }

    public MailboxAggregateId getId() {
        return this.id;
    }

    public MailboxACL getAcl() {
        return this.acl;
    }

    public static class CommandHandler
    implements org.apache.james.eventsourcing.CommandHandler<SetACLCommand> {
        private final EventStore eventStore;

        public CommandHandler(EventStore eventStore) {
            this.eventStore = eventStore;
        }

        public Class<SetACLCommand> handledClass() {
            return SetACLCommand.class;
        }

        public Publisher<List<? extends Event>> handle(SetACLCommand command) {
            return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)command.getId())).map(history -> MailboxACLAggregate.load(command.getId(), history)).map(aggregate -> aggregate.set(command));
        }
    }
}

