/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.hook;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.protocols.smtp.hook.HookReturnCode;

public final class HookResult {
    public static final HookResult DECLINED = HookResult.builder().hookReturnCode(HookReturnCode.declined()).build();
    public static final HookResult OK = HookResult.builder().hookReturnCode(HookReturnCode.ok()).build();
    public static final HookResult DENY = HookResult.builder().hookReturnCode(HookReturnCode.deny()).build();
    public static final HookResult DENYSOFT = HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).build();
    public static final HookResult DISCONNECT = HookResult.builder().hookReturnCode(new HookReturnCode(HookReturnCode.Action.NONE, HookReturnCode.ConnectionStatus.DISCONNECTED)).build();
    private final HookReturnCode result;
    private final String smtpRetCode;
    private final String smtpDescription;

    public static Builder builder() {
        return new Builder();
    }

    private HookResult(HookReturnCode result, String smtpRetCode, CharSequence smtpDescription) {
        this.result = result;
        this.smtpRetCode = smtpRetCode;
        this.smtpDescription = Optional.ofNullable(smtpDescription).map(CharSequence::toString).orElse(null);
    }

    public HookReturnCode getResult() {
        return this.result;
    }

    public String getSmtpRetCode() {
        return this.smtpRetCode;
    }

    public String getSmtpDescription() {
        return this.smtpDescription;
    }

    public final boolean equals(Object o) {
        if (o instanceof HookResult) {
            HookResult that = (HookResult)o;
            return Objects.equals(this.result, that.result) && Objects.equals(this.smtpRetCode, that.smtpRetCode) && Objects.equals(this.smtpDescription, that.smtpDescription);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.result, this.smtpRetCode, this.smtpDescription);
    }

    public static class Builder {
        private HookReturnCode result;
        private Optional<String> smtpReturnCode;
        private Optional<String> smtpDescription = Optional.empty();

        public Builder() {
            this.smtpReturnCode = Optional.empty();
        }

        public Builder hookReturnCode(HookReturnCode hookReturnCode) {
            this.result = hookReturnCode;
            return this;
        }

        public Builder smtpReturnCode(String smtpReturnCode) {
            this.smtpReturnCode = Optional.of(smtpReturnCode);
            return this;
        }

        public Builder smtpDescription(String smtpDescription) {
            this.smtpDescription = Optional.of(smtpDescription);
            return this;
        }

        public HookResult build() {
            Preconditions.checkNotNull((Object)this.result);
            return new HookResult(this.result, this.smtpReturnCode.orElse(null), this.smtpDescription.orElse(null));
        }
    }
}

