/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.codec.Base64InputStream;
import org.apache.james.mime4j.codec.Base64OutputStream;
import org.apache.james.mime4j.codec.EncoderUtil;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class EncoderUtilTest {
    @Test
    public void testEncodeAddressDisplayName() throws Exception {
        Assert.assertEquals((Object)"\"\"", (Object)EncoderUtil.encodeAddressDisplayName((String)""));
        Assert.assertEquals((Object)"test", (Object)EncoderUtil.encodeAddressDisplayName((String)"test"));
        Assert.assertEquals((Object)" test ", (Object)EncoderUtil.encodeAddressDisplayName((String)" test "));
        Assert.assertEquals((Object)" test\ttest ", (Object)EncoderUtil.encodeAddressDisplayName((String)" test\ttest "));
        Assert.assertEquals((Object)"\"test()\"", (Object)EncoderUtil.encodeAddressDisplayName((String)"test()"));
        Assert.assertEquals((Object)"\"John Q. Public\"", (Object)EncoderUtil.encodeAddressDisplayName((String)"John Q. Public"));
        Assert.assertEquals((Object)"\"Giant; \\\"Big\\\" Box\"", (Object)EncoderUtil.encodeAddressDisplayName((String)"Giant; \"Big\" Box"));
        Assert.assertEquals((Object)"=?ISO-8859-1?Q?Semmelbr=F6sel?=", (Object)EncoderUtil.encodeAddressDisplayName((String)"Semmelbr\u00f6sel"));
        Assert.assertEquals((Object)"=?UTF-8?Q?Dollar_=24_Euro_=E2=82=AC?=", (Object)EncoderUtil.encodeAddressDisplayName((String)"Dollar $ Euro \u20ac"));
    }

    @Test
    public void testEncodeAddressLocalPart() throws Exception {
        Assert.assertEquals((Object)"john.wayne", (Object)EncoderUtil.encodeAddressLocalPart((String)"john.wayne"));
        Assert.assertEquals((Object)"\"clint eastwood\"", (Object)EncoderUtil.encodeAddressLocalPart((String)"clint eastwood"));
    }

    @Test
    public void testEncodeHeaderParameter() throws Exception {
        Assert.assertEquals((Object)"p=test", (Object)EncoderUtil.encodeHeaderParameter((String)"p", (String)"test"));
        Assert.assertEquals((Object)"p=\"test test\"", (Object)EncoderUtil.encodeHeaderParameter((String)"p", (String)"test test"));
        Assert.assertEquals((Object)"p=\"=test\"", (Object)EncoderUtil.encodeHeaderParameter((String)"p", (String)"=test"));
        Assert.assertEquals((Object)"p=\"\\\\test\"", (Object)EncoderUtil.encodeHeaderParameter((String)"p", (String)"\\test"));
        Assert.assertEquals((Object)"p=\"\\\"\\\\\\\"\"", (Object)EncoderUtil.encodeHeaderParameter((String)"p", (String)"\"\\\""));
    }

    @Test
    public void testHasToBeEncoded() throws Exception {
        Assert.assertFalse((boolean)EncoderUtil.hasToBeEncoded((String)"", (int)0));
        Assert.assertFalse((boolean)EncoderUtil.hasToBeEncoded((String)"only ascii characters", (int)0));
        Assert.assertTrue((boolean)EncoderUtil.hasToBeEncoded((String)"non-printable ascii: \b", (int)0));
        Assert.assertTrue((boolean)EncoderUtil.hasToBeEncoded((String)"non-ascii: \u20ac", (int)0));
        Assert.assertFalse((boolean)EncoderUtil.hasToBeEncoded((String)"123456789012345678901234567", (int)50));
        Assert.assertTrue((boolean)EncoderUtil.hasToBeEncoded((String)"1234567890123456789012345678", (int)50));
        Assert.assertFalse((boolean)EncoderUtil.hasToBeEncoded((String)"\t12345678901234567890123456789", (int)50));
    }

    @Test
    public void testEncodeEncodedWordDetectCharset() throws Exception {
        Assert.assertTrue((boolean)EncoderUtil.encodeEncodedWord((String)"only ascii", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN).startsWith("=?US-ASCII?"));
        Assert.assertTrue((boolean)EncoderUtil.encodeEncodedWord((String)"latin 1: \u00e4", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN).startsWith("=?ISO-8859-1?"));
        Assert.assertTrue((boolean)EncoderUtil.encodeEncodedWord((String)"unicode: \u20ac", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN).startsWith("=?UTF-8?"));
    }

    @Test
    public void testEncodeEncodedWordForceCharset() throws Exception {
        Assert.assertTrue((boolean)EncoderUtil.encodeEncodedWord((String)"only ascii", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, (Charset)Charsets.UTF_8, null).startsWith("=?UTF-8?"));
    }

    @Test
    public void testEncodeEncodedWordDetectEncoding() throws Exception {
        Assert.assertTrue((boolean)EncoderUtil.encodeEncodedWord((String)"only ascii", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN).startsWith("=?US-ASCII?Q?"));
        Assert.assertTrue((boolean)EncoderUtil.encodeEncodedWord((String)"\u00e4\u00e4\u00e4\u00e4\u00e4", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN).startsWith("=?ISO-8859-1?B?"));
    }

    @Test
    public void testEncodeEncodedWordForceEncoding() throws Exception {
        Assert.assertTrue((boolean)EncoderUtil.encodeEncodedWord((String)"only ascii", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.B).startsWith("=?US-ASCII?B?"));
    }

    @Test
    public void testEncodeEncodedWordSplit() throws Exception {
        String sixty = "123456789012345678901234567890123456789012345678901234567890";
        String expected = "=?US-ASCII?Q?" + sixty + "?=";
        Assert.assertEquals((Object)expected, (Object)EncoderUtil.encodeEncodedWord((String)sixty, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.Q));
        Assert.assertEquals((long)75L, (long)expected.length());
        String sixtyOne = sixty + "1";
        String encodedSixtyOne = EncoderUtil.encodeEncodedWord((String)sixtyOne, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.Q);
        Assert.assertTrue((boolean)encodedSixtyOne.contains("?= =?US-ASCII?Q?"));
    }

    @Test
    public void testEncodeBEncodedWordSplitForUnicode() throws Exception {
        StringBuilder sb = new StringBuilder("z");
        for (int i = 0; i < 10; ++i) {
            sb.append("\ud835\udd6b");
        }
        String expected = "=?UTF-8?B?evCdlavwnZWr8J2Vq/Cdlas=?= =?UTF-8?B?8J2Vq/CdlavwnZWr8J2Vq/CdlavwnZWr?=";
        Assert.assertEquals((Object)expected, (Object)EncoderUtil.encodeEncodedWord((String)sb.toString(), (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)10, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.B));
    }

    @Test
    public void testEncodeQEncodedWordSplitForUnicode() throws Exception {
        StringBuilder sb = new StringBuilder("z");
        for (int i = 0; i < 6; ++i) {
            sb.append("\ud835\udd6b");
        }
        String expected = "=?UTF-8?Q?z=F0=9D=95=AB=F0=9D=95=AB?= =?UTF-8?Q?=F0=9D=95=AB=F0=9D=95=AB=F0=9D=95=AB=F0=9D=95=AB?=";
        Assert.assertEquals((Object)expected, (Object)EncoderUtil.encodeEncodedWord((String)sb.toString(), (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)10, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.Q));
    }

    @Test
    public void testEncodeEncodedWord() throws Exception {
        Assert.assertEquals((Object)"=?US-ASCII?Q??=", (Object)EncoderUtil.encodeEncodedWord((String)"", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.Q));
        Assert.assertEquals((Object)"=?US-ASCII?Q?testing_123?=", (Object)EncoderUtil.encodeEncodedWord((String)"testing 123", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.Q));
        Assert.assertEquals((Object)"=?US-ASCII?B?dGVzdGluZyAxMjM=?=", (Object)EncoderUtil.encodeEncodedWord((String)"testing 123", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, null, (EncoderUtil.Encoding)EncoderUtil.Encoding.B));
        Assert.assertEquals((Object)"=?windows-1252?Q?100_=80?=", (Object)EncoderUtil.encodeEncodedWord((String)"100 \u20ac", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, (Charset)Charset.forName("Cp1252"), (EncoderUtil.Encoding)EncoderUtil.Encoding.Q));
        Assert.assertEquals((Object)"=?windows-1252?B?MTAwIIA=?=", (Object)EncoderUtil.encodeEncodedWord((String)"100 \u20ac", (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN, (int)0, (Charset)Charset.forName("Cp1252"), (EncoderUtil.Encoding)EncoderUtil.Encoding.B));
    }

    @Test
    public void testEncodeB() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.encodeB(""));
        Assert.assertEquals((Object)"YQ==", (Object)this.encodeB("a"));
        Assert.assertEquals((Object)"YWI=", (Object)this.encodeB("ab"));
        Assert.assertEquals((Object)"YWJj", (Object)this.encodeB("abc"));
        Assert.assertEquals((Object)"YWJjZA==", (Object)this.encodeB("abcd"));
        Assert.assertEquals((Object)"YWJjZGU=", (Object)this.encodeB("abcde"));
        Assert.assertEquals((Object)"YWJjZGVm", (Object)this.encodeB("abcdef"));
        Assert.assertEquals((Object)"YWJjZGVmZw==", (Object)this.encodeB("abcdefg"));
        Assert.assertEquals((Object)"YWJjZGVmZ2g=", (Object)this.encodeB("abcdefgh"));
        Assert.assertEquals((Object)"YWJjZGVmZ2hp", (Object)this.encodeB("abcdefghi"));
        Assert.assertEquals((Object)"DQoMCQ==", (Object)this.encodeB("\r\n\f\t"));
        Assert.assertEquals((Object)"LT0/VGhhdCdzIGEgdGVzdD89LQ==", (Object)this.encodeB("-=?That's a test?=-"));
    }

    @Test
    public void testEncodeQRegular() throws Exception {
        byte[] b = new byte[132];
        for (int i = 0; i < 132; ++i) {
            b[i] = (byte)i;
        }
        String expected = "=00=01=02=03=04=05=06=07=08=09=0A=0B=0C=0D=0E=0F=10=11=12=13=14=15=16=17=18=19=1A=1B=1C=1D=1E=1F_!\"#$%&'()*+,-./0123456789:;<=3D>=3F@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^=5F`abcdefghijklmnopqrstuvwxyz{|}~=7F=80=81=82=83";
        Assert.assertEquals((Object)expected, (Object)EncoderUtil.encodeQ((byte[])b, (EncoderUtil.Usage)EncoderUtil.Usage.TEXT_TOKEN));
    }

    @Test
    public void testEncodeQRestricted() throws Exception {
        byte[] b = new byte[136];
        for (int i = 0; i < 136; ++i) {
            b[i] = (byte)i;
        }
        String expected = "=00=01=02=03=04=05=06=07=08=09=0A=0B=0C=0D=0E=0F=10=11=12=13=14=15=16=17=18=19=1A=1B=1C=1D=1E=1F_!=22=23=24=25=26=27=28=29*+=2C-=2E/0123456789=3A=3B=3C=3D=3E=3F=40ABCDEFGHIJKLMNOPQRSTUVWXYZ=5B=5C=5D=5E=5F=60abcdefghijklmnopqrstuvwxyz=7B=7C=7D=7E=7F=80=81=82=83=84=85=86=87";
        Assert.assertEquals((Object)expected, (Object)EncoderUtil.encodeQ((byte[])b, (EncoderUtil.Usage)EncoderUtil.Usage.WORD_ENTITY));
    }

    private String encodeB(String s) {
        try {
            return EncoderUtil.encodeB((byte[])s.getBytes("us-ascii"));
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    @Test
    public void testEncodeQuotedPrintableLargeInput() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5120; ++i) {
            sb.append((char)(48 + i % 10));
        }
        String expected = sb.toString().replaceAll("(\\d{75})", "$1=\r\n");
        InputStream in = InputStreams.createAscii((CharSequence)sb.toString());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncoderUtil.encodeQBinary((InputStream)in, (OutputStream)out);
        String actual = ContentUtil.toAsciiString((byte[])out.toByteArray());
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testEncodeQuotedPrintableNonAsciiChars() throws Exception {
        String s = "7bit content with euro \u20ac symbol";
        InputStream in = InputStreams.create((CharSequence)s, (Charset)Charset.forName("iso-8859-15"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncoderUtil.encodeQBinary((InputStream)in, (OutputStream)out);
        String actual = new String(out.toByteArray(), "US-ASCII");
        Assert.assertEquals((Object)"7bit=20content=20with=20euro=20=A4=20symbol", (Object)actual);
    }

    @Test
    public void testBase64OutputStream() throws Exception {
        StringBuilder sb = new StringBuilder(2048);
        for (int i = 0; i < 128; ++i) {
            sb.append("0123456789ABCDEF");
        }
        String input = sb.toString();
        String output = this.roundtripUsingOutputStream(input);
        Assert.assertEquals((Object)input, (Object)output);
    }

    private String roundtripUsingOutputStream(String input) throws IOException {
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        Base64OutputStream outb64 = new Base64OutputStream((OutputStream)out2, 76);
        ContentUtil.copy((InputStream)InputStreams.create((CharSequence)input, (Charset)Charsets.ISO_8859_1), (OutputStream)outb64);
        outb64.flush();
        outb64.close();
        Base64InputStream is = new Base64InputStream(InputStreams.create((byte[])out2.toByteArray()));
        byte[] buf = ContentUtil.buffer((InputStream)is);
        return ContentUtil.toAsciiString((byte[])buf);
    }

    @Test
    public void testBase64Encoder() throws Exception {
        StringBuilder sb = new StringBuilder(2048);
        for (int i = 0; i < 128; ++i) {
            sb.append("0123456789ABCDEF");
        }
        String input = sb.toString();
        String output = this.roundtripUsingEncoder(input);
        Assert.assertEquals((Object)input, (Object)output);
    }

    private String roundtripUsingEncoder(String input) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        EncoderUtil.encodeB((InputStream)InputStreams.createAscii((CharSequence)input), (OutputStream)out);
        Base64InputStream is = new Base64InputStream(InputStreams.create((byte[])out.toByteArray()));
        byte[] buf = ContentUtil.buffer((InputStream)is);
        return ContentUtil.toAsciiString((byte[])buf);
    }
}

