/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.parser.address;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.parser.address.AddressNode;
import org.apache.jsieve.parser.address.BaseAddressListVisitor;
import org.apache.jsieve.parser.generated.address.ASTaddr_spec;
import org.apache.jsieve.parser.generated.address.ASTaddress_list;
import org.apache.jsieve.parser.generated.address.ASTdomain;
import org.apache.jsieve.parser.generated.address.ASTlocal_part;
import org.apache.jsieve.parser.generated.address.AddressListParser;
import org.apache.jsieve.parser.generated.address.ParseException;
import org.apache.jsieve.parser.generated.address.Token;

public class SieveAddressBuilder {
    private static final MailAdapter.Address[] EMPTY_ADDRESSES = new MailAdapter.Address[0];
    private final Collection<MailAdapter.Address> addresses = Collections.synchronizedCollection(new ArrayList());
    private final Worker worker = new Worker();

    public void reset() {
        this.addresses.clear();
    }

    public void addAddresses(String addressList) throws ParseException {
        StringReader reader = new StringReader(addressList);
        this.worker.addAddressses(reader, this.addresses);
    }

    public MailAdapter.Address[] getAddresses() {
        return this.addresses.toArray(EMPTY_ADDRESSES);
    }

    private final class AddressBean
    implements MailAdapter.Address {
        private String localPart = "";
        private String domain = "";

        @Override
        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public String getLocalPart() {
            return this.localPart;
        }

        public void setLocalPart(String localPart) {
            this.localPart = localPart;
        }
    }

    private final class Worker
    extends BaseAddressListVisitor {
        private Worker() {
        }

        public void addAddressses(Reader reader, Collection results) throws ParseException {
            AddressListParser parser = new AddressListParser(reader);
            ASTaddress_list root = parser.parse();
            root.childrenAccept(this, results);
        }

        @Override
        public Object visit(ASTaddr_spec node, Object data) {
            AddressBean address = new AddressBean();
            node.childrenAccept(this, address);
            if (data instanceof Collection) {
                Collection collection = (Collection)data;
                collection.add(address);
            }
            return data;
        }

        @Override
        public Object visit(ASTdomain node, Object data) {
            if (data instanceof AddressBean) {
                AddressBean address = (AddressBean)data;
                String domain = this.contents(node);
                address.setDomain(domain);
            }
            return data;
        }

        @Override
        public Object visit(ASTlocal_part node, Object data) {
            if (data instanceof AddressBean) {
                AddressBean address = (AddressBean)data;
                String localPart = this.contents(node);
                address.setLocalPart(localPart);
            }
            return data;
        }

        private String contents(AddressNode node) {
            StringBuilder buffer = new StringBuilder(32);
            Token last = node.lastToken;
            Token next = node.firstToken;
            while (next != last) {
                buffer.append(next.image);
                next = next.next;
            }
            buffer.append(last.image);
            return buffer.toString();
        }
    }
}

