/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ISeqCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionTableSchemaCollector;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.MultiTsFileDeviceIterator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.batch.BatchedReadChunkAlignedSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.SingleSeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileWriter;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.ReadChunkInnerCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.write.PageException;
import org.apache.tsfile.file.metadata.AbstractAlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.Schema;

public class ReadChunkCompactionPerformer
implements ISeqCompactionPerformer {
    private List<TsFileResource> seqFiles;
    private List<TsFileResource> targetResources;
    private CompactionTaskSummary summary;
    private CompactionTsFileWriter currentWriter;
    private long endedFileSize = 0L;
    private int currentTargetFileIndex = 0;
    private final long memoryBudgetForFileWriter = (long)((double)SystemInfo.getInstance().getMemorySizeForCompaction() / (double)IoTDBDescriptor.getInstance().getConfig().getCompactionThreadCount() * IoTDBDescriptor.getInstance().getConfig().getChunkMetadataSizeProportion());
    private Schema schema = null;

    public ReadChunkCompactionPerformer(List<TsFileResource> sourceFiles, TsFileResource targetFile) {
        this(sourceFiles, Collections.singletonList(targetFile));
    }

    public ReadChunkCompactionPerformer(List<TsFileResource> sourceFiles, List<TsFileResource> targetFiles) {
        this.setSourceFiles(sourceFiles);
        this.setTargetFiles(targetFiles);
    }

    public ReadChunkCompactionPerformer(List<TsFileResource> sourceFiles) {
        this.setSourceFiles(sourceFiles);
    }

    public ReadChunkCompactionPerformer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws IOException, MetadataException, InterruptedException, StorageEngineException, PageException {
        try (MultiTsFileDeviceIterator deviceIterator = new MultiTsFileDeviceIterator(this.seqFiles);){
            this.schema = CompactionTableSchemaCollector.collectSchema(this.seqFiles, deviceIterator.getReaderMap());
            while (deviceIterator.hasNextDevice()) {
                this.currentWriter = this.getAvailableCompactionWriter();
                Pair<IDeviceID, Boolean> deviceInfo = deviceIterator.nextDevice();
                IDeviceID device = (IDeviceID)deviceInfo.left;
                boolean aligned = (Boolean)deviceInfo.right;
                if (aligned) {
                    this.compactAlignedSeries(device, this.targetResources.get(this.currentTargetFileIndex), this.currentWriter, deviceIterator);
                } else {
                    this.compactNotAlignedSeries(device, this.targetResources.get(this.currentTargetFileIndex), this.currentWriter, deviceIterator);
                }
                this.summary.setTemporaryFileSize(this.endedFileSize + this.currentWriter.getPos());
            }
            for (TsFileResource tsFileResource : this.seqFiles) {
                for (TsFileResource targetResource : this.targetResources) {
                    targetResource.updatePlanIndexes(tsFileResource);
                }
            }
        }
        finally {
            for (int i = this.currentTargetFileIndex + 1; i < this.targetResources.size(); ++i) {
                this.targetResources.get(i).forceMarkDeleted();
            }
            if (this.currentWriter == null) {
                this.targetResources.get(this.currentTargetFileIndex).forceMarkDeleted();
            } else {
                this.currentWriter.endFile();
                if (this.currentWriter.isEmptyTargetFile()) {
                    this.targetResources.get(this.currentTargetFileIndex).forceMarkDeleted();
                }
            }
        }
    }

    private CompactionTsFileWriter getAvailableCompactionWriter() throws IOException {
        boolean shouldSwitchToNextWriter;
        if (this.currentWriter == null) {
            this.useNewWriter();
            return this.currentWriter;
        }
        boolean bl = shouldSwitchToNextWriter = this.currentWriter.getPos() >= IoTDBDescriptor.getInstance().getConfig().getTargetCompactionFileSize() && this.currentTargetFileIndex != this.targetResources.size() - 1;
        if (shouldSwitchToNextWriter) {
            this.rollCompactionFileWriter();
        }
        return this.currentWriter;
    }

    private void rollCompactionFileWriter() throws IOException {
        this.currentWriter.endFile();
        this.endedFileSize += this.currentWriter.getFile().length();
        if (this.currentWriter.isEmptyTargetFile()) {
            this.targetResources.get(this.currentTargetFileIndex).forceMarkDeleted();
        }
        this.currentWriter = null;
        ++this.currentTargetFileIndex;
        this.useNewWriter();
    }

    private void useNewWriter() throws IOException {
        this.currentWriter = new CompactionTsFileWriter(this.targetResources.get(this.currentTargetFileIndex).getTsFile(), this.memoryBudgetForFileWriter, CompactionType.INNER_SEQ_COMPACTION);
        this.currentWriter.setSchema(CompactionTableSchemaCollector.copySchema(this.schema));
    }

    @Override
    public void setTargetFiles(List<TsFileResource> targetFiles) {
        this.targetResources = targetFiles;
    }

    @Override
    public void setSummary(CompactionTaskSummary summary) {
        this.summary = summary;
    }

    private void compactAlignedSeries(IDeviceID device, TsFileResource targetResource, CompactionTsFileWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, InterruptedException, IllegalPathException, PageException {
        this.checkThreadInterrupted();
        LinkedList<Pair<TsFileSequenceReader, List<AbstractAlignedChunkMetadata>>> readerAndChunkMetadataList = deviceIterator.getReaderAndChunkMetadataForCurrentAlignedSeries();
        if (!this.checkAlignedSeriesExists(readerAndChunkMetadataList)) {
            return;
        }
        writer.startChunkGroup(device);
        BatchedReadChunkAlignedSeriesCompactionExecutor compactionExecutor = new BatchedReadChunkAlignedSeriesCompactionExecutor(device, targetResource, readerAndChunkMetadataList, writer, this.summary, device.getTableName().startsWith("root."));
        compactionExecutor.execute();
        for (ChunkMetadata chunkMetadata : writer.getChunkMetadataListOfCurrentDeviceInMemory()) {
            if (!chunkMetadata.getMeasurementUid().isEmpty()) continue;
            targetResource.updateStartTime(device, chunkMetadata.getStartTime());
            targetResource.updateEndTime(device, chunkMetadata.getEndTime());
        }
        writer.checkMetadataSizeAndMayFlush();
        writer.endChunkGroup();
    }

    private void checkThreadInterrupted() throws InterruptedException {
        if (Thread.interrupted() || this.summary.isCancel()) {
            throw new InterruptedException(String.format("[Compaction] compaction for target files %s abort", this.targetResources));
        }
    }

    private boolean checkAlignedSeriesExists(LinkedList<Pair<TsFileSequenceReader, List<AbstractAlignedChunkMetadata>>> readerAndChunkMetadataList) {
        for (Pair pair : readerAndChunkMetadataList) {
            if (((List)pair.right).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void compactNotAlignedSeries(IDeviceID device, TsFileResource targetResource, CompactionTsFileWriter writer, MultiTsFileDeviceIterator deviceIterator) throws IOException, MetadataException, InterruptedException {
        writer.startChunkGroup(device);
        MultiTsFileDeviceIterator.MultiTsFileNonAlignedMeasurementMetadataListIterator seriesIterator = deviceIterator.iterateNotAlignedSeriesAndChunkMetadataListOfCurrentDevice();
        while (seriesIterator.hasNextSeries()) {
            this.checkThreadInterrupted();
            String measurement = seriesIterator.nextSeries();
            LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList = seriesIterator.getMetadataListForCurrentSeries();
            readerAndChunkMetadataList = this.filterDataTypeNotMatchedChunkMetadata(readerAndChunkMetadataList);
            SingleSeriesCompactionExecutor compactionExecutorOfCurrentTimeSeries = new SingleSeriesCompactionExecutor(device, measurement, readerAndChunkMetadataList, writer, targetResource, this.summary);
            compactionExecutorOfCurrentTimeSeries.execute();
        }
        writer.endChunkGroup();
    }

    private LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> filterDataTypeNotMatchedChunkMetadata(LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataList) {
        if (readerAndChunkMetadataList.isEmpty()) {
            return readerAndChunkMetadataList;
        }
        LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> result = new LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>>();
        TSDataType correctDataType = null;
        block0: for (int i = readerAndChunkMetadataList.size() - 1; i >= 0 && correctDataType == null; --i) {
            List list = (List)readerAndChunkMetadataList.get(i).getRight();
            if (list == null || list.isEmpty()) continue;
            for (ChunkMetadata chunkMetadata : list) {
                if (chunkMetadata == null) continue;
                correctDataType = chunkMetadata.getDataType();
                continue block0;
            }
        }
        if (correctDataType == null) {
            return readerAndChunkMetadataList;
        }
        for (Pair pair : readerAndChunkMetadataList) {
            boolean dataTypeConsistent = true;
            for (ChunkMetadata chunkMetadata : (List)pair.getRight()) {
                if (chunkMetadata == null || chunkMetadata.getDataType() == correctDataType) continue;
                dataTypeConsistent = false;
                break;
            }
            if (!dataTypeConsistent) continue;
            result.add((Pair<TsFileSequenceReader, List<ChunkMetadata>>)pair);
        }
        return result;
    }

    @Override
    public void setSourceFiles(List<TsFileResource> seqFiles) {
        this.seqFiles = seqFiles;
    }

    @Override
    public Optional<AbstractInnerSpaceEstimator> getInnerSpaceEstimator() {
        return Optional.of(new ReadChunkInnerCompactionEstimator());
    }
}

