/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SelectItem;

public class Select
extends Node {
    private final boolean distinct;
    private final List<SelectItem> selectItems;

    public Select(boolean distinct, List<SelectItem> selectItems) {
        super(null);
        this.distinct = distinct;
        this.selectItems = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectItems, "selectItems"));
    }

    public Select(NodeLocation location, boolean distinct, List<SelectItem> selectItems) {
        super(Objects.requireNonNull(location, "location is null"));
        this.distinct = distinct;
        this.selectItems = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectItems, "selectItems"));
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSelect(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.selectItems;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("distinct", this.distinct).add("selectItems", this.selectItems).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        return this.distinct == select.distinct && Objects.equals(this.selectItems, select.selectItems);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distinct, this.selectItems);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Select.sameClass(this, other)) {
            return false;
        }
        return this.distinct == ((Select)other).distinct;
    }
}

