/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.planner.EqualityInference;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolsExtractor;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.DeterminismEvaluator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.JoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;

public class JoinUtils {
    public static final String UNSUPPORTED_JOIN_CRITERIA = "Unsupported Join creteria [%s] after predicate push down";

    private JoinUtils() {
    }

    static Expression extractJoinPredicate(JoinNode joinNode) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (JoinNode.EquiJoinClause equiJoinClause : joinNode.getCriteria()) {
            builder.add((Object)equiJoinClause.toExpression());
        }
        joinNode.getFilter().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return IrUtils.combineConjuncts((Collection<Expression>)builder.build());
    }

    static boolean joinEqualityExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
        return JoinUtils.joinComparisonExpression(expression, leftSymbols, rightSymbols, (Set<ComparisonExpression.Operator>)ImmutableSet.of((Object)((Object)ComparisonExpression.Operator.EQUAL)));
    }

    private static boolean joinComparisonExpression(Expression expression, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols, Set<ComparisonExpression.Operator> operators) {
        ComparisonExpression comparison;
        if (expression instanceof ComparisonExpression && DeterminismEvaluator.isDeterministic(expression) && operators.contains((Object)(comparison = (ComparisonExpression)expression).getOperator())) {
            Set<Symbol> symbols1 = SymbolsExtractor.extractUnique(comparison.getLeft());
            Set<Symbol> symbols2 = SymbolsExtractor.extractUnique(comparison.getRight());
            if (symbols1.isEmpty() || symbols2.isEmpty()) {
                return false;
            }
            return leftSymbols.containsAll(symbols1) && rightSymbols.containsAll(symbols2) || rightSymbols.containsAll(symbols1) && leftSymbols.containsAll(symbols2);
        }
        return false;
    }

    static InnerJoinPushDownResult processInnerJoin(Metadata metadata, Expression inheritedPredicate, Expression leftEffectivePredicate, Expression rightEffectivePredicate, Expression joinPredicate, Collection<Symbol> leftSymbols, Collection<Symbol> rightSymbols) {
        Preconditions.checkArgument((boolean)leftSymbols.containsAll(SymbolsExtractor.extractUnique(leftEffectivePredicate)), (Object)"leftEffectivePredicate must only contain symbols from leftSymbols");
        Preconditions.checkArgument((boolean)rightSymbols.containsAll(SymbolsExtractor.extractUnique(rightEffectivePredicate)), (Object)"rightEffectivePredicate must only contain symbols from rightSymbols");
        ImmutableList.Builder leftPushDownConjuncts = ImmutableList.builder();
        ImmutableList.Builder rightPushDownConjuncts = ImmutableList.builder();
        ImmutableList.Builder joinConjuncts = ImmutableList.builder();
        IrUtils.extractConjuncts(inheritedPredicate).stream().filter(deterministic -> !DeterminismEvaluator.isDeterministic(deterministic)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
        inheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
        IrUtils.extractConjuncts(joinPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
        joinPredicate = IrUtils.filterDeterministicConjuncts(joinPredicate);
        leftEffectivePredicate = IrUtils.filterDeterministicConjuncts(leftEffectivePredicate);
        rightEffectivePredicate = IrUtils.filterDeterministicConjuncts(rightEffectivePredicate);
        ImmutableSet leftScope = ImmutableSet.copyOf(leftSymbols);
        ImmutableSet rightScope = ImmutableSet.copyOf(rightSymbols);
        EqualityInference allInference = new EqualityInference(metadata, inheritedPredicate, leftEffectivePredicate, rightEffectivePredicate, joinPredicate);
        EqualityInference allInferenceWithoutLeftInferred = new EqualityInference(metadata, inheritedPredicate, rightEffectivePredicate, joinPredicate);
        EqualityInference allInferenceWithoutRightInferred = new EqualityInference(metadata, inheritedPredicate, leftEffectivePredicate, joinPredicate);
        leftPushDownConjuncts.addAll(allInferenceWithoutLeftInferred.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeEqualities());
        rightPushDownConjuncts.addAll(allInferenceWithoutRightInferred.generateEqualitiesPartitionedBy((Set<Symbol>)rightScope).getScopeEqualities());
        joinConjuncts.addAll(allInference.generateEqualitiesPartitionedBy((Set<Symbol>)leftScope).getScopeStraddlingEqualities());
        EqualityInference.nonInferrableConjuncts(metadata, inheritedPredicate).forEach(conjunct -> {
            Expression rightRewrittenConjunct;
            Expression leftRewrittenConjunct = allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope);
            if (leftRewrittenConjunct != null) {
                leftPushDownConjuncts.add((Object)leftRewrittenConjunct);
            }
            if ((rightRewrittenConjunct = allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)) != null) {
                rightPushDownConjuncts.add((Object)rightRewrittenConjunct);
            }
            if (leftRewrittenConjunct == null && rightRewrittenConjunct == null) {
                joinConjuncts.add(conjunct);
            }
        });
        EqualityInference.nonInferrableConjuncts(metadata, rightEffectivePredicate).map(conjunct -> allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)leftPushDownConjuncts).add(arg_0));
        EqualityInference.nonInferrableConjuncts(metadata, leftEffectivePredicate).map(conjunct -> allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)rightPushDownConjuncts).add(arg_0));
        EqualityInference.nonInferrableConjuncts(metadata, joinPredicate).forEach(conjunct -> {
            Expression rightRewritten;
            Expression leftRewritten = allInference.rewrite((Expression)conjunct, (Set<Symbol>)leftScope);
            if (leftRewritten != null) {
                leftPushDownConjuncts.add((Object)leftRewritten);
            }
            if ((rightRewritten = allInference.rewrite((Expression)conjunct, (Set<Symbol>)rightScope)) != null) {
                rightPushDownConjuncts.add((Object)rightRewritten);
            }
            if (leftRewritten == null && rightRewritten == null) {
                joinConjuncts.add(conjunct);
            }
        });
        return new InnerJoinPushDownResult(IrUtils.combineConjuncts((Collection<Expression>)leftPushDownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)rightPushDownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), BooleanLiteral.TRUE_LITERAL);
    }

    static OuterJoinPushDownResult processLimitedOuterJoin(Metadata metadata, Expression inheritedPredicate, Expression outerEffectivePredicate, Expression innerEffectivePredicate, Expression joinPredicate, Collection<Symbol> outerSymbols, Collection<Symbol> innerSymbols) {
        Preconditions.checkArgument((boolean)outerSymbols.containsAll(SymbolsExtractor.extractUnique(outerEffectivePredicate)), (Object)"outerEffectivePredicate must only contain symbols from outerSymbols");
        Preconditions.checkArgument((boolean)innerSymbols.containsAll(SymbolsExtractor.extractUnique(innerEffectivePredicate)), (Object)"innerEffectivePredicate must only contain symbols from innerSymbols");
        ImmutableList.Builder outerPushdownConjuncts = ImmutableList.builder();
        ImmutableList.Builder innerPushdownConjuncts = ImmutableList.builder();
        ImmutableList.Builder postJoinConjuncts = ImmutableList.builder();
        ImmutableList.Builder joinConjuncts = ImmutableList.builder();
        IrUtils.extractConjuncts(inheritedPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(arg_0 -> ((ImmutableList.Builder)postJoinConjuncts).add(arg_0));
        inheritedPredicate = IrUtils.filterDeterministicConjuncts(inheritedPredicate);
        outerEffectivePredicate = IrUtils.filterDeterministicConjuncts(outerEffectivePredicate);
        innerEffectivePredicate = IrUtils.filterDeterministicConjuncts(innerEffectivePredicate);
        IrUtils.extractConjuncts(joinPredicate).stream().filter(expression -> !DeterminismEvaluator.isDeterministic(expression)).forEach(arg_0 -> ((ImmutableList.Builder)joinConjuncts).add(arg_0));
        joinPredicate = IrUtils.filterDeterministicConjuncts(joinPredicate);
        EqualityInference inheritedInference = new EqualityInference(metadata, inheritedPredicate);
        EqualityInference outerInference = new EqualityInference(metadata, inheritedPredicate, outerEffectivePredicate);
        ImmutableSet innerScope = ImmutableSet.copyOf(innerSymbols);
        ImmutableSet outerScope = ImmutableSet.copyOf(outerSymbols);
        EqualityInference.EqualityPartition equalityPartition = inheritedInference.generateEqualitiesPartitionedBy((Set<Symbol>)outerScope);
        Expression outerOnlyInheritedEqualities = IrUtils.combineConjuncts(equalityPartition.getScopeEqualities());
        EqualityInference potentialNullSymbolInference = new EqualityInference(metadata, outerOnlyInheritedEqualities, outerEffectivePredicate, innerEffectivePredicate, joinPredicate);
        EqualityInference potentialNullSymbolInferenceWithoutInnerInferred = new EqualityInference(metadata, outerOnlyInheritedEqualities, outerEffectivePredicate, joinPredicate);
        innerPushdownConjuncts.addAll(potentialNullSymbolInferenceWithoutInnerInferred.generateEqualitiesPartitionedBy((Set<Symbol>)innerScope).getScopeEqualities());
        EqualityInference.EqualityPartition joinEqualityPartition = new EqualityInference(metadata, joinPredicate).generateEqualitiesPartitionedBy((Set<Symbol>)innerScope);
        innerPushdownConjuncts.addAll(joinEqualityPartition.getScopeEqualities());
        joinConjuncts.addAll(joinEqualityPartition.getScopeComplementEqualities()).addAll(joinEqualityPartition.getScopeStraddlingEqualities());
        outerPushdownConjuncts.addAll(equalityPartition.getScopeEqualities());
        postJoinConjuncts.addAll(equalityPartition.getScopeComplementEqualities());
        postJoinConjuncts.addAll(equalityPartition.getScopeStraddlingEqualities());
        EqualityInference.nonInferrableConjuncts(metadata, inheritedPredicate).forEach(arg_0 -> JoinUtils.lambda$processLimitedOuterJoin$8(outerInference, (Set)outerScope, outerPushdownConjuncts, potentialNullSymbolInference, (Set)innerScope, innerPushdownConjuncts, postJoinConjuncts, arg_0));
        EqualityInference.nonInferrableConjuncts(metadata, outerEffectivePredicate).map(arg_0 -> JoinUtils.lambda$processLimitedOuterJoin$9(potentialNullSymbolInference, (Set)innerScope, arg_0)).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableList.Builder)innerPushdownConjuncts).add(arg_0));
        EqualityInference.nonInferrableConjuncts(metadata, joinPredicate).forEach(arg_0 -> JoinUtils.lambda$processLimitedOuterJoin$10(potentialNullSymbolInference, (Set)innerScope, innerPushdownConjuncts, joinConjuncts, arg_0));
        return new OuterJoinPushDownResult(IrUtils.combineConjuncts((Collection<Expression>)outerPushdownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)innerPushdownConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)joinConjuncts.build()), IrUtils.combineConjuncts((Collection<Expression>)postJoinConjuncts.build()));
    }

    private static /* synthetic */ void lambda$processLimitedOuterJoin$10(EqualityInference potentialNullSymbolInference, Set innerScope, ImmutableList.Builder innerPushdownConjuncts, ImmutableList.Builder joinConjuncts, Expression conjunct) {
        Expression innerRewritten = potentialNullSymbolInference.rewrite(conjunct, innerScope);
        if (innerRewritten != null) {
            innerPushdownConjuncts.add((Object)innerRewritten);
        } else {
            joinConjuncts.add((Object)conjunct);
        }
    }

    private static /* synthetic */ Expression lambda$processLimitedOuterJoin$9(EqualityInference potentialNullSymbolInference, Set innerScope, Expression conjunct) {
        return potentialNullSymbolInference.rewrite(conjunct, innerScope);
    }

    private static /* synthetic */ void lambda$processLimitedOuterJoin$8(EqualityInference outerInference, Set outerScope, ImmutableList.Builder outerPushdownConjuncts, EqualityInference potentialNullSymbolInference, Set innerScope, ImmutableList.Builder innerPushdownConjuncts, ImmutableList.Builder postJoinConjuncts, Expression conjunct) {
        Expression outerRewritten = outerInference.rewrite(conjunct, outerScope);
        if (outerRewritten != null) {
            outerPushdownConjuncts.add((Object)outerRewritten);
            Expression innerRewritten = potentialNullSymbolInference.rewrite(outerRewritten, innerScope);
            if (innerRewritten != null) {
                innerPushdownConjuncts.add((Object)innerRewritten);
            }
        } else {
            postJoinConjuncts.add((Object)conjunct);
        }
    }

    static class InnerJoinPushDownResult {
        private final Expression leftPredicate;
        private final Expression rightPredicate;
        private final Expression joinPredicate;
        private final Expression postJoinPredicate;

        public InnerJoinPushDownResult(Expression leftPredicate, Expression rightPredicate, Expression joinPredicate, Expression postJoinPredicate) {
            this.leftPredicate = leftPredicate;
            this.rightPredicate = rightPredicate;
            this.joinPredicate = joinPredicate;
            this.postJoinPredicate = postJoinPredicate;
        }

        public Expression getLeftPredicate() {
            return this.leftPredicate;
        }

        public Expression getRightPredicate() {
            return this.rightPredicate;
        }

        public Expression getJoinPredicate() {
            return this.joinPredicate;
        }

        public Expression getPostJoinPredicate() {
            return this.postJoinPredicate;
        }
    }

    static class OuterJoinPushDownResult {
        private final Expression outerJoinPredicate;
        private final Expression innerJoinPredicate;
        private final Expression joinPredicate;
        private final Expression postJoinPredicate;

        private OuterJoinPushDownResult(Expression outerJoinPredicate, Expression innerJoinPredicate, Expression joinPredicate, Expression postJoinPredicate) {
            this.outerJoinPredicate = outerJoinPredicate;
            this.innerJoinPredicate = innerJoinPredicate;
            this.joinPredicate = joinPredicate;
            this.postJoinPredicate = postJoinPredicate;
        }

        public Expression getOuterJoinPredicate() {
            return this.outerJoinPredicate;
        }

        public Expression getInnerJoinPredicate() {
            return this.innerJoinPredicate;
        }

        public Expression getJoinPredicate() {
            return this.joinPredicate;
        }

        public Expression getPostJoinPredicate() {
            return this.postJoinPredicate;
        }
    }
}

